/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.period;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.enums.TaxFrequencyEnum;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbs.business.taxperiod.TaxPeriodHelper;

public class TaxPeriodSaveValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if (!"save".equals(operateKey) && !"submit".equals(operateKey)) {
            return;
        }
        List<ExtendedDataEntity> dataEntityList = Arrays.stream(this.getDataEntities()).collect(Collectors.toList());
        Map checkResult = null;
        Set periodIds = Arrays.stream(this.dataEntities).map(entity -> entity.getDataEntity().getString("id")).collect(Collectors.toSet());
        periodIds.removeIf("0"::equals);
        if (!CollectionUtils.isEmpty(periodIds) && StringUtils.isNotBlank((CharSequence)((CharSequence)periodIds.iterator().next()))) {
            BasedataEntityType baseDataEntityType = TaxPeriodHelper.getBaseDataEntityType((String)"sitbs_taxperiod", (String)((String)periodIds.iterator().next()));
            checkResult = TaxPeriodHelper.baseDataCheckReference((BasedataEntityType)baseDataEntityType, (Object[])periodIds.toArray());
        }
        Iterator iterator = dataEntityList.iterator();
        while (iterator.hasNext()) {
            ExtendedDataEntity dataEntity = (ExtendedDataEntity)iterator.next();
            DynamicObject taxPeriod = dataEntity.getDataEntity();
            long frequencyId = taxPeriod.getLong("taxperiodprg.calfrequency.id");
            DynamicObject frequency = new HRBaseServiceHelper("sitbs_calfrequency").loadSingle((Object)frequencyId);
            String frequencyType = frequency.getString("type");
            TaxFrequencyEnum taxFrequencyEnum = TaxFrequencyEnum.valueOf((String)frequencyType);
            int startDate = SitDateUtil.toYearMonth((Date)taxPeriod.getDate("startdate"));
            int endDate = SitDateUtil.toYearMonth((Date)taxPeriod.getDate("enddate"));
            int periodDate = SitDateUtil.toYearMonth((Date)taxPeriod.getDate("perioddate"));
            if (taxFrequencyEnum.equals((Object)TaxFrequencyEnum.MONTH) && startDate != endDate) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9891\u5ea6\u7c7b\u578b\u4e3a\u6708\u7684\u671f\u95f4\uff0c\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u4e0e\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u5e94\u5728\u540c\u4e00\u6708\u4efd\u3002", (String)"TaxPeriodSaveValidator_6", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                iterator.remove();
                continue;
            }
            if (periodDate != endDate) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u5c5e\u5e74\u6708\u4e0e\u671f\u95f4\u5f00\u59cb\u65e5\u671f/\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u6240\u5728\u5e74\u6708\u4e0d\u7b26\uff0c\u53ef\u80fd\u4f1a\u51fa\u73b0\u9519\u8bef\u6570\u636e\u3002", (String)"TaxPeriodSaveValidator_0", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                iterator.remove();
                continue;
            }
            long periodId = taxPeriod.getLong("id");
            if (checkResult != null && checkResult.containsKey(periodId)) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u671f\u95f4\u6570\u636e\u5f15\u7528\u72b6\u6001\u53d1\u751f\u53d8\u66f4\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"TaxPeriodSaveValidator_1", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                iterator.remove();
                continue;
            }
            if (this.validateDate(dataEntity)) continue;
            iterator.remove();
        }
        if (CollectionUtils.isEmpty(dataEntityList)) {
            return;
        }
        Map msgMap = TaxPeriodHelper.validateRepeatDateInDB(dataEntityList);
        this.showResultInfo(msgMap);
        if (CollectionUtils.isEmpty(dataEntityList)) {
            return;
        }
        this.validateNameNumber(dataEntityList);
    }

    private void validateNameNumber(List<ExtendedDataEntity> dataEntityList) {
        DynamicObject[] taxPeriods = (DynamicObject[])dataEntityList.stream().map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        TaxPeriodHelper.setTaxPeriodInfo((DynamicObject[])taxPeriods);
        List numberList = Arrays.stream(taxPeriods).map(po -> po.getString("number")).collect(Collectors.toList());
        List nameList = Arrays.stream(taxPeriods).map(po -> po.getString("name")).collect(Collectors.toList());
        List periodIds = Arrays.stream(taxPeriods).filter(period -> period.getLong("id") != 0L).map(period -> period.getLong("id")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "not in", periodIds);
        QFilter numNameFilter = new QFilter("number", "in", numberList);
        numNameFilter.or("name", "in", nameList);
        HRBaseServiceHelper periodHelper = new HRBaseServiceHelper("sitbs_taxperiod");
        DynamicObject[] periods = periodHelper.query("number,name", new QFilter[]{numNameFilter, idFilter});
        List numberDBList = Arrays.stream(periods).map(po -> po.getString("number")).collect(Collectors.toList());
        List nameDBList = Arrays.stream(periods).map(po -> po.getString("name")).collect(Collectors.toList());
        HashMap<String, ExtendedDataEntity> noRepeatNumberMap = new HashMap<String, ExtendedDataEntity>(nameList.size());
        HashMap<String, ExtendedDataEntity> noRepeatNameMap = new HashMap<String, ExtendedDataEntity>(numberList.size());
        String repeatNumberMsg = ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"TaxPeriodSaveValidator_2", (String)"sit-sitbs-opplugin", (Object[])new Object[0]);
        String repeatNameMsg = ResManager.loadKDString((String)"\u671f\u95f4\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"TaxPeriodSaveValidator_3", (String)"sit-sitbs-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntityList) {
            DynamicObject period2 = dataEntity.getDataEntity();
            String number = period2.getString("number");
            String name = period2.getString("name");
            if (numberDBList.contains(number)) {
                this.addFatalErrorMessage(dataEntity, repeatNumberMsg);
                continue;
            }
            if (nameDBList.contains(name)) {
                this.addFatalErrorMessage(dataEntity, repeatNameMsg);
                continue;
            }
            ExtendedDataEntity repeatNumber = noRepeatNumberMap.putIfAbsent(number, dataEntity);
            if (repeatNumber != null) {
                this.addFatalErrorMessage(repeatNumber, repeatNumberMsg);
                continue;
            }
            ExtendedDataEntity repeatName = noRepeatNameMap.putIfAbsent(name, dataEntity);
            if (repeatName == null) continue;
            this.addFatalErrorMessage(repeatName, repeatNameMsg);
        }
    }

    protected boolean validateDate(ExtendedDataEntity dataEntity) {
        DynamicObject taxPeriod = dataEntity.getDataEntity();
        Date startDate = taxPeriod.getDate("startdate");
        Date endDate = taxPeriod.getDate("enddate");
        if (null != startDate && null != endDate && !startDate.before(endDate)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u987b\u665a\u4e8e\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u3002", (String)"TaxPeriodSaveValidator_4", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return false;
        }
        Date declareStartDate = taxPeriod.getDate("declarestartdate");
        Date declareEndDate = taxPeriod.getDate("declareenddate");
        if (null != declareStartDate && null != declareEndDate && declareEndDate.before(declareStartDate)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u62a5\u7ed3\u675f\u65e5\u671f\u987b\u665a\u4e8e\u6216\u7b49\u4e8e\u7533\u62a5\u5f00\u59cb\u65e5\u671f\u3002", (String)"TaxPeriodSaveValidator_5", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void showResultInfo(ExtendedDataEntity dataEntity, Map<DynamicObject, String> msgMap) {
        if (msgMap.size() != 0) {
            for (Map.Entry<DynamicObject, String> entry : msgMap.entrySet()) {
                this.addErrorMessage(dataEntity, entry.getValue());
            }
        }
    }

    protected void showResultInfo(Map<ExtendedDataEntity, String> msgMap) {
        if (msgMap.size() != 0) {
            for (Map.Entry<ExtendedDataEntity, String> entry : msgMap.entrySet()) {
                this.addFatalErrorMessage(entry.getKey(), entry.getValue());
            }
        }
    }
}

