/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.sinsurarea;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.importutil.ImportFieldChangedService;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;

public class InsuredAreaSaveValidator
extends AbstractValidator {
    private static final List<String> MUST_FIXED_FIELD_COLL = Collections.singletonList("country.id");

    public void validate() {
        if (!"save".equals(this.getOperateKey()) && !"submit".equals(this.getOperateKey())) {
            return;
        }
        ImportFieldChangedService instanceForImport = ImportFieldChangedService.createInstanceForImport((OperateOption)this.getOption(), (ExtendedDataEntity[])this.dataEntities);
        Map appInfo = SInsuranceCommonService.getCountryInfoForAppIdByOption((OperateOption)this.getOption());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String errMsg = SInsuranceCommonService.checkCountryWhenImport((Map)appInfo, (String)dataEntity.getDataEntity().getString("country.id"), (String)SocInsuranceErrInfoEnum.INSURED_AREA_APP_COUNTRY_FAILED.getErrInfo());
            if (HRStringUtils.isNotEmpty((String)errMsg)) {
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            if (instanceForImport == null || !instanceForImport.checkFixedFieldChangedWhenImport(dataEntity, MUST_FIXED_FIELD_COLL)) continue;
            this.addErrorMessage(dataEntity, SocInsuranceErrInfoEnum.INSURANCE_AREA_CAN_NOT_MODIFY_WHEN_IMPORT.getErrInfo());
        }
    }
}

