/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.sinsurbasecalrule;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.sit.sitbp.business.appnum.AppHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.util.ModifyNotAllowedHelper;
import kd.sit.sitbp.business.util.MultiLangHelper;
import kd.sit.sitbs.business.socinsurance.basecalrule.service.SInsurBaseCalRuleService;
import kd.sit.sitbs.business.socinsurance.constants.SInsuranceConstants;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;

public class SInsurBaseCalRuleSaveValidator
extends AbstractValidator {
    private static final List<String> NOT_ALLOWED_MODIFY_FIELDS = Arrays.asList("createorg", "ctrlstrategy");

    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        HashSet<Long> validInsuranceItemIds = new HashSet<Long>(16);
        HashSet<Long> validCalFormulaIds = new HashSet<Long>(16);
        List entities = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Set validFormulaIds = SITPermissionServiceHelper.getValidBaseDataEntityIds(entities, (String)"createorg", (String)"calformula", (String)"entryentity");
        String appId = this.getOption().getVariableValue("currbizappid", null);
        Set countryIds = SITPermissionServiceHelper.getCountrySetByPermItem((String)AppHelper.getAppNumberById((String)appId), (String)"sitbs_basecalrule", (String)"47150e89000000ac");
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRowEntity : entryEntity) {
                long insurItemId = entryRowEntity.getLong("insuritem.id");
                long calFormulaId = entryRowEntity.getLong("calformula.id");
                validInsuranceItemIds.add(insurItemId);
                validCalFormulaIds.add(calFormulaId);
            }
        }
        SInsurBaseCalRuleService sInsurBaseCalRuleService = SInsurBaseCalRuleService.createInstance();
        Map insuranceItemIdAndRefInfoMap = sInsurBaseCalRuleService.getValidPayBaseInsuranceItem(validInsuranceItemIds);
        Map currentCalFormulaVersionInfo = sInsurBaseCalRuleService.getCurrentCalFormulaVersionInfo(validCalFormulaIds, validInsuranceItemIds);
        List cfgDys = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map notAllowedModifyEntityDyMap = ModifyNotAllowedHelper.checkFieldNotAllowedModify(cfgDys, NOT_ALLOWED_MODIFY_FIELDS);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            long currentCountryId = dataEntity.getLong("country.id");
            if (!SInsuranceConstants.COUNTRY_ID_CHINA.equals(currentCountryId)) {
                this.addErrorMessage(extendedDataEntity, SocInsuranceErrInfoEnum.BASE_CAL_RULE_FOR_COUNTRY_NOT_CHINA.getErrInfo(new Object[]{SocInsuranceErrInfoEnum.COMMON_COUNTRY_CHINA}));
                continue;
            }
            if (countryIds != null && !countryIds.contains(currentCountryId)) {
                this.addErrorMessage(extendedDataEntity, SocInsuranceErrInfoEnum.PERIOD_TYPE_WITHOUT_COUNTRY_PERMISSION.getErrInfo(new Object[]{dataEntity.getString("country.name")}));
                continue;
            }
            String notAllowedModifyFieldMsg = (String)notAllowedModifyEntityDyMap.get(dataEntity);
            if (notAllowedModifyFieldMsg != null) {
                this.addErrorMessage(extendedDataEntity, notAllowedModifyFieldMsg);
            }
            Date bsed = dataEntity.getDate("bsed");
            long createOrgId = dataEntity.getLong("createorg.id");
            if (bsed == null || createOrgId == 0L) continue;
            HashSet<Long> nonRepetitiveInsuranceItemIds = new HashSet<Long>(16);
            HashSet<Long> nonRepetitiveCalFormulaIds = new HashSet<Long>(16);
            StringJoiner invalidInsuranceItemSJ = new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter());
            StringJoiner repetitiveInsuranceItemSJ = new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter());
            StringJoiner repetitiveCalFormulaSJ = new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter());
            StringJoiner calFormulaNotExistsValidVersionSJ = new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter());
            StringJoiner inconsistentForCalFormulaItemSJ = new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter());
            StringJoiner inconsistentForCalFormulaCreateOrgSJ = new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter());
            StringJoiner noValidFormulaVersionSJ = new StringJoiner(MultiLangHelper.getMultiLangCommaDelimiter());
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryRowEntity : entryEntity) {
                long insuranceItemId = entryRowEntity.getLong("insuritem.id");
                if (insuranceItemId == 0L) continue;
                DynamicObject insuranceItemDy = (DynamicObject)insuranceItemIdAndRefInfoMap.get(insuranceItemId);
                String lineNo = entryRowEntity.getString("seq");
                if (insuranceItemDy == null || insuranceItemDy.getLong("country.id") != currentCountryId) {
                    invalidInsuranceItemSJ.add(lineNo);
                    continue;
                }
                if (nonRepetitiveInsuranceItemIds.contains(insuranceItemId)) {
                    repetitiveInsuranceItemSJ.add(lineNo);
                    continue;
                }
                nonRepetitiveInsuranceItemIds.add(insuranceItemId);
                long calFormulaId = entryRowEntity.getLong("calformula.id");
                if (calFormulaId == 0L) continue;
                if (nonRepetitiveCalFormulaIds.contains(calFormulaId)) {
                    repetitiveCalFormulaSJ.add(lineNo);
                    continue;
                }
                nonRepetitiveCalFormulaIds.add(calFormulaId);
                DynamicObject currentCalFormulaVDy = (DynamicObject)currentCalFormulaVersionInfo.get(calFormulaId);
                if (currentCalFormulaVDy == null) {
                    calFormulaNotExistsValidVersionSJ.add(lineNo);
                    continue;
                }
                if (!validFormulaIds.contains(calFormulaId)) {
                    inconsistentForCalFormulaCreateOrgSJ.add(lineNo);
                    continue;
                }
                if (currentCalFormulaVDy.getLong("resultitem.id") != insuranceItemId) {
                    inconsistentForCalFormulaItemSJ.add(lineNo);
                    continue;
                }
                boolean noValidFormulaVersion = currentCalFormulaVDy.getDate("firstbsed") == null || currentCalFormulaVDy.getDate("firstbsed").compareTo(bsed) > 0;
                if (!noValidFormulaVersion) continue;
                noValidFormulaVersionSJ.add(lineNo);
            }
            if (invalidInsuranceItemSJ.length() > 0) {
                this.addErrorMessage(extendedDataEntity, SocInsuranceErrInfoEnum.BASE_CAL_RULE_FOR_INSURANCE_ITEM_INVALID.getErrInfo(new Object[]{invalidInsuranceItemSJ.toString()}));
                continue;
            }
            if (repetitiveInsuranceItemSJ.length() > 0) {
                this.addErrorMessage(extendedDataEntity, SocInsuranceErrInfoEnum.BASE_CAL_RULE_FOR_INSURANCE_ITEM_REPETITIVE.getErrInfo(new Object[]{repetitiveInsuranceItemSJ.toString()}));
                continue;
            }
            if (repetitiveCalFormulaSJ.length() > 0) {
                this.addErrorMessage(extendedDataEntity, SocInsuranceErrInfoEnum.BASE_CAL_RULE_FOR_CAL_FORMULA_REPETITIVE.getErrInfo(new Object[]{repetitiveCalFormulaSJ.toString()}));
                continue;
            }
            if (calFormulaNotExistsValidVersionSJ.length() > 0) {
                this.addErrorMessage(extendedDataEntity, SocInsuranceErrInfoEnum.BASE_CAL_RULE_FOR_CAL_FORMULA_NOT_EXISTS_VALID_VERSION.getErrInfo(new Object[]{calFormulaNotExistsValidVersionSJ.toString()}));
                continue;
            }
            if (inconsistentForCalFormulaCreateOrgSJ.length() > 0) {
                this.addErrorMessage(extendedDataEntity, SocInsuranceErrInfoEnum.BASE_CAL_RULE_FOR_CAL_FORMULA_CREATE_ORG_INVALID.getErrInfo(new Object[]{inconsistentForCalFormulaCreateOrgSJ.toString()}));
                continue;
            }
            if (inconsistentForCalFormulaItemSJ.length() > 0) {
                this.addErrorMessage(extendedDataEntity, SocInsuranceErrInfoEnum.BASE_CAL_RULE_FOR_CAL_FORMULA_AND_ITEM_INCONSISTENT.getErrInfo(new Object[]{inconsistentForCalFormulaItemSJ.toString()}));
                continue;
            }
            if (noValidFormulaVersionSJ.length() <= 0) continue;
            this.addErrorMessage(extendedDataEntity, SocInsuranceErrInfoEnum.BASE_CAL_RULE_FOR_NOT_EXISTS_CAL_FORMULA_VERSION.getErrInfo(new Object[]{noValidFormulaVersionSJ.toString()}));
        }
    }
}

