/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.sinsurbasefetchitem;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.util.ModifyNotAllowedHelper;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;

public class SocInsuranceBaseFetchItemSaveValidator
extends AbstractValidator {
    private static final List<String> NOT_ALLOWED_MODIFY_FIELDS = Arrays.asList("createorg", "ctrlstrategy");

    public void validate() {
        if (ArrayUtils.isEmpty((Object[])this.getDataEntities())) {
            return;
        }
        Map appInfo = SInsuranceCommonService.getCountryInfoForAppIdByOption((OperateOption)this.getOption());
        List cfgDys = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map notAllowedModifyEntityDyMap = ModifyNotAllowedHelper.checkFieldNotAllowedModify(cfgDys, NOT_ALLOWED_MODIFY_FIELDS);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            String notAllowedModifyFieldMsg;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String errMsg = SInsuranceCommonService.checkCountryWhenImport((Map)appInfo, (String)dataEntity.getString("country.id"), (String)SocInsuranceErrInfoEnum.BASE_FETCH_ITEM_FOR_APP_COUNTRY_FAILED.getErrInfo());
            if (HRStringUtils.isNotEmpty((String)errMsg)) {
                this.addErrorMessage(extendedDataEntity, errMsg);
            }
            if ((notAllowedModifyFieldMsg = (String)notAllowedModifyEntityDyMap.get(dataEntity)) == null) continue;
            this.addErrorMessage(extendedDataEntity, notAllowedModifyFieldMsg);
        }
    }
}

