/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.sinsuritem;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.helper.mandatory.MandatoryHelper;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import org.apache.commons.lang.StringUtils;

public class InsuranceItemSaveValidator
extends AbstractValidator {
    private static final String INSURANCE_TYPE = "group";
    private static final String COUNTRY = "country";
    private static final String INSURANCE_TYPE_ATTR = "insurancetypeattr";
    private static final String DATA_TYPE = "datatype";
    private static final String DATA_TYPE_ID = "datatype.id";
    private static final String DATA_PRECISION = "dataprecision";
    private static final String DATA_PRECISION_ID = "dataprecision.id";
    private static final String[] MUST_INPUT_FIELDS = new String[]{"number", "group", "country", "insurancetypeattr", "datatype"};
    private static final List<String> MANDATORY_FIELDS = Arrays.asList("group", "country", "insurancetypeattr", "datatype", "dataround");

    public void validate() {
        if (!"save".equals(this.getOperateKey()) && !"submit".equals(this.getOperateKey())) {
            return;
        }
        Map appInfo = SInsuranceCommonService.getCountryInfoForAppIdByOption((OperateOption)this.getOption());
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        LinkedHashSet<ExtendedDataEntity> normalExtendedDataEntitySet = new LinkedHashSet<ExtendedDataEntity>(Arrays.asList(dataEntities));
        HashSet groupIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet insIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet currentNumSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashMap groupMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        StringBuilder sbd = new StringBuilder();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            StringJoiner errMandatoryFields;
            String errMsg = SInsuranceCommonService.checkCountryWhenImport((Map)appInfo, (String)dataEntity.getDataEntity().getString("country.id"), (String)SocInsuranceErrInfoEnum.INSURANCE_ITEM_APP_COUNTRY_FAILED.getErrInfo());
            if (HRStringUtils.isNotEmpty((String)errMsg)) {
                this.addErrorMessage(dataEntity, errMsg);
            }
            if ((errMandatoryFields = MandatoryHelper.checkMandatoryField((DynamicObject)dataEntity.getDataEntity(), MANDATORY_FIELDS)).length() != 0) {
                this.addErrorMessage(dataEntity, SocInsuranceErrInfoEnum.INSURANCE_ATTR_IS_NULL.getErrInfo(new Object[]{errMandatoryFields.toString()}));
                continue;
            }
            if (this.baseCheck(dataEntity)) {
                normalExtendedDataEntitySet.remove(dataEntity);
            }
            Long insuranceId = dataEntity.getDataEntity().getDynamicObject(INSURANCE_TYPE).getLong("id");
            Long insId = dataEntity.getDataEntity().getDynamicObject(INSURANCE_TYPE_ATTR).getLong("id");
            sbd.append(insuranceId).append('-').append(insId);
            String data = sbd.toString();
            sbd.setLength(0);
            if (groupMap.containsKey(data)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u5b58\u5728\u6570\u636e\u7684\u9669\u79cd\u548c\u9669\u79cd\u5c5e\u6027\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u3002", (String)"InsuranceTypeProSaveValidator_0", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                normalExtendedDataEntitySet.remove(dataEntity);
                continue;
            }
            groupIdSet.add(insuranceId);
            insIdSet.add(insId);
            currentNumSet.add(dataEntity.getDataEntity().getString("number"));
            groupMap.put(data, dataEntity);
        }
        if (!CollectionUtils.isEmpty((Collection)groupIdSet)) {
            DynamicObject[] contrTypes;
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_insuranceitem");
            QFilter contrTypeFilter = new QFilter(INSURANCE_TYPE, "in", (Object)groupIdSet);
            contrTypeFilter.and(new QFilter("insurancetypeattr.id", "in", (Object)insIdSet));
            contrTypeFilter.and("number", "not in", (Object)currentNumSet);
            for (DynamicObject dynamicObject : contrTypes = serviceHelper.query("group.id,insurancetypeattr.id", new QFilter[]{contrTypeFilter})) {
                Long insuranceId = dynamicObject.getLong("group.id");
                Long insId = dynamicObject.getLong("insurancetypeattr.id");
                sbd.append(insuranceId).append('-').append(insId);
                String data = sbd.toString();
                sbd.setLength(0);
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)groupMap.get(data);
                if (dataEntity == null) continue;
                normalExtendedDataEntitySet.remove(dataEntity);
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"{0} \u5df2\u5b58\u5728\u5e26\u6709 {1} \u7684\u9669\u79cd\u9879\u76ee\u3002", (String)"InsuranceTypeProSaveValidator_1", (String)"sit-sitbs-opplugin", (Object[])new Object[]{dataEntity.getDataEntity().getString("group.name"), dataEntity.getDataEntity().getString("insurancetypeattr.name")}));
            }
        }
        this.checkImportData(normalExtendedDataEntitySet);
    }

    private boolean baseCheck(ExtendedDataEntity dataEntity) {
        String insuranceTypeName;
        boolean isInvalid = false;
        DynamicObject insuranceItemDy = dataEntity.getDataEntity();
        DynamicObject insuranceDynamicObject = insuranceItemDy.getDynamicObject(INSURANCE_TYPE);
        DynamicObject insuranceCountry = insuranceDynamicObject.getDynamicObject(COUNTRY);
        DynamicObject insuranceTypeDy = insuranceItemDy.getDynamicObject(INSURANCE_TYPE_ATTR);
        DynamicObject insuranceTypeCountry = insuranceTypeDy.getDynamicObject(COUNTRY);
        DynamicObject currentCountry = insuranceItemDy.getDynamicObject(COUNTRY);
        String insuranceName = insuranceItemDy.getString("name");
        if (!StringUtils.equals((String)currentCountry.getString("number"), (String)insuranceCountry.getString("number"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9669\u79cd\u9879\u76ee {0} \u7684\u56fd\u5bb6\u5730\u533a\u4e0e\u9669\u79cd\u7684\u56fd\u5bb6\u5730\u533a\u4e0d\u5339\u914d\u3002", (String)"InsuranceTypeProSaveValidator_3", (String)"sit-sitbs-opplugin", (Object[])new Object[]{insuranceName}));
            isInvalid = true;
        }
        if (!StringUtils.equals((String)currentCountry.getString("number"), (String)insuranceTypeCountry.getString("number"))) {
            insuranceTypeName = insuranceTypeDy.getString("name");
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9669\u79cd\u9879\u76ee {0} \u7684\u56fd\u5bb6\u5730\u533a\u4e0e\u9669\u79cd\u5c5e\u6027 {1} \u7684\u56fd\u5bb6\u5730\u533a\u4e0d\u5339\u914d\u3002", (String)"InsuranceTypeProSaveValidator_4", (String)"sit-sitbs-opplugin", (Object[])new Object[]{insuranceName, insuranceTypeName}));
            isInvalid = true;
        }
        if (!StringUtils.equals((String)insuranceItemDy.getString("datatype.number"), (String)insuranceTypeDy.getString("datatype.number"))) {
            insuranceTypeName = insuranceTypeDy.getString("name");
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9669\u79cd\u9879\u76ee {0} \u7684\u6570\u636e\u7c7b\u578b\u4e0e\u9669\u79cd\u5c5e\u6027 {1} \u7684\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"InsuranceTypeProSaveValidator_7", (String)"sit-sitbs-opplugin", (Object[])new Object[]{insuranceName, insuranceTypeName}));
            isInvalid = true;
        }
        if (insuranceItemDy.getLong(DATA_TYPE_ID) == SitDataTypeEnum.NUMBER.getId()) {
            DynamicObject dataPrecision = insuranceItemDy.getDynamicObject(DATA_PRECISION);
            if (HRObjectUtils.isEmpty((Object)dataPrecision)) {
                insuranceItemDy.set(DATA_PRECISION, (Object)insuranceTypeDy.getLong(DATA_PRECISION_ID));
            }
        } else if (insuranceItemDy.getLong(DATA_TYPE_ID) == SitDataTypeEnum.AMOUNT.getId()) {
            insuranceItemDy.set(DATA_PRECISION, null);
        }
        if (!currentCountry.getBoolean("enable")) {
            String name = currentCountry.getString("name");
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a {0} \u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"InsuranceTypeProSaveValidator_5", (String)"sit-sitbs-opplugin", (Object[])new Object[]{name}));
            isInvalid = true;
        }
        if (!insuranceTypeDy.getBoolean("enable")) {
            insuranceTypeName = insuranceTypeDy.getString("name");
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9669\u79cd\u5c5e\u6027 {0} \u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"InsuranceTypeProSaveValidator_6", (String)"sit-sitbs-opplugin", (Object[])new Object[]{insuranceTypeName}));
            isInvalid = true;
        }
        return isInvalid;
    }

    private void checkImportData(Set<ExtendedDataEntity> normalExtendedDataEntitySet) {
        if (!normalExtendedDataEntitySet.isEmpty() && this.getOption().tryGetVariableValue("importtag_of_datasource", new RefObject((Object)Boolean.TRUE.toString()))) {
            HashSet insuranceItemIds = Sets.newHashSetWithExpectedSize((int)normalExtendedDataEntitySet.size());
            for (ExtendedDataEntity extendedDataEntity : normalExtendedDataEntitySet) {
                long insuranceItemId = extendedDataEntity.getDataEntity().getLong("id");
                if (insuranceItemId == 0L) continue;
                insuranceItemIds.add(insuranceItemId);
            }
            if (!insuranceItemIds.isEmpty()) {
                HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_insuranceitem");
                QFilter filter = new QFilter("id", "in", (Object)insuranceItemIds);
                DynamicObject[] dataStorageColl = helper.query("number,name,group,country,insurancetypeattr,datatype", new QFilter[]{filter});
                HashMap<Long, DynamicObject> dataStorageMap = new HashMap<Long, DynamicObject>(dataStorageColl.length);
                for (DynamicObject dataStorage : dataStorageColl) {
                    long id = dataStorage.getLong("id");
                    dataStorageMap.put(id, dataStorage);
                }
                for (ExtendedDataEntity extendedDataEntity : normalExtendedDataEntitySet) {
                    long id = extendedDataEntity.getDataEntity().getLong("id");
                    if (id == 0L || dataStorageMap.get(id) == null) continue;
                    DynamicObject dataStorage = (DynamicObject)dataStorageMap.get(id);
                    for (String field : MUST_INPUT_FIELDS) {
                        extendedDataEntity.getDataEntity().set(field, dataStorage.get(field));
                    }
                }
            }
        }
    }
}

