/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.sinsurperiod;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sit.sitbp.business.helper.mandatory.MandatoryHelper;
import kd.sit.sitbp.common.enums.FrequencyEnum;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.period.helper.SocInsurancePeriodHelper;

public class SocInsurancePeriodSaveValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if (!"save".equals(operateKey) && !"submit".equals(operateKey)) {
            return;
        }
        List<ExtendedDataEntity> dataEntityList = Arrays.stream(this.getDataEntities()).collect(Collectors.toList());
        Map checkResult = null;
        Set periodIds = dataEntityList.stream().map(entity -> entity.getDataEntity().getString("id")).collect(Collectors.toSet());
        periodIds.removeIf("0"::equals);
        if (!CollectionUtils.isEmpty(periodIds) && StringUtils.isNotBlank((CharSequence)((CharSequence)periodIds.iterator().next()))) {
            BasedataEntityType baseDataEntityType = SocInsurancePeriodHelper.getBaseDataEntityType((String)"sitbs_sinsurperiod", (String)((String)periodIds.iterator().next()));
            checkResult = SocInsurancePeriodHelper.baseDataCheckReference((BasedataEntityType)baseDataEntityType, (Object[])periodIds.toArray());
        }
        this.valideData(dataEntityList, checkResult);
        if (CollectionUtils.isEmpty(dataEntityList)) {
            return;
        }
        Map msgMap = SocInsurancePeriodHelper.validateRepeatDateInDB(dataEntityList);
        for (Map.Entry entry : msgMap.entrySet()) {
            this.addFatalErrorMessage((ExtendedDataEntity)entry.getKey(), (String)entry.getValue());
        }
        if (CollectionUtils.isEmpty(dataEntityList)) {
            return;
        }
        this.validateNameNumber(dataEntityList);
    }

    private void valideData(List<ExtendedDataEntity> dataEntityList, Map<Object, BaseDataCheckRefrenceResult> checkResult) {
        Iterator<ExtendedDataEntity> iterator = dataEntityList.iterator();
        while (iterator.hasNext()) {
            ExtendedDataEntity dataEntity = iterator.next();
            DynamicObject periodDy = dataEntity.getDataEntity();
            StringJoiner errMandatoryFields = MandatoryHelper.checkMandatoryField((DynamicObject)dataEntity.getDataEntity(), Collections.singletonList("periodtype"));
            if (errMandatoryFields.length() != 0) {
                iterator.remove();
                continue;
            }
            DynamicObject frequency = SocInsurancePeriodHelper.getFrequencyDy((Long)periodDy.getLong("periodtype.calfrequency.id"));
            if (HRObjectUtils.isEmpty((Object)frequency)) continue;
            String frequencyType = frequency.getString("type");
            FrequencyEnum frequencyEnum = FrequencyEnum.valueOf((String)frequencyType);
            Date periodStartDate = periodDy.getDate("startdate");
            Date periodEndDate = periodDy.getDate("enddate");
            if (periodStartDate == null || periodEndDate == null) {
                this.addFatalErrorMessage(dataEntity, SocInsuranceErrInfoEnum.PERIOD_START_DATE_AND_END_DATE_ALL_MUST_INPUT.getErrInfo());
                iterator.remove();
                continue;
            }
            int startDate = SitDateUtil.toYearMonth((Date)periodStartDate);
            int endDate = SitDateUtil.toYearMonth((Date)periodEndDate);
            Date periodDate = periodDy.getDate("perioddate");
            int periodDateInt = SitDateUtil.toYearMonth((Date)periodDate);
            if (periodDate == null) {
                this.addFatalErrorMessage(dataEntity, SocInsuranceErrInfoEnum.PERIOD_DATE_MUST_INPUT.getErrInfo());
                iterator.remove();
                continue;
            }
            if (frequencyEnum.equals((Object)FrequencyEnum.MONTH) && startDate != endDate) {
                this.addFatalErrorMessage(dataEntity, SocInsuranceErrInfoEnum.PERIOD_START_AND_END_DATE_MUST_SAME.getErrInfo());
                iterator.remove();
                continue;
            }
            if (frequencyEnum.equals((Object)FrequencyEnum.MONTH) && periodDateInt != endDate) {
                this.addFatalErrorMessage(dataEntity, SocInsuranceErrInfoEnum.PERIOD_YEAR_AND_MONTH_ERROR.getErrInfo());
                iterator.remove();
                continue;
            }
            if (checkResult != null && checkResult.containsKey(periodDy.getLong("id"))) {
                this.addFatalErrorMessage(dataEntity, SocInsuranceErrInfoEnum.PERIOD_REF_CHANGED.getErrInfo());
                iterator.remove();
                continue;
            }
            if (periodStartDate == null || periodEndDate == null || periodStartDate.before(periodEndDate)) continue;
            this.addFatalErrorMessage(dataEntity, SocInsuranceErrInfoEnum.START_TIME_CAN_MUST_BEFORE_END_TIME.getErrInfo());
            iterator.remove();
        }
    }

    private void validateNameNumber(List<ExtendedDataEntity> dataEntityList) {
        Object[] periodDys = (DynamicObject[])dataEntityList.stream().map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        if (ArrayUtils.isEmpty((Object[])periodDys)) {
            return;
        }
        long periodTypeId = periodDys[0].getLong("periodtype.id");
        SocInsurancePeriodHelper.setPeriodInfo((DynamicObject[])periodDys);
        HashSet numberInPageSet = new HashSet(periodDys.length);
        HashSet nameInPageSet = new HashSet(periodDys.length);
        Arrays.stream(periodDys).forEach(periodDy -> {
            numberInPageSet.add(periodDy.getString("number"));
            nameInPageSet.add(periodDy.getString("name"));
        });
        List periodIds = Arrays.stream(periodDys).filter(period -> period.getLong("id") != 0L).map(period -> period.getLong("id")).collect(Collectors.toList());
        List periodDysInDB = SocInsurancePeriodHelper.queryPeriodDys((String)"number,name", (QFilter)SocInsurancePeriodHelper.getPeriodQFilter(numberInPageSet, nameInPageSet, (Long)periodTypeId, periodIds));
        HashSet numberInDBSet = new HashSet(periodDysInDB.size());
        HashSet nameInDBSet = new HashSet(periodDysInDB.size());
        periodDysInDB.forEach(periodDy -> {
            numberInDBSet.add(periodDy.getString("number"));
            nameInDBSet.add(periodDy.getString("name"));
        });
        HashMap<String, ExtendedDataEntity> noRepeatNumberMap = new HashMap<String, ExtendedDataEntity>(nameInPageSet.size());
        HashMap<String, ExtendedDataEntity> noRepeatNameMap = new HashMap<String, ExtendedDataEntity>(numberInPageSet.size());
        for (ExtendedDataEntity dataEntity : dataEntityList) {
            DynamicObject period2 = dataEntity.getDataEntity();
            String number = period2.getString("number");
            String name = period2.getString("name");
            if (numberInDBSet.contains(number)) {
                this.addFatalErrorMessage(dataEntity, SocInsuranceErrInfoEnum.PERIOD_NUMBER_REPEAT.getErrInfo(new Object[]{periodDys[0].getString("periodtype.name"), number}));
                continue;
            }
            if (nameInDBSet.contains(name)) {
                this.addFatalErrorMessage(dataEntity, SocInsuranceErrInfoEnum.PERIOD_NAME_REPEAT.getErrInfo(new Object[]{periodDys[0].getString("periodtype.name"), name}));
                continue;
            }
            ExtendedDataEntity repeatNumber = noRepeatNumberMap.putIfAbsent(number, dataEntity);
            if (repeatNumber != null) {
                this.addFatalErrorMessage(repeatNumber, SocInsuranceErrInfoEnum.PERIOD_NUMBER_REPEAT.getErrInfo(new Object[]{repeatNumber.getDataEntity().getString("periodtype.name"), number}));
                continue;
            }
            ExtendedDataEntity repeatName = noRepeatNameMap.putIfAbsent(name, dataEntity);
            if (repeatName == null) continue;
            this.addFatalErrorMessage(repeatName, SocInsuranceErrInfoEnum.PERIOD_NAME_REPEAT.getErrInfo(new Object[]{repeatName.getDataEntity().getString("periodtype.name"), name}));
        }
    }
}

