/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.sinsurperiod;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.common.enums.FrequencyEnum;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.period.helper.SocInsurancePeriodHelper;

public class SocInsurancePeriodTypeSaveValidator
extends AbstractValidator {
    private static final Set<String> serialNumbers = Sets.newHashSet((Object[])new String[]{"1", "2"});

    public void validate() {
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            ExtendedDataEntity[] dataEntities;
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                DynamicObject periodTypeDy = dataEntity.getDataEntity();
                String frequencyType = periodTypeDy.getString("calfrequency.type");
                if (HRStringUtils.isEmpty((String)frequencyType)) continue;
                FrequencyEnum frequencyEnum = FrequencyEnum.valueOf((String)frequencyType);
                if (!(FrequencyEnum.YEAR != frequencyEnum && FrequencyEnum.HALF_YEAR != frequencyEnum && FrequencyEnum.SEASON != frequencyEnum || serialNumbers.contains(periodTypeDy.getString("serialnumber")))) {
                    this.addFatalErrorMessage(dataEntity, SocInsuranceErrInfoEnum.PERIOD_FREQUENCY_REPEAT.getErrInfo());
                } else if (FrequencyEnum.MONTH == frequencyEnum && HRStringUtils.isEmpty((String)periodTypeDy.getString("endday"))) {
                    this.addFatalErrorMessage(dataEntity, SocInsuranceErrInfoEnum.MUST_INPUT_END_DAY.getErrInfo());
                }
                QFilter periodTypeQFilter = SocInsurancePeriodHelper.getPeriodTypeQFilter((Long)periodTypeDy.getLong("country.id"), (String)frequencyEnum.toString(), (Long)periodTypeDy.getLong("id"));
                List periodTypeDys = SocInsurancePeriodHelper.queryPeriodTypeDys((String)"id,country.id,calfrequency.name", (QFilter)periodTypeQFilter);
                if (CollectionUtils.isEmpty((Collection)periodTypeDys) || periodTypeDys.get(0) == null) continue;
                this.addFatalErrorMessage(dataEntity, SocInsuranceErrInfoEnum.PERIOD_TYPE_REPEAT.getErrInfo(new Object[]{frequencyEnum.getI18nName().loadKDString()}));
            }
        }
    }
}

