/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.sinsurstandardcfg;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.standardcfg.helper.SocInsuranceStandardCfgHelper;
import kd.sit.sitbs.business.socinsurance.standardcfg.service.SocInsuranceStandardCfgService;

public class SInsurStandardCfgSaveValidator
extends AbstractValidator {
    private static final Set<String> NEED_CHECK_INSUR_TYPE_REPEATED_OPERATORS = Sets.newHashSet((Object[])new String[]{"save", "submit", "audit", "changesave", "auditconfirmchange", "confirmchange"});

    public void validate() {
        boolean needCheckResultEntity;
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities.length == 0) {
            return;
        }
        boolean isUpgrade = this.getOption().tryGetVariableValue("isUpgrade", new RefObject((Object)Boolean.TRUE.toString()));
        if (!isUpgrade && NEED_CHECK_INSUR_TYPE_REPEATED_OPERATORS.contains(operateKey)) {
            Map auditAndEnableInsurTypeCfgs = SocInsuranceStandardCfgHelper.queryAuditAndEnableInsurTypeCfgs();
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject cfgInfoDy = dataEntity.getDataEntity();
                long countryId = cfgInfoDy.getLong("country.id");
                long insurTypeId = cfgInfoDy.getLong("insurtype.id");
                String key = countryId + "," + insurTypeId;
                DynamicObject auditAndEnableCfgDy = (DynamicObject)auditAndEnableInsurTypeCfgs.get(key);
                if (auditAndEnableCfgDy != null && cfgInfoDy.getLong("boid") != auditAndEnableCfgDy.getLong("boid")) {
                    String errInfo2 = SocInsuranceErrInfoEnum.INSUR_TYPE_EXISTS_FOR_SAME_COUNTRY_AND_STD_CFG.getErrInfo(new Object[]{cfgInfoDy.getString("insurtype.name"), auditAndEnableCfgDy.getString("name")});
                    this.addFatalErrorMessage(dataEntity, errInfo2);
                    continue;
                }
                if (!"audit".equals(operateKey) || !"B".equals(cfgInfoDy.getString("status"))) continue;
                auditAndEnableInsurTypeCfgs.put(key, cfgInfoDy);
            }
        }
        boolean bl = needCheckResultEntity = dataEntities.length == 1 && this.getOption().tryGetVariableValue("is_detail_view", new RefObject((Object)Boolean.TRUE.toString()));
        if (needCheckResultEntity) {
            ExtendedDataEntity dataEntity = dataEntities[0];
            DynamicObject cfgInfoDy = dataEntity.getDataEntity();
            SocInsuranceStandardCfgService cfgService = SocInsuranceStandardCfgService.createInstance();
            List errorInfoList = cfgService.getErrorInfoList(cfgInfoDy.getDynamicObjectCollection("rentryentity"));
            errorInfoList.forEach(errInfo -> this.addFatalErrorMessage(dataEntity, (String)errInfo));
        }
    }
}

