/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.sinsurtype;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.helper.mandatory.MandatoryHelper;
import kd.sit.sitbp.business.importutil.ImportFieldChangedService;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import org.apache.commons.lang.StringUtils;

public class SocInsuranceTypeSaveValidator
extends AbstractValidator {
    private static final String RNB_NUMBER = "CNY";
    private static final Set<String> MUST_FIXED_FIELD_SET = new LinkedHashSet<String>(Arrays.asList("number", "country.id"));
    private static final List<String> MANDATORY_FIELDS = Arrays.asList("number", "name", "country", "currency");

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        if (!"save".equals(this.getOperateKey())) {
            return;
        }
        ImportFieldChangedService instanceForImport = ImportFieldChangedService.createInstanceForImport((OperateOption)this.getOption(), (ExtendedDataEntity[])this.dataEntities);
        Map appInfo = SInsuranceCommonService.getCountryInfoForAppIdByOption((OperateOption)this.getOption());
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String errMsg = SInsuranceCommonService.checkCountryWhenImport((Map)appInfo, (String)dataEntity.getDataEntity().getString("country.id"), (String)SocInsuranceErrInfoEnum.INSURANCE_TYPE_APP_COUNTRY_FAILED.getErrInfo());
            if (HRStringUtils.isNotEmpty((String)errMsg)) {
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            StringJoiner errMandatoryFields = MandatoryHelper.checkMandatoryField((DynamicObject)dataEntity.getDataEntity(), MANDATORY_FIELDS);
            if (errMandatoryFields.length() != 0) continue;
            DynamicObject currencyDynamicObject = dynamicObject.getDynamicObject("currency");
            DynamicObject currentCountry = dynamicObject.getDynamicObject("country");
            long countryId = currencyDynamicObject.getLong("id");
            String currencyNumber = currencyDynamicObject.getString("number");
            if (instanceForImport != null) {
                if (instanceForImport.checkFixedFieldChangedWhenImport(dataEntity, MUST_FIXED_FIELD_SET)) {
                    this.addErrorMessage(dataEntity, SocInsuranceErrInfoEnum.INSURANCE_TYPE_CAN_NOT_MODIFY_WHEN_IMPORT.getErrInfo());
                    continue;
                }
                Map importDyMapForChina = instanceForImport.getImportDyMapForChina();
                if (!(importDyMapForChina == null || importDyMapForChina.get(dynamicObject.getLong("id")) == null || Long.parseLong("1000001") == countryId && StringUtils.equals((String)currencyNumber, (String)RNB_NUMBER))) {
                    this.addErrorMessage(dataEntity, SocInsuranceErrInfoEnum.INSURANCE_TYPE_COUNTRY_CURRENCY_ERROR.getErrInfo());
                    continue;
                }
            }
            if (Long.parseLong("1000001") == countryId && !StringUtils.equals((String)currencyNumber, (String)RNB_NUMBER)) {
                this.addErrorMessage(dataEntity, SocInsuranceErrInfoEnum.INSURANCE_TYPE_COUNTRY_CURRENCY_ERROR.getErrInfo());
            }
            if (!currentCountry.getBoolean("enable")) {
                String countryName = currentCountry.getString("name");
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a {0} \u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"InsuranceTypeProSaveValidator_5", (String)"sit-sitbs-opplugin", (Object[])new Object[]{countryName}));
            }
            if (currencyDynamicObject.getBoolean("enable")) continue;
            String currencyName = currencyDynamicObject.getString("name");
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e01\u79cd {0} \u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"WelfareTypeSaveValidator_2", (String)"sit-sitbs-opplugin", (Object[])new Object[]{currencyName}));
        }
    }
}

