/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.taxitemlibrary;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbs.business.taxitemlibrary.TaxItemHelper;

public class TaxItemEnableValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List allAuditedAndEnableTaxItems = TaxItemHelper.getAllAuditedAndEnableTaxItemsBy((Long)1000001L);
        if (CollectionUtils.isEmpty((Collection)allAuditedAndEnableTaxItems)) {
            return;
        }
        Set excludeIdSet = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        List filterTaxItems = allAuditedAndEnableTaxItems.stream().filter(dy -> !excludeIdSet.contains(dy.getLong("id"))).collect(Collectors.toList());
        Map<String, List<DynamicObject>> numberMap = filterTaxItems.stream().collect(Collectors.groupingBy(ex -> ex.getString("number")));
        Map<String, List<DynamicObject>> nameMap = filterTaxItems.stream().collect(Collectors.groupingBy(ex -> ex.getString("name")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String number = dynamicObject.getString("number");
            String name = dynamicObject.getString("name");
            if (!CollectionUtils.isEmpty((Collection)numberMap.get(number))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d \u503c \u201c{0}\u201d \u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u542f\u7528\u3002", (String)"TaxItemEnableValidator_0", (String)"sit-sitbs-opplugin", (Object[])new Object[]{number}));
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)nameMap.get(name))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d \u503c \u201c{0}\u201d \u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u542f\u7528\u3002", (String)"TaxItemEnableValidator_1", (String)"sit-sitbs-opplugin", (Object[])new Object[]{name}));
        }
    }
}

