/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.taxitemlibrary;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.GroupFieldsUniqueValidateResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbs.business.multiview.AppCountryCacheService;
import kd.sit.sitbs.opplugin.web.taxitemlibrary.TaxItemSaveValidator;

public class TaxItemLibrarySaveOp
extends AbstractOperationServicePlugIn {
    private static final String FIELDS = "id,number,status,enable,name,index,countrytype,country,taxitemtype,caltaxtype,ctrlstrategy,bred,brled,description,datatype,datalength,currency,dataprecision,dataround,incomeitem,taxcategories";
    private static final String[] SAVE_UNUSING_NOT_ALLOWED_EDITED_FIELDS = new String[]{"id", "countrytype", "country", "ctrlstrategy", "currency"};
    private static final String[] SAVE_USING_NOT_ALLOWED_EDITED_FIELDS = new String[]{"id", "number", "countrytype", "country", "ctrlstrategy", "datatype", "datalength", "currency", "dataprecision", "dataround"};
    private static final String[] COUNTRY_RELATED_FIELDS = new String[]{"taxitemtype", "taxcategories", "caltaxtype", "incomeitem"};

    public void onPreparePropertys(PreparePropertysEventArgs ex) {
        List fieldKeys = ex.getFieldKeys();
        fieldKeys.add("number");
        fieldKeys.add("name");
        fieldKeys.add("datatype");
        fieldKeys.add("dataprecision");
        fieldKeys.add("dataround");
        fieldKeys.add("datalength");
        fieldKeys.add("currency");
        fieldKeys.add("country");
        fieldKeys.add("countrytype");
        fieldKeys.add("caltaxtype");
        fieldKeys.add("bred");
        fieldKeys.add("brled");
        fieldKeys.add("taxcategories");
        fieldKeys.add("incomeitem");
        fieldKeys.add("splitalgo");
        fieldKeys.add("taxitemtype.country");
        fieldKeys.add("taxcategories.countrytype");
    }

    public void onAddValidators(AddValidatorsEventArgs ex) {
        ex.addValidator((AbstractValidator)new TaxItemSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs ex) {
        super.beforeExecuteOperationTransaction(ex);
        DynamicObject[] dynamicObjects = ex.getDataEntities();
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            long id = dynamicObject.getLong("id");
            if (id == 0L) continue;
            ids.add(id);
        }
        if (!ids.isEmpty()) {
            long id;
            HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitem");
            QFilter filter = new QFilter("id", "in", ids);
            DynamicObject[] dataStorageColl = helper.query(FIELDS, new QFilter[]{filter});
            HashMap<Long, DynamicObject> dataStorageMap = new HashMap<Long, DynamicObject>(dataStorageColl.length);
            for (DynamicObject dataStorage : dataStorageColl) {
                id = dataStorage.getLong("id");
                dataStorageMap.put(id, dataStorage);
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                id = dynamicObject.getLong("id");
                if (id == 0L || dataStorageMap.get(id) == null) continue;
                DynamicObject dataStorage = (DynamicObject)dataStorageMap.get(id);
                String status = dataStorage.getString("status");
                String enable = dataStorage.getString("enable");
                String newCountryType = dynamicObject.getString("countrytype");
                String oldCountryType = dataStorage.getString("countrytype");
                long newCountryId = dynamicObject.getLong("country.id");
                long oldCountryId = dataStorage.getLong("country.id");
                if (!newCountryType.equals(oldCountryType) || newCountryId != oldCountryId) {
                    for (String field : COUNTRY_RELATED_FIELDS) {
                        dynamicObject.set(field, dataStorage.get(field));
                    }
                }
                if ("A".equals(status) && "2".equals(enable)) {
                    for (String field : SAVE_UNUSING_NOT_ALLOWED_EDITED_FIELDS) {
                        dynamicObject.set(field, dataStorage.get(field));
                    }
                    continue;
                }
                if (!"A".equals(status) || !"1".equals(enable)) continue;
                for (String field : SAVE_USING_NOT_ALLOWED_EDITED_FIELDS) {
                    dynamicObject.set(field, dataStorage.get(field));
                }
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs ex) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = ex.getDataEntities()) {
            this.setFieldDyObj(dataEntity);
        }
    }

    private void setFieldDyObj(DynamicObject dataEntity) {
        String countryType = dataEntity.getString("countrytype");
        String countryNum = dataEntity.getString("country.number");
        long dataTypeId = dataEntity.getLong("datatype.id");
        if (HRStringUtils.equals((String)"1", (String)countryType) && !HRStringUtils.isEmpty((String)countryNum) && SitDataTypeEnum.AMOUNT.getId() == dataTypeId) {
            String currencyId = AppCountryCacheService.getInstance().getCurrency(dataEntity.getString("country.number"), "sitbs_appcountryrel");
            DynamicObject dynamicObject = this.generateEmptyDyObj("bd_currency", currencyId);
            dataEntity.set("currency", (Object)dynamicObject);
        }
    }

    private DynamicObject generateEmptyDyObj(String pageNumber, String pkId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(pageNumber);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)pkId);
        return dynamicObject;
    }

    public void onReturnOperation(ReturnOperationArgs ex) {
        OperationResult operationResult = (OperationResult)ex.getOperationResult();
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateError : validateErrors) {
            GroupFieldsUniqueValidateResult result;
            List fieldKeys;
            if (!(validateError instanceof GroupFieldsUniqueValidateResult) || !(fieldKeys = (result = (GroupFieldsUniqueValidateResult)validateError).getFieldKeys()).contains("caltaxtype") || !fieldKeys.contains("name")) continue;
            List allErrorInfo = result.getAllErrorInfo();
            for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                String spliter;
                String oldMessage = operateErrorInfo.getMessage();
                if (oldMessage.contains(spliter = ResManager.loadKDString((String)"\uff1a", (String)"TaxItemLibrarySaveOp_1", (String)"sit-sitbs-opplugin", (Object[])new Object[0]))) {
                    String[] split = oldMessage.split(spliter);
                    operateErrorInfo.setMessage(ResManager.loadKDString((String)"{0}\uff1a\u5728\u540c\u4e00\u7528\u9014\u4e0b\uff0c\u4e2a\u7a0e\u9879\u76ee\u7684\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"TaxItemLibrarySaveOp_0", (String)"sit-sitbs-opplugin", (Object[])new Object[]{split[0]}));
                    continue;
                }
                operateErrorInfo.setMessage(ResManager.loadKDString((String)"\u5728\u540c\u4e00\u7528\u9014\u4e0b\uff0c\u4e2a\u7a0e\u9879\u76ee\u7684\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"TaxItemLibrarySaveOp_2", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

