/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.taxitemlibrary;

import com.google.common.base.Strings;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.enums.DataRoundEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbs.business.multiview.GetAppInfoService;
import kd.sit.sitbs.business.service.FuncDefineHelper;
import kd.sit.sitbs.business.taxitemlibrary.TaxItemHelper;
import kd.sit.sitbs.business.taxitemlibrary.TaxLibraryHelper;
import kd.sit.sitbs.common.enums.TaxItemTypeEnums;
import kd.sit.sitbs.common.taxitemlibrary.TaxItemLibraryConstants;
import kd.sit.sitbs.common.utils.StringCheckUtils;

public class TaxItemSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(TaxItemSaveValidator.class);
    private static final String DATALENGTH_ZERO = "0";
    private static final String MAX_DATALENGTH = "13";
    private final Map<Long, Set<Long>> taxItemIdsInSnapShotMap = new HashMap<Long, Set<Long>>(16);
    private final Set<Long> sameTaxcategoryAndIncomeitem = new HashSet<Long>(16);

    public void validate() {
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            Set taxItemIds = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            Set taxCategoryIdSet = TaxItemHelper.getAllTaxCategoryMapHasIncomeItem(taxItemIds);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                if ("save".equals(operateKey) && !this.checkReferedByTaxTaskSnapShot(dataEntity)) continue;
                this.checkNumberAndName(dataEntity);
                String countryType = dataEntity.getDataEntity().getString("countrytype");
                DynamicObject country = dataEntity.getDataEntity().getDynamicObject("country");
                String inComeItem = dataEntity.getDataEntity().getString("incomeitem");
                DynamicObject splitAlgo = dataEntity.getDataEntity().getDynamicObject("splitalgo");
                DynamicObject taxItemType = dataEntity.getDataEntity().getDynamicObject("taxitemtype");
                DynamicObject calTaxType = dataEntity.getDataEntity().getDynamicObject("caltaxtype");
                long countryId = dataEntity.getDataEntity().getLong("country.id");
                if (this.validateCountryItem(dataEntity, countryType, country, inComeItem, splitAlgo, taxItemType, calTaxType, countryId)) continue;
                DynamicObjectCollection taxCategories = dataEntity.getDataEntity().getDynamicObjectCollection("taxcategories");
                if (YesOrNoEnum.isYes((String)inComeItem)) {
                    if (!CollectionUtils.isEmpty((Collection)taxCategories) && taxCategories.size() > 1) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u5f97\u9879\u76ee\u586b\u201c\u662f\u201d\u65f6\uff0c\u53ea\u80fd\u5bf9\u5e94\u4e00\u4e2a\u4e2a\u7a0e\u79cd\u7c7b\u3002", (String)"TaxItemSaveValidator_22", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    long taxCategoryId = ((DynamicObject)taxCategories.get(0)).getLong("fbasedataid.id");
                    if (taxCategoryIdSet.contains(taxCategoryId)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u586b\u4e2a\u7a0e\u79cd\u7c7b\u5df2\u6709\u6240\u5f97\u9879\u76ee\u3002", (String)"TaxItemSaveValidator_23", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (this.sameTaxcategoryAndIncomeitem.contains(taxCategoryId)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6bcf\u4e2a\u4e2a\u7a0e\u79cd\u7c7b\u53ea\u80fd\u6709\u4e00\u4e2a\u6240\u5f97\u9879\u76ee\u3002", (String)"TaxItemSaveValidator_24", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    this.sameTaxcategoryAndIncomeitem.add(taxCategoryId);
                }
                for (DynamicObject multiBaseDataDy : taxCategories) {
                    DynamicObject taxCategory = multiBaseDataDy.getDynamicObject("fbasedataid");
                    String countryTypeFromCategory = taxCategory.getString("countrytype");
                    if (!DATALENGTH_ZERO.equals(countryType) && DATALENGTH_ZERO.equals(countryTypeFromCategory)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e2a\u7a0e\u79cd\u7c7b\u4e2d\u6709\u901a\u7528\u7684\u79cd\u7c7b\uff0c\u4f46\u662f\u4e2a\u7a0e\u9879\u76ee\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u4e3a\u901a\u7528\u3002", (String)"TaxItemSaveValidator_25", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                        break;
                    }
                    long countryIdFromTaxCategory = taxCategory.getLong("country.id");
                    if (countryIdFromTaxCategory == countryId) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e2a\u7a0e\u79cd\u7c7b\u4e2d\u6709\u548c\u4e2a\u7a0e\u9879\u76ee\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u5339\u914d\u7684\u7c7b\u578b\u3002", (String)"TaxItemSaveValidator_26", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                    break;
                }
                this.checkTaxItemTypeIsSpecialAdditionalDeduction(dataEntity);
                this.checkAndDealData(dataEntity);
            }
        }
    }

    private boolean validateCountryItem(ExtendedDataEntity dataEntity, String countryType, DynamicObject country, String inComeItem, DynamicObject splitAlgo, DynamicObject taxItemType, DynamicObject calTaxType, long countryId) {
        long countryIdFromType;
        if ("1".equals(countryType) && Objects.isNull(country)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u6307\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u56fd\u5bb6/\u5730\u533a\u3002", (String)"TaxItemSaveValidator_15", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return true;
        }
        if (DATALENGTH_ZERO.equals(countryType) && Objects.nonNull(country)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u901a\u7528\u65f6\uff0c\u65e0\u9700\u6307\u5b9a\u56fd\u5bb6/\u5730\u533a\u3002", (String)"TaxItemSaveValidator_16", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return true;
        }
        if (Objects.nonNull(taxItemType) && countryId != (countryIdFromType = taxItemType.getLong("country.id"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u548c\u4e2a\u7a0e\u9879\u76ee\u7c7b\u522b\u4e0d\u5339\u914d\u3002", (String)"TaxItemSaveValidator_17", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return true;
        }
        if (DATALENGTH_ZERO.equals(countryType) && Objects.nonNull(calTaxType)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u901a\u7528\uff0c\u4e0d\u80fd\u5bfc\u5165\u7528\u9014\u5b57\u6bb5\u7684\u503c\u3002", (String)"TaxItemSaveValidator_18", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return true;
        }
        if ("1".equals(countryType) && Long.parseLong("1000001") == countryId && Objects.isNull(calTaxType)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u4e3a\u4e2d\u56fd\uff0c\u7528\u9014\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"TaxItemSaveValidator_19", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return true;
        }
        if ("1".equals(countryType) && Long.parseLong("1000001") == countryId && Objects.isNull(splitAlgo)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u4e3a\u4e2d\u56fd\uff0c\u62c6\u5206\u7b97\u6cd5\u5b57\u6bb5\u5fc5\u586b\u3002", (String)"TaxItemSaveValidator_20", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return true;
        }
        if ("1".equals(countryType) && Long.parseLong("1000001") == countryId && Objects.nonNull(calTaxType) && CalTaxTypeEnum.RETURN.getId() == calTaxType.getLong("id") && Strings.isNullOrEmpty((String)inComeItem)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u4e3a\u4e2d\u56fd\uff0c\u7528\u9014\u4e3a\u7a0e\u5c40\u8fd4\u56de\u65f6\uff0c\u6240\u5f97\u9879\u76ee\u5fc5\u586b\u3002", (String)"TaxItemSaveValidator_21", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkReferedByTaxTaskSnapShot(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        long id = dynamicObject.getLong("id");
        DynamicObject country = dynamicObject.getDynamicObject("country");
        if (country == null) {
            return true;
        }
        long countryId = country.getLong("id");
        if (!this.taxItemIdsInSnapShotMap.containsKey(countryId)) {
            DynamicObject appInfo = GetAppInfoService.getInstance().queryAppInfoByCountryId(Long.valueOf(countryId));
            if (appInfo == null) {
                return true;
            }
            String appId = appInfo.getString("app.number");
            Set taxItemsInTaxTaskSnapShot = TaxItemHelper.getAllTaxItemsReferredInTaxTaskSnapShot((String)appId);
            this.taxItemIdsInSnapShotMap.put(countryId, taxItemsInTaxTaskSnapShot);
        }
        if (id != 0L && this.taxItemIdsInSnapShotMap.get(countryId).contains(id)) {
            String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5df2\u7ecf\u88ab\u4e2a\u7a0e\u4efb\u52a1\u5feb\u7167\u5f15\u7528\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"TaxItemSaveValidator_9", (String)"sit-sitbs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, msg);
            return false;
        }
        return true;
    }

    private void checkAndDealData(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObject dataTypeData = dynamicObject.getDynamicObject("datatype");
        long dataTypeId = dataTypeData.getLong("id");
        DynamicObject dataPrecisionData = dynamicObject.getDynamicObject("dataprecision");
        DynamicObject dataRoundData = dynamicObject.getDynamicObject("dataround");
        String dataLength = dynamicObject.getString("datalength");
        if (SitDataTypeEnum.TEXT.getId() == dataTypeId) {
            if (dataLength == null || DATALENGTH_ZERO.equals(dataLength)) {
                String name = ResManager.loadKDString((String)"\u6587\u672c", (String)"TaxItemSaveValidator_2", (String)"sit-sitbs-opplugin", (Object[])new Object[0]);
                String msg = MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a{0}\u65f6\uff0c\u6570\u636e\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u4e3a0\u3002", (String)"TaxItemSaveValidator_3", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), name);
                this.addErrorMessage(dataEntity, msg);
            }
            dynamicObject.set("dataprecision", null);
            dynamicObject.set("dataround", null);
        } else if (SitDataTypeEnum.NUMBER.getId() == dataTypeId || SitDataTypeEnum.AMOUNT.getId() == dataTypeId) {
            String msg;
            String name;
            String string = name = SitDataTypeEnum.NUMBER.getId() == dataTypeId ? ResManager.loadKDString((String)"\u6570\u503c", (String)"TaxItemSaveValidator_4", (String)"sit-sitbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u91d1\u989d", (String)"TaxItemSaveValidator_5", (String)"sit-sitbs-opplugin", (Object[])new Object[0]);
            if (dataPrecisionData == null && SitDataTypeEnum.AMOUNT.getId() != dataTypeId) {
                msg = MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a{0}\u65f6\uff0c\u6570\u636e\u7cbe\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxItemSaveValidator_6", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), name);
                this.addErrorMessage(dataEntity, msg);
            }
            if (SitDataTypeEnum.AMOUNT.getId() == dataTypeId) {
                dynamicObject.set("dataprecision", null);
            }
            if (dataRoundData == null) {
                msg = MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a{0}\u65f6\uff0c\u7cbe\u5ea6\u5c3e\u5dee\u5904\u7406\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxItemSaveValidator_7", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), name);
                this.addErrorMessage(dataEntity, msg);
            }
        } else if (SitDataTypeEnum.INTEGER.getId() == dataTypeId || SitDataTypeEnum.DATE.getId() == dataTypeId || SitDataTypeEnum.BOOLEAN.getId() == dataTypeId) {
            if (SitDataTypeEnum.INTEGER.getId() != dataTypeId) {
                dynamicObject.set("datalength", null);
            }
            dynamicObject.set("dataprecision", null);
            dynamicObject.set("dataround", null);
        }
        this.checkDataTypeLength(dataEntity, dataLength, dataTypeId);
        this.checkCurrency(dataEntity, dataTypeId);
        this.checkCalTaxType(dataEntity);
        this.checkIncomeItemAndSplitAlgo(dataEntity);
    }

    private void checkIncomeItemAndSplitAlgo(ExtendedDataEntity dataEntity) {
        DynamicObject splitAlgoDy;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObject countryDy = dynamicObject.getDynamicObject("country");
        String countryId = countryDy == null ? null : countryDy.getString("id");
        DynamicObject calTaxTypeDy = dynamicObject.getDynamicObject("caltaxtype");
        long calTaxTypeId = calTaxTypeDy == null ? 0L : calTaxTypeDy.getLong("id");
        String incomeItem = dynamicObject.getString("incomeitem");
        if (!("1000001".equals(countryId) && CalTaxTypeEnum.SUBMIT.getId() != calTaxTypeId || null == incomeItem)) {
            dynamicObject.set("incomeitem", null);
        }
        if (null != (splitAlgoDy = dynamicObject.getDynamicObject("splitalgo")) && !"1000001".equals(countryId)) {
            dynamicObject.set("splitalgo", null);
        }
    }

    private void checkCalTaxType(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObject countryDy = dynamicObject.getDynamicObject("country");
        DynamicObject calTaxTypeDy = dynamicObject.getDynamicObject("caltaxtype");
        if (null != countryDy) {
            String countryId = countryDy.getString("id");
            if (null != calTaxTypeDy && !"1000001".equals(countryId)) {
                dynamicObject.set("caltaxtype", null);
            }
        }
    }

    private void checkDataTypeLength(ExtendedDataEntity dataEntity, String dataLength, long dataTypeId) {
        if (SitDataTypeEnum.NUMBER.getId() == dataTypeId || SitDataTypeEnum.AMOUNT.getId() == dataTypeId || SitDataTypeEnum.INTEGER.getId() == dataTypeId) {
            dataEntity.getDataEntity().set("datalength", null);
        }
    }

    private void checkCurrency(ExtendedDataEntity dataEntity, long dataTypeId) {
        if (SitDataTypeEnum.AMOUNT.getId() != dataTypeId) {
            dataEntity.getDataEntity().set("currency", null);
        }
    }

    private void checkNumberAndName(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String name = dynamicObject.getString("name");
        String number = dynamicObject.getString("number");
        if (StringCheckUtils.isContainSpecialChar((String)name) || StringCheckUtils.isStartWithNumber((String)name) || FuncDefineHelper.checkNameContainConditionName((String)name)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u3001\u7a7a\u683c\u3001\u516c\u5f0f\u5224\u65ad\u6761\u4ef6\u540d\u79f0\uff0c\u5e76\u4e14\u4e0d\u80fd\u4ee5\u6570\u5b57\u5f00\u5934\u3002", (String)"TaxItemSaveValidator_0", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
        }
        if (StringCheckUtils.isContainJavaVariableForbidChar((String)number)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u3001\u7a7a\u683c\u3002", (String)"TaxItemSaveValidator_1", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkTaxItemTypeIsSpecialAdditionalDeduction(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObject taxItemType = dynamicObject.getDynamicObject("taxitemtype");
        if (!HRObjectUtils.isEmpty((Object)taxItemType)) {
            long taxItemTypeId = taxItemType.getLong("id");
            if (TaxItemTypeEnums.SPECIAL_ADDITIONAL_DEDUCTION.getId() == taxItemTypeId) {
                DynamicObjectCollection taxCategories;
                DynamicObject dataRound;
                DynamicObject dataType;
                StringBuilder errMsg = new StringBuilder();
                boolean pass = true;
                errMsg.append(ResManager.loadKDString((String)"\u201c\u4e2a\u7a0e\u9879\u76ee\u7c7b\u522b\u201d\u4e3a\u201c\u4e13\u9879\u9644\u52a0\u6263\u9664\u201d\u7684\u4e2a\u7a0e\u9879\u76ee\uff1a", (String)"TaxItemSaveValidator_10", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                DynamicObject splitAlgo = dynamicObject.getDynamicObject("splitalgo");
                if (!HRObjectUtils.isEmpty((Object)splitAlgo) && TaxItemLibraryConstants.NONESPLIT_ID.longValue() != splitAlgo.getLong("id")) {
                    errMsg.append(ResManager.loadKDString((String)"\u62c6\u5206\u7b97\u6cd5\u5fc5\u987b\u4e3a\u201c\u4e0d\u62c6\u5206\u201d\uff1b", (String)"TaxItemSaveValidator_11", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                    pass = false;
                }
                if (!HRObjectUtils.isEmpty((Object)(dataType = dynamicObject.getDynamicObject("datatype"))) && SitDataTypeEnum.AMOUNT.getId() != dataType.getLong("id")) {
                    errMsg.append(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u5fc5\u987b\u4e3a\u201c\u91d1\u989d\u201d\uff1b", (String)"TaxItemSaveValidator_12", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                    pass = false;
                }
                if (!HRObjectUtils.isEmpty((Object)(dataRound = dynamicObject.getDynamicObject("dataround"))) && DataRoundEnum.ROUNDING.getId() != dataRound.getLong("id")) {
                    errMsg.append(ResManager.loadKDString((String)"\u7cbe\u5ea6\u5c3e\u5dee\u5904\u7406\u5fc5\u987b\u4e3a\u201c\u56db\u820d\u4e94\u5165\u201d\uff1b", (String)"TaxItemSaveValidator_13", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                    pass = false;
                }
                if (!TaxLibraryHelper.validateTaxCategory((DynamicObjectCollection)(taxCategories = dynamicObject.getDynamicObjectCollection("taxcategories")))) {
                    errMsg.append(ResManager.loadKDString((String)"\u4e2a\u7a0e\u79cd\u7c7b\u5fc5\u987b\u662f\u201c\u6b63\u5e38\u5de5\u8d44\u85aa\u91d1\u6240\u5f97\u201d\uff1b", (String)"TaxItemSaveValidator_14", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                    pass = false;
                }
                if (!pass) {
                    this.addErrorMessage(dataEntity, errMsg.toString());
                }
            }
        }
    }
}

