/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.taxitemlibrary;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.sit.sitbs.business.multiview.GetAppInfoService;
import kd.sit.sitbs.business.taxitemlibrary.TaxItemHelper;

public class TaxItemUnauditValidator
extends AbstractValidator {
    private final Map<Long, Set<Long>> taxItemIdsInSnapShotMap = new HashMap<Long, Set<Long>>(16);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long id = dynamicObject.getLong("id");
            DynamicObject country = dynamicObject.getDynamicObject("country");
            if (country == null) continue;
            long countryId = country.getLong("id");
            if (!this.taxItemIdsInSnapShotMap.containsKey(countryId)) {
                DynamicObject appInfo = GetAppInfoService.getInstance().queryAppInfoByCountryId(Long.valueOf(countryId));
                if (appInfo == null) continue;
                String appId = appInfo.getString("app.number");
                Set taxItemsInTaxTaskSnapShot = TaxItemHelper.getAllTaxItemsReferredInTaxTaskSnapShot((String)appId);
                this.taxItemIdsInSnapShotMap.put(countryId, taxItemsInTaxTaskSnapShot);
            }
            if (id == 0L || !this.taxItemIdsInSnapShotMap.get(countryId).contains(id)) continue;
            String msg = ResManager.loadKDString((String)"\u6b64\u4e2a\u7a0e\u9879\u76ee\u5df2\u5728\u4ee5\u5f80\u7684\u4e2a\u7a0e\u4efb\u52a1\u4e2d\u4f7f\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"TaxItemUnauditValidator_0", (String)"sit-sitbs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

