/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.taxtemplate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbs.business.taxtemplate.TaxImportExportTmpDBHelper;
import kd.sit.sitbs.business.taxtemplate.TaxTemplateHelper;

public class TemplateDisableValidator
extends AbstractValidator {
    public void validate() {
        if ("disable".equals(this.getOperateKey())) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject dy = dataEntity.getDataEntity();
                if (!dy.getBoolean("enable")) continue;
                list.add(dy);
            }
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            List<DynamicObject> canNotDisable = this.doDisableValidate(list);
            if (CollectionUtils.isEmpty(canNotDisable)) {
                return;
            }
            this.setErrMsg(dataEntities, canNotDisable);
        }
    }

    private void setErrMsg(ExtendedDataEntity[] dataEntities, List<DynamicObject> doDisableDys) {
        HashSet<ExtendedDataEntity> set = new HashSet<ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            for (DynamicObject diableDy : doDisableDys) {
                if (dy.getLong("id") != diableDy.getLong("id")) continue;
                set.add(dataEntity);
            }
        }
        for (ExtendedDataEntity extendedDataEntity : set) {
            String errmsg = String.format(ResManager.loadKDString((String)"\u9002\u7528\u573a\u666f\u4e0b\u7684\u552f\u4e00\u542f\u7528\u65b9\u6848\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"TemplateDisableValidator_1", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), new Object[0]);
            this.setErrorLevel(ErrorLevel.Error);
            this.addErrorMessage(extendedDataEntity, errmsg);
        }
    }

    private List<DynamicObject> doDisableValidate(List<DynamicObject> list) {
        Map<Object, List<DynamicObject>> selectedMap = list.stream().collect(Collectors.groupingBy(dy -> TaxTemplateHelper.fetchGroupKey((DynamicObject)dy)));
        DynamicObject[] dyArry = this.getAllEnableTemplate();
        List<DynamicObject> dys = Arrays.asList(dyArry);
        Map<String, List<DynamicObject>> allEnablesMap = dys.stream().collect(Collectors.groupingBy(dy -> TaxTemplateHelper.fetchGroupKey((DynamicObject)dy)));
        ArrayList<DynamicObject> canNotDisableList = new ArrayList<DynamicObject>(selectedMap.size());
        for (Map.Entry<Object, List<DynamicObject>> entry : selectedMap.entrySet()) {
            List<DynamicObject> allEnableList = allEnablesMap.get(entry.getKey());
            List<DynamicObject> selectedList2 = selectedMap.get(entry.getKey());
            if (CollectionUtils.isEmpty(allEnableList)) {
                return canNotDisableList;
            }
            if (allEnableList.size() > selectedList2.size()) continue;
            int index = allEnableList.size() - 1;
            if (index > 0) {
                List<DynamicObject> subList2 = selectedList2.subList(index, selectedList2.size());
                canNotDisableList.addAll(subList2);
                continue;
            }
            canNotDisableList.addAll(selectedList2);
        }
        return canNotDisableList;
    }

    private DynamicObject[] getAllEnableTemplate() {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        return TaxImportExportTmpDBHelper.queryTemplatesByEnableStatus((QFilter)filter);
    }
}

