/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.taxtemplate;

import java.text.MessageFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.StringUtils;

public class TemplateSaveValidator
extends AbstractValidator {
    public void validate() {
        if (!"save".equals(this.getOperateKey())) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.validateSave(dataEntities);
    }

    private void validateSave(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dyObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryentityColl = (DynamicObjectCollection)dyObj.get("entryentity");
            if (entryentityColl == null || entryentityColl.size() == 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5bfc\u5165\u5bfc\u51fa\u65b9\u6848\u5b57\u6bb5\u5173\u7cfb\u3002", (String)"TemplateSaveValidator_0", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), new Object[0]));
                return;
            }
            this.checkEntryData(dataEntity, entryentityColl, dyObj);
        }
    }

    private void checkEntryData(ExtendedDataEntity dataEntity, DynamicObjectCollection entryentityColl, DynamicObject dyObj) {
        int index = 0;
        String tmplateType = dyObj.getString("templatetype");
        for (DynamicObject entry : entryentityColl) {
            ++index;
            if ("2".equals(tmplateType)) {
                this.checkExportEntryData(dataEntity, entry, index);
                continue;
            }
            this.checkImportEntryData(dataEntity, entry, index);
        }
    }

    private void checkExportEntryData(ExtendedDataEntity dataEntity, DynamicObject dyObj, int index) {
        Object taxitem = dyObj.get("taxitem");
        String fieldkey = dyObj.getString("fieldkey");
        String exportfield = dyObj.getString("exportfield");
        boolean isexport = dyObj.getBoolean("isexport");
        if (StringUtils.isEmpty((Object)exportfield) && isexport) {
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5bfc\u51fa\u5230\u672c\u5730\u7684\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateSaveValidator_1", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), index));
            return;
        }
        if (null == taxitem && StringUtils.isEmpty((Object)fieldkey)) {
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5bf9\u5e94\u7684\u7cfb\u7edf\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateSaveValidator_2", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), index));
            return;
        }
    }

    private void checkImportEntryData(ExtendedDataEntity dataEntity, DynamicObject dyObj, int index) {
        Object taxitem = dyObj.get("taxitem");
        String fieldkey = dyObj.getString("fieldkey");
        String importfield = dyObj.getString("importfield");
        if (StringUtils.isEmpty((Object)importfield)) {
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u4ece\u672c\u5730\u5bfc\u5165\u7684\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateSaveValidator_3", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), index));
            return;
        }
        if (null == taxitem && StringUtils.isEmpty((Object)fieldkey)) {
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5bf9\u5e94\u7684\u7cfb\u7edf\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateSaveValidator_2", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), index));
            return;
        }
    }
}

