/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.sitbs.opplugin.web.walfare;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.sitbp.business.importutil.ImportFieldChangedService;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbs.business.WelfarePayerHelper;
import kd.sit.sitbs.business.socinsurance.errinfo.SocInsuranceErrInfoEnum;
import kd.sit.sitbs.business.socinsurance.service.SInsuranceCommonService;
import org.apache.commons.lang.StringUtils;

public class WelfarePayerSaveValidator
extends AbstractValidator {
    public static final String IMPORT_TYPE_OVERRIDE = "override";
    public static final String IMPORT_TYPE_OVERRIDENEW = "overridenew";
    private static final Set<String> MUST_FIXED_FIELD_SET = new LinkedHashSet<String>(Arrays.asList("org.id", "number", "country.id", "placeofwelfare.id"));

    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        ImportFieldChangedService instanceForImport = ImportFieldChangedService.createInstanceForImport((OperateOption)this.getOption(), (ExtendedDataEntity[])this.dataEntities);
        Map appInfo = SInsuranceCommonService.getCountryInfoForAppIdByOption((OperateOption)this.getOption());
        HashMap<String, DynamicObject> lawEntityNumber = new HashMap<String, DynamicObject>(16);
        List entities = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Set validBaseCalRuleIds = SITPermissionServiceHelper.getValidBaseDataEntityIds(entities, (String)"org", (String)"basecalrule", null);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String placeCountryNum;
            if (!this.mustInput(dataEntity)) continue;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            if (instanceForImport != null && instanceForImport.checkFixedFieldChangedWhenImport(dataEntity, MUST_FIXED_FIELD_SET)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5bfc\u5165\u65f6\u4e0d\u5141\u8bb8\u4fee\u6539\u793e\u4fdd\u516c\u79ef\u91d1\u7ba1\u7406\u7ec4\u7ec7\u3001\u7f16\u7801\u3001\u56fd\u5bb6/\u5730\u533a\u3001\u53c2\u4fdd\u5730\u3002", (String)"WelfarePayerSaveValidator_4", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject sinSurDclRule = dynamicObject.getDynamicObject("sinsurdclrule");
            if (sinSurDclRule != null && dynamicObject.getLong("country.id") != sinSurDclRule.getLong("country.id")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u62a5\u540d\u5355\u89c4\u5219\u56fd\u5bb6/\u5730\u533a\u4e0e\u53c2\u4fdd\u5355\u4f4d\u56fd\u5bb6/\u5730\u533a\u4e0d\u5339\u914d\u3002", (String)"WelfarePayerSaveValidator_11", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject baseCalRule = dynamicObject.getDynamicObject("basecalrule");
            if (baseCalRule != null && dynamicObject.getLong("country.id") != baseCalRule.getLong("country.id")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u57fa\u6570\u8ba1\u7b97\u89c4\u5219\u56fd\u5bb6/\u5730\u533a\u4e0e\u53c2\u4fdd\u5355\u4f4d\u56fd\u5bb6/\u5730\u533a\u4e0d\u5339\u914d\u3002", (String)"WelfarePayerSaveValidator_12", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (baseCalRule != null && baseCalRule.getLong("id") != 0L && !validBaseCalRuleIds.contains(baseCalRule.getLong("id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u57fa\u6570\u8ba1\u7b97\u89c4\u5219\u7684\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5728\u53c2\u4fdd\u5355\u4f4d\u521b\u5efa\u7ec4\u7ec7\u8303\u56f4\u5185\u3002", (String)"WelfarePayerSaveValidator_13", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
                continue;
            }
            String errMsg = SInsuranceCommonService.checkCountryWhenImport((Map)appInfo, (String)dynamicObject.getString("country.id"), (String)SocInsuranceErrInfoEnum.WELFARE_PAYER_APP_COUNTRY_FAILED.getErrInfo());
            if (HRStringUtils.isNotEmpty((String)errMsg)) {
                this.addErrorMessage(dataEntity, errMsg);
                continue;
            }
            DynamicObject placeDynamicObject = dynamicObject.getDynamicObject("placeofwelfare");
            boolean placeEnable = placeDynamicObject.getBoolean("enable");
            if (!placeEnable) {
                String placeName = placeDynamicObject.getString("name");
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53c2\u4fdd\u5730{0} \u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"WelfarePayerSaveValidator_0", (String)"sit-sitbs-opplugin", (Object[])new Object[]{placeName}));
                continue;
            }
            String countryNum = dynamicObject.getString("country.number");
            if (!StringUtils.equals((String)countryNum, (String)(placeCountryNum = placeDynamicObject.getString("country.number")))) {
                String welfarePayerName = dynamicObject.getString("name");
                String placeName = placeDynamicObject.getString("name");
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53c2\u4fdd\u5355\u4f4d {0} \u4e0e\u586b\u5199\u7684\u53c2\u4fdd\u5730 {1} \u56fd\u5bb6/\u5730\u533a\u4e0d\u5339\u914d\u3002", (String)"WelfarePayerSaveValidator_1", (String)"sit-sitbs-opplugin", (Object[])new Object[]{welfarePayerName, placeName}));
                continue;
            }
            DynamicObject lawEntity = dynamicObject.getDynamicObject("lawentity");
            if (lawEntity == null) continue;
            String propctl = lawEntity.getString("propctl");
            String entityType = lawEntity.getString("entitytype");
            if ((HRStringUtils.equals((String)entityType, (String)"1") || HRStringUtils.equals((String)entityType, (String)"2")) && !propctl.contains("4")) {
                this.addMessage(dataEntity, this.getOperationName(), ResManager.loadKDString((String)"\u586b\u5199\u7684\u6cd5\u5f8b\u5b9e\u4f53\u4e0d\u5177\u5907\u53c2\u4fdd\u5355\u4f4d\u5c5e\u6027", (String)"WelfarePayerSaveValidator_3", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                continue;
            }
            this.validateLawEntity(dataEntity, lawEntityNumber);
        }
    }

    private boolean mustInput(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        if (WelfarePayerHelper.getIsRelLawentity() && dataEntity.get("lawentity") == null) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6cd5\u5f8b\u5b9e\u4f53\u201d\u3002", (String)"WelfarePayerSaveValidator_5", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (dataEntity.get("number") == null) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7f16\u7801\u201d\u3002", (String)"WelfarePayerSaveValidator_6", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (dataEntity.get("name") == null) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"WelfarePayerSaveValidator_7", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (dataEntity.get("country") == null) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u3002", (String)"WelfarePayerSaveValidator_8", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (dataEntity.get("placeofwelfare") == null) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u53c2\u4fdd\u5730\u201d\u3002", (String)"WelfarePayerSaveValidator_9", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (dataEntity.get("bred") == null) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u4e1a\u52a1\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"WelfarePayerSaveValidator_10", (String)"sit-sitbs-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void validateLawEntity(ExtendedDataEntity extendedDataEntity, Map<String, DynamicObject> lawEntityNumber) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObject lawEntity = dataEntity.getDynamicObject("lawentity");
        if (lawEntity != null) {
            if (lawEntityNumber.containsKey(lawEntity.getString("number"))) {
                this.addMessage(extendedDataEntity, this.getOperationName(), MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u6cd5\u5f8b\u5b9e\u4f53\u5df2\u88ab\u53c2\u4fdd\u5355\u4f4d\u3010{0}\u3011\u5f15\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6cd5\u5f8b\u5b9e\u4f53\u3002", (String)"WelfarePayerSaveValidator_2", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), lawEntityNumber.get(lawEntity.getString("number")).getString("name")), ErrorLevel.FatalError);
                return;
            }
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("sitbs_welfarepayer");
            if (dataEntity.getLong("id") == 0L) {
                DynamicObject[] query = hrBaseServiceHelper.query("", new QFilter[]{new QFilter("lawentity.id", "=", lawEntity.getPkValue())});
                if (query != null && query.length > 0) {
                    this.addMessage(extendedDataEntity, this.getOperationName(), MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u6cd5\u5f8b\u5b9e\u4f53\u5df2\u88ab\u53c2\u4fdd\u5355\u4f4d\u3010{0}\u3011\u5f15\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6cd5\u5f8b\u5b9e\u4f53\u3002", (String)"WelfarePayerSaveValidator_2", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), query[0].getString("name")), ErrorLevel.FatalError);
                    lawEntityNumber.put(lawEntity.getString("number"), query[0]);
                } else {
                    lawEntityNumber.put(lawEntity.getString("number"), dataEntity);
                }
            } else {
                DynamicObject dynamicObject = hrBaseServiceHelper.queryOne("id", new QFilter[]{new QFilter("lawentity.id", "=", lawEntity.getPkValue()), new QFilter("id", "!=", (Object)dataEntity.getLong("id"))});
                if (dynamicObject != null) {
                    this.addMessage(extendedDataEntity, this.getOperationName(), MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u6cd5\u5f8b\u5b9e\u4f53\u5df2\u88ab\u53c2\u4fdd\u5355\u4f4d\u3010{0}\u3011\u5f15\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6cd5\u5f8b\u5b9e\u4f53\u3002", (String)"WelfarePayerSaveValidator_2", (String)"sit-sitbs-opplugin", (Object[])new Object[0]), dynamicObject.getString("name")), ErrorLevel.FatalError);
                    lawEntityNumber.put(lawEntity.getString("number"), dynamicObject);
                } else {
                    lawEntityNumber.put(lawEntity.getString("number"), dataEntity);
                }
            }
        }
    }
}

