/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.mobile.common.UserGroupUtil;
import kd.ssc.task.mobile.formplugin.index.TeamLeaderHelper;

public class TeamLeaderApi {
    public static Map<Long, Set<String>> getOrgRoleAssignMap(Long pUserId) {
        HashMap<Long, Set<String>> orgRoleAssignMap = new HashMap<Long, Set<String>>();
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"perm_userrole", (String)"role,org,includesuborg", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)pUserId)});
        if (doc == null || doc.isEmpty()) {
            return orgRoleAssignMap;
        }
        HashSet<Long> orgIncludeSubOrg = new HashSet<Long>();
        for (DynamicObject dObj : doc) {
            long curOrgId = dObj.getLong("org");
            String roleId = dObj.getString("role");
            boolean includeSubOrg = dObj.getBoolean("includesuborg");
            orgRoleAssignMap.computeIfAbsent(curOrgId, k -> new HashSet()).add(roleId);
            if (!includeSubOrg) continue;
            orgIncludeSubOrg.add(curOrgId);
        }
        for (Long curOrgId : orgIncludeSubOrg) {
            ArrayList<Long> curOrgList = new ArrayList<Long>();
            curOrgList.add(curOrgId);
            Set roleIds = (Set)orgRoleAssignMap.get(curOrgId);
            List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), curOrgList, (boolean)false);
            if (allSubordinateOrgs == null || allSubordinateOrgs.size() == 0) continue;
            for (Long subOrgId : allSubordinateOrgs) {
                orgRoleAssignMap.computeIfAbsent(subOrgId, k -> new HashSet()).addAll(roleIds);
            }
        }
        return orgRoleAssignMap;
    }

    public static boolean isAdminRole(String sid, Long uid, String adminRoleId) {
        boolean result = false;
        if (!TeamLeaderApi.isOpenTeamleader(sid)) {
            return true;
        }
        Map<Long, Set<String>> map = TeamLeaderApi.getOrgRoleAssignMap(uid);
        block0: for (Map.Entry<Long, Set<String>> entry : map.entrySet()) {
            Long key = entry.getKey();
            if (!sid.equals(String.valueOf(key))) continue;
            Set<String> roleSet = entry.getValue();
            for (String roleId : roleSet) {
                if (!adminRoleId.equals(roleId)) continue;
                result = true;
                break block0;
            }
        }
        return result || PermissionServiceHelper.isSuperUser((long)uid);
    }

    public static void showForm(IFormView view, Map<String, String> paramMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("formId", "task_errorpage");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submitintab_");
        if (paramMap.size() > 0) {
            String key = new ArrayList<String>(paramMap.keySet()).get(0);
            showParameter.setCaption(ResManager.loadKDString((String)String.valueOf(paramMap.get(key)), (String)key, (String)"ssc-task-formplugin", (Object[])new Object[0]));
        }
        showParameter.setHasRight(true);
        view.showForm(showParameter);
    }

    public static boolean isTeamleader(String orgId, Long userId) {
        QFilter qFilter = new QFilter("createorg", "=", (Object)Long.valueOf(orgId));
        qFilter.and("entryentity.userfield", "=", (Object)userId);
        qFilter.and("entryentity.teamleader", "=", (Object)Boolean.TRUE);
        DynamicObject[] groups = BusinessDataServiceHelper.load((String)"task_usergroup", (String)"id,name", (QFilter[])new QFilter[]{qFilter});
        return groups != null && groups.length != 0;
    }

    public static List<ComboItem> getSscenters(Long userid, String formId) {
        QFilter qFilter;
        List<Long> orgIDs = TeamLeaderHelper.getSscIds(userid, formId);
        if (PermissionServiceHelper.isSuperUser((long)userid)) {
            qFilter = null;
        } else {
            if ((orgIDs = TeamLeaderApi.siftNopermissionSscIds(orgIDs)) == null || orgIDs.size() == 0) {
                return new ArrayList<ComboItem>(1);
            }
            qFilter = new QFilter("id", "in", orgIDs);
        }
        ORM orm = ORM.create();
        DataSet set = orm.queryDataSet("bos_org_index", "bos_org", "id,number,name", new QFilter[]{qFilter});
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(10);
        Iterator rows = set.iterator();
        while (rows.hasNext()) {
            ComboItem citem = new ComboItem();
            Row groupRow = (Row)rows.next();
            String value = groupRow.getString(0);
            Object name = groupRow.get(1);
            LocaleString nameStr = (LocaleString)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)name), LocaleString.class);
            citem.setCaption(nameStr);
            citem.setValue(value);
            list.add(citem);
        }
        return list;
    }

    private static List<Long> siftNopermissionSscIds(List<Long> sscIds) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Map<String, Boolean> paramBatch = TeamLeaderApi.getParamBatch("usegrouptl", sscIds);
        Set<String> paramBatchKeys = paramBatch.entrySet().stream().filter(e -> (Boolean)e.getValue()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (Boolean)entry.getValue())).keySet();
        if (paramBatchKeys.size() == 0) {
            return sscIds;
        }
        Map<Long, Set<String>> map = TeamLeaderApi.getOrgRoleAssignMap(userId);
        if (map != null && map.size() > 0) {
            Iterator<String> iterator = paramBatchKeys.iterator();
            while (iterator.hasNext()) {
                String next = iterator.next();
                Set<String> roles = map.get(Long.valueOf(next));
                if (roles == null || !roles.contains("HXLFBW8ZGNH")) continue;
                iterator.remove();
            }
        }
        if (paramBatchKeys.size() == 0) {
            return sscIds;
        }
        HashSet<String> manageSsc = UserGroupUtil.getManageSsc(userId);
        if (manageSsc != null && manageSsc.size() > 0) {
            Iterator<String> iterator = paramBatchKeys.iterator();
            while (iterator.hasNext()) {
                if (!manageSsc.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        if (paramBatchKeys.size() == 0) {
            return sscIds;
        }
        Iterator<Long> iterator1 = sscIds.iterator();
        while (iterator1.hasNext()) {
            if (!paramBatchKeys.contains(iterator1.next() + "")) continue;
            iterator1.remove();
        }
        return sscIds;
    }

    public static boolean getBooleanParam(String paramKey, long orgId, boolean defVal) {
        AppParam param = new AppParam("83bfebc8000020ac", "12", Long.valueOf(orgId), Long.valueOf(0L));
        Object params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)paramKey);
        boolean result = defVal;
        if (null != params) {
            result = (Boolean)params;
        }
        return result;
    }

    public static Map<String, Boolean> getParamBatch(String paramKey, List<Long> orgIds) {
        AppParam param = new AppParam("83bfebc8000020ac", "12", null, Long.valueOf(0L));
        Map stringMapMap = SystemParamServiceHelper.loadBatchAppParameterByOrg((AppParam)param, orgIds);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(16);
        stringMapMap.forEach((key, value) -> {
            Object paramK = value.get(paramKey);
            if (paramK instanceof Boolean) {
                map.put((String)key, (Boolean)paramK);
            }
        });
        return map;
    }

    public static boolean isOpenTeamleader(String orgId) {
        return TeamLeaderApi.getBooleanParam("usegrouptl", Long.parseLong(orgId), false);
    }
}

