/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.common;

import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.param.ParameterCache;
import kd.bos.param.ParameterReader;

public class UserParameterHelper {
    public static final String SSC_USERPARAMETER_KEY = "SSC_USERPARAMETER_KEY";
    public static final String SSC_USERPARAMETER_KEY_WARNING_VALUE = "SSC_UK_WARNINGValue";
    public static final String SSC_USERPARAMETER_KEY_CUSTOM_CARD = "SSC_USER_CUSTOM_CARDS";
    public static final String INDEX_FORM_ID = "ssc_index_m";

    public static void saveKeyValue(String paramKey, String value) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String jsonStr = ParameterHelper.getUserCustParameter((long)userId, (String)INDEX_FORM_ID, (String)SSC_USERPARAMETER_KEY);
        Map map = StringUtils.isNotBlank((CharSequence)jsonStr) ? (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class) : new HashMap();
        map.put(paramKey, value);
        String jsonData = SerializationUtils.toJsonString(map);
        ParameterHelper.saveUserCustParameter((long)userId, (String)INDEX_FORM_ID, (String)SSC_USERPARAMETER_KEY, (String)jsonData);
        UserParameterHelper.removeThreadCache(userId, INDEX_FORM_ID, SSC_USERPARAMETER_KEY);
    }

    public static void removeThreadCache(Long userId, String formId, String paramKey) {
        String type = String.format("%s.%s", CacheKeyUtil.getAcctId(), "CUST_PARAMETER");
        String cacheKey = String.format("%s,%s,%s", userId, formId, paramKey);
        ThreadCache.remove((Object)(type + "." + cacheKey));
    }

    public static String getKeyValue(String paramKey) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String jsonStr = ParameterHelper.getUserCustParameter((long)userId, (String)INDEX_FORM_ID, (String)SSC_USERPARAMETER_KEY);
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
            return (String)map.get(paramKey);
        }
        return null;
    }

    public static void saveWarningValue(String paramKey, String value) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String jsonStr = ParameterHelper.getUserCustParameter((long)userId, (String)INDEX_FORM_ID, (String)SSC_USERPARAMETER_KEY_WARNING_VALUE);
        Map map = StringUtils.isNotBlank((CharSequence)jsonStr) ? (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class) : new HashMap();
        map.put(paramKey, value);
        String jsonData = SerializationUtils.toJsonString(map);
        ParameterHelper.saveUserCustParameter((long)userId, (String)INDEX_FORM_ID, (String)SSC_USERPARAMETER_KEY_WARNING_VALUE, (String)jsonData);
        UserParameterHelper.removeThreadCache(userId, INDEX_FORM_ID, SSC_USERPARAMETER_KEY_WARNING_VALUE);
    }

    public static void saveWarningValueMap(long userId, Map<String, String> map) {
        String jsonData = SerializationUtils.toJsonString(map);
        ParameterHelper.saveUserCustParameter((long)userId, (String)INDEX_FORM_ID, (String)SSC_USERPARAMETER_KEY_WARNING_VALUE, (String)jsonData);
        UserParameterHelper.removeThreadCache(userId, INDEX_FORM_ID, SSC_USERPARAMETER_KEY_WARNING_VALUE);
    }

    public static String getWarnningValue(String paramKey) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String jsonStr = ParameterHelper.getUserCustParameter((long)userId, (String)INDEX_FORM_ID, (String)SSC_USERPARAMETER_KEY_WARNING_VALUE);
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
            return (String)map.get(paramKey);
        }
        return null;
    }

    public static Map<String, String> getWarnningValueMap(Long userId) {
        String jsonStr = ParameterHelper.getUserCustParameter((long)userId, (String)INDEX_FORM_ID, (String)SSC_USERPARAMETER_KEY_WARNING_VALUE);
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            return (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
        }
        return new HashMap<String, String>();
    }

    public static void saveCustomCard(String cardStrs) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        ParameterHelper.saveUserCustParameter((long)userId, (String)"ssc_index_select_card_m", (String)SSC_USERPARAMETER_KEY_CUSTOM_CARD, (String)cardStrs);
        UserParameterHelper.removeThreadCache(userId, "ssc_index_select_card_m", SSC_USERPARAMETER_KEY_CUSTOM_CARD);
    }

    public static void delCustomCard() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        ParameterHelper.deleteUserCustParameter((String)"FUSERID=? AND FFORMID=? AND FEXTEND = ? ", (SqlParameter[])new SqlParameter[]{new SqlParameter("FUSERID", -5, (Object)userId), new SqlParameter("FFORMID", 12, (Object)"ssc_index_select_card_m"), new SqlParameter("FEXTEND", 12, (Object)SSC_USERPARAMETER_KEY_CUSTOM_CARD)});
        UserParameterHelper.removeThreadCache(userId, "ssc_index_select_card_m", SSC_USERPARAMETER_KEY_CUSTOM_CARD);
    }

    public static String getCustomCard() {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String formId = "ssc_index_select_card_m";
        String paramKey = SSC_USERPARAMETER_KEY_CUSTOM_CARD;
        String cacheValue = ParameterCache.getCustParamFromCache((Long)userId, (String)formId, (String)paramKey);
        if (cacheValue == null) {
            cacheValue = ParameterReader.getUserCustParameter((Long)userId, (String)formId, (String)paramKey);
            if (cacheValue == null) {
                return null;
            }
            ParameterCache.putCustParamToCache((Long)userId, (String)formId, (String)paramKey, (String)cacheValue);
        }
        return cacheValue;
    }
}

