/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.common.workcalendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.workcalendar.PersonInfo;
import kd.ssc.task.mobile.common.workcalendar.SscDateType;
import kd.ssc.task.mobile.common.workcalendar.SscLevelType;
import kd.ssc.task.mobile.common.workcalendar.SscTimeType;
import kd.ssc.task.mobile.common.workcalendar.SscWorkCalendarLoadService;
import kd.ssc.task.mobile.common.workcalendar.SscWorkCalendarUtil;
import kd.ssc.task.mobile.utils.CommonUtils;

public class SscWorkCalendarApi {
    private static final Log log = LogFactory.getLog(SscWorkCalendarApi.class);

    public static List<PersonInfo> getPersonWorkList(String orgId, String groupId) {
        List<PersonInfo> list = SscWorkCalendarLoadService.getUserListByGroupId(groupId);
        Map<Long, Boolean> map = SscWorkCalendarApi.isPersonsWork(orgId, groupId);
        if (list != null && list.size() > 0 && map != null && map.size() > 0) {
            for (PersonInfo p : list) {
                p.setWorkStatus(map.get(p.getUid()));
            }
        }
        return list;
    }

    public static Map<Long, Boolean> isPersonsWork(String orgId, String groupId) {
        SimpleDateFormat SDFTIME = new SimpleDateFormat("HH:mm");
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        Calendar now = Calendar.getInstance();
        int hour = now.get(11);
        int minute = now.get(12);
        HashMap<Long, Boolean> map = null;
        List<Long> userIdList = null;
        try {
            userIdList = SscWorkCalendarLoadService.getUserIdList(groupId);
            if (userIdList == null || userIdList.size() == 0) {
                return map;
            }
            map = new HashMap<Long, Boolean>(16);
            Date nowDate = SDF.parse(SDF.format(new Date()));
            Date nowTime = SDFTIME.parse(SscWorkCalendarUtil.getTimeShow(hour * 60 * 60 + minute * 60));
            DynamicObjectCollection sscCols = SscWorkCalendarApi.getData(orgId, null, nowDate, null);
            DynamicObjectCollection groupCols = SscWorkCalendarApi.getData(orgId, groupId, nowDate, null);
            DynamicObjectCollection userCols = SscWorkCalendarApi.getData(orgId, groupId, nowDate, userIdList);
            if (userCols != null && userCols.size() > 0) {
                Long userid;
                HashMap tempMap = new HashMap(16);
                ArrayList<DynamicObject> sublist = null;
                for (DynamicObject obj : userCols) {
                    userid = obj.getLong("dateentry.user");
                    if (tempMap.get(userid) != null) {
                        ((List)tempMap.get(userid)).add(obj);
                        continue;
                    }
                    sublist = new ArrayList<DynamicObject>(16);
                    sublist.add(obj);
                    tempMap.put(userid, sublist);
                }
                for (Map.Entry entry : tempMap.entrySet()) {
                    userid = (Long)entry.getKey();
                    List list = (List)entry.getValue();
                    boolean isWork = false;
                    for (DynamicObject obj : list) {
                        Date overTimeEnd;
                        String timeType = obj.getString("dateentry.timeentry.timetype");
                        if (SscTimeType.WORKTIME.getValue().equals(timeType)) {
                            Date amStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimeam"));
                            Date amEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimeam"));
                            Date pmStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimepm"));
                            Date pmEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimepm"));
                            boolean amf = SscWorkCalendarApi.belongTime(amStart, amEnd, nowTime);
                            boolean pmf = SscWorkCalendarApi.belongTime(pmStart, pmEnd, nowTime);
                            if (amf && pmf) {
                                isWork = true;
                                continue;
                            }
                            isWork = false;
                            continue;
                        }
                        if (SscTimeType.OFFTIME.getValue().equals(timeType)) {
                            Date offtimeEnd;
                            Date offtimeStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimeam"));
                            boolean offtimef = SscWorkCalendarApi.belongTime(offtimeStart, offtimeEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimeam")), nowTime);
                            if (offtimef) {
                                isWork = false;
                                continue;
                            }
                            int status = SscWorkCalendarApi.isWorkToGroupkOrSsc(nowTime, sscCols, groupCols);
                            if (status != 1) continue;
                            isWork = true;
                            continue;
                        }
                        if (!SscTimeType.OVERTIME.getValue().equals(timeType)) continue;
                        Date overTimeStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimeam"));
                        boolean overTimef = SscWorkCalendarApi.belongTime(overTimeStart, overTimeEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimeam")), nowTime);
                        if (overTimef) {
                            isWork = true;
                            continue;
                        }
                        int status = SscWorkCalendarApi.isWorkToGroupkOrSsc(nowTime, sscCols, groupCols);
                        if (status != 1) continue;
                        isWork = true;
                    }
                    map.put(userid, isWork);
                }
                if (tempMap.size() < userIdList.size()) {
                    ArrayList<Long> groupInit = new ArrayList<Long>(16);
                    if (map.size() > 0) {
                        for (Long user : userIdList) {
                            if (map.containsKey(user)) continue;
                            groupInit.add(user);
                        }
                    }
                    SscWorkCalendarApi.fillWorkMap(nowTime, map, groupInit, sscCols, groupCols);
                }
            } else {
                SscWorkCalendarApi.fillWorkMap(nowTime, map, userIdList, sscCols, groupCols);
            }
        }
        catch (ParseException e) {
            log.error(e.getMessage());
        }
        return map;
    }

    public static void fillWorkMap(Date nowTime, Map<Long, Boolean> map, List<Long> userIdList, DynamicObjectCollection sscCols, DynamicObjectCollection groupCols) throws ParseException {
        int status = SscWorkCalendarApi.isWorkToGroupkOrSsc(nowTime, sscCols, groupCols);
        if (status == -1) {
            return;
        }
        boolean isWork = false;
        if (status == 1) {
            isWork = true;
        }
        for (Long uid : userIdList) {
            map.put(uid, isWork);
        }
    }

    public static int isWorkToGroupkOrSsc(Date nowTime, DynamicObjectCollection sscCols, DynamicObjectCollection groupCols) throws ParseException {
        Date amStart = null;
        Date amEnd = null;
        Date pmStart = null;
        Date pmEnd = null;
        SimpleDateFormat SDFTIME = new SimpleDateFormat("HH:mm");
        int isWork = 0;
        if (groupCols != null && groupCols.size() > 0) {
            String datetype = ((DynamicObject)groupCols.get(0)).getString("dateentry.datetype");
            for (DynamicObject obj : groupCols) {
                if (SscDateType.WORKDATE.getValue().equals(datetype)) {
                    amStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimeam"));
                    amEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimeam"));
                    pmStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimepm"));
                    pmEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimepm"));
                    boolean amf = SscWorkCalendarApi.belongTime(amStart, amEnd, nowTime);
                    boolean pmf = SscWorkCalendarApi.belongTime(pmStart, pmEnd, nowTime);
                    if (!amf && !pmf) break;
                    isWork = 1;
                    break;
                }
                if (SscDateType.HALFWORKDATEAM.getValue().equals(datetype)) {
                    amStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimeam"));
                    boolean amf = SscWorkCalendarApi.belongTime(amStart, amEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimeam")), nowTime);
                    if (!amf) break;
                    isWork = 1;
                    break;
                }
                if (!SscDateType.HALFWORKDATEPM.getValue().equals(datetype)) continue;
                pmStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimepm"));
                boolean pmf = SscWorkCalendarApi.belongTime(pmStart, pmEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimepm")), nowTime);
                if (!pmf) break;
                isWork = 1;
                break;
            }
        } else {
            if (sscCols == null || sscCols.size() <= 0) {
                return -1;
            }
            String datetype = ((DynamicObject)sscCols.get(0)).getString("dateentry.datetype");
            for (DynamicObject obj : sscCols) {
                if (SscDateType.WORKDATE.getValue().equals(datetype)) {
                    amStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimeam"));
                    amEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimeam"));
                    pmStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimepm"));
                    pmEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimepm"));
                    boolean amf = SscWorkCalendarApi.belongTime(amStart, amEnd, nowTime);
                    boolean pmf = SscWorkCalendarApi.belongTime(pmStart, pmEnd, nowTime);
                    if (!amf && !pmf) break;
                    isWork = 1;
                    break;
                }
                if (SscDateType.HALFWORKDATEAM.getValue().equals(datetype)) {
                    amStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimeam"));
                    boolean amf = SscWorkCalendarApi.belongTime(amStart, amEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimeam")), nowTime);
                    if (!amf) break;
                    isWork = 1;
                    break;
                }
                if (!SscDateType.HALFWORKDATEPM.getValue().equals(datetype)) continue;
                pmStart = SDFTIME.parse(obj.getString("dateentry.timeentry.begintimepm"));
                boolean pmf = SscWorkCalendarApi.belongTime(pmStart, pmEnd = SDFTIME.parse(obj.getString("dateentry.timeentry.endtimepm")), nowTime);
                if (!pmf) break;
                isWork = 1;
                break;
            }
        }
        return isWork;
    }

    public static boolean isWork(String beginTime, String endTime, String targetTime) {
        Date start = SscWorkCalendarApi.corventTime(beginTime);
        Date end = SscWorkCalendarApi.corventTime(endTime);
        Date target = SscWorkCalendarApi.corventTime(targetTime);
        boolean result = SscWorkCalendarApi.belongTime(start, end, target);
        return result;
    }

    private boolean isAmTime(int hour) {
        boolean b = true;
        if (hour >= 0 && hour <= 12 || hour <= 12 || hour <= 23) {
            // empty if block
        }
        return b;
    }

    private static Date corventTime(String time) {
        Date date = null;
        SimpleDateFormat SDFTIME = new SimpleDateFormat("HH:mm");
        try {
            date = SDFTIME.parse(time);
        }
        catch (ParseException e) {
            log.error(e.getMessage());
        }
        return date;
    }

    public static boolean belongTime(Date beginTime, Date endTime, Date nowTime) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(beginTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static DynamicObjectCollection getData(String orgId, String groupId, Date nowDate, List<Long> userIdList) {
        QFilter filters = new QFilter("ssccenter", "=", (Object)CommonUtils.toLong(orgId, -1L));
        if (groupId != null && (userIdList == null || userIdList.size() == 0)) {
            filters.and(new QFilter("dateentry.usergroup", "=", (Object)CommonUtils.toLong(groupId, -1L)));
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.GROUP.getValue()));
        } else if (groupId != null) {
            filters.and(new QFilter("dateentry.user", "in", userIdList));
            filters.and(new QFilter("dateentry.usergroup", "=", (Object)CommonUtils.toLong(groupId, -1L)));
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.EMPLOYEE.getValue()));
        } else {
            filters.and(new QFilter("dateentry.level", "=", (Object)SscLevelType.SSCCENTER.getValue()));
        }
        filters.and(new QFilter("dateentry.date", "=", (Object)nowDate));
        return QueryServiceHelper.query((String)"ssc_workcalendarsetting", (String)"id,dateentry.id,dateentry.level,dateentry.ssc,dateentry.usergroup,dateentry.datetype,dateentry.user,dateentry.timeentry.*", (QFilter[])new QFilter[]{filters});
    }
}

