/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.efficiency;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.AbstractFormView;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.efficiency.EfficiencyHelper;
import kd.ssc.task.mobile.formplugin.efficiency.EfficiencyModel;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplatePlugin;
import kd.ssc.task.mobile.utils.CommonUtils;

public class SscEfficiencyAnalysisCardPlugin
extends SscCardTemplatePlugin {
    private int xAxisItemNum;

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("radiogroupfield".equals(e.getProperty().getName())) {
            this.refreshEfficiencyTend(false);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"detailbtn", "effictips"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("detailbtn".equals(key)) {
            this.jumpToGroupEfficiencyPage();
        } else if ("effictips".equals(key)) {
            String title = ResManager.loadKDString((String)"\u4eba\u5747\u6548\u80fd", (String)"SscEfficiencyAnalysisCardPlugin_9", (String)"ssc-task-mobile", (Object[])new Object[0]);
            String msg = ResManager.loadKDString((String)"\u5e73\u5747\u6bcf\u4eba\u5df2\u5b8c\u6210\u7684\u4efb\u52a1\u91cf\uff0c\u5176\u4e2d\u4efb\u52a1\u91cf\u7531\u4efb\u52a1\u4e58\u4ee5\u4efb\u52a1\u91cf\u7cfb\u6570\u5f97\u51fa\u3002", (String)"SscEfficiencyAnalysisCardPlugin_6", (String)"ssc-task-mobile", (Object[])new Object[0]);
            this.showMessage(title, msg);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String sscIdStr = (String)this.getView().getFormShowParameter().getCustomParam("sharecenter");
        if (sscIdStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"SscEfficiencyAnalysisCardPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
        this.refreshEfficiencyTend(true);
    }

    private void refreshEfficiencyTend(boolean firstLoad) {
        Object[] xAxisAndItems = this.loadEfficiencyData(firstLoad);
        this.createTendChart(xAxisAndItems);
    }

    private Object[] loadEfficiencyData(boolean firstLoad) {
        Object date;
        int i;
        Date endQueryDate;
        Date beginQueryDate;
        SimpleDateFormat dateFormat;
        String[] dataKeyArray;
        String[] xAxisDateArray;
        Long sscId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        String dateRange = (String)this.getModel().getValue("radiogroupfield");
        if ("month".equals(dateRange)) {
            this.xAxisItemNum = 6;
            xAxisDateArray = new String[this.xAxisItemNum];
            dataKeyArray = new String[this.xAxisItemNum];
            dateFormat = new SimpleDateFormat("M");
            LocalDate firstDayOfPrevious5Month = LocalDate.now().minusMonths(5L).with(TemporalAdjusters.firstDayOfMonth());
            beginQueryDate = CommonUtils.localDate2Date(firstDayOfPrevious5Month);
            endQueryDate = CommonUtils.localDate2Date(LocalDate.now().with(TemporalAdjusters.lastDayOfMonth()).plusDays(1L));
            for (i = 0; i < this.xAxisItemNum; ++i) {
                date = firstDayOfPrevious5Month.plusMonths(i);
                xAxisDateArray[i] = ((LocalDate)date).getMonth().getDisplayName(TextStyle.SHORT, Lang.get().getLocale());
                dataKeyArray[i] = dateFormat.format(CommonUtils.localDate2Date((LocalDate)date));
            }
        } else {
            this.xAxisItemNum = 7;
            xAxisDateArray = new String[this.xAxisItemNum];
            dataKeyArray = new String[this.xAxisItemNum];
            dateFormat = new SimpleDateFormat("d");
            LocalDate previous6Day = LocalDate.now().minusDays(6L);
            beginQueryDate = CommonUtils.localDate2Date(previous6Day);
            endQueryDate = CommonUtils.localDate2Date(LocalDate.now().plusDays(1L));
            for (i = 0; i < this.xAxisItemNum; ++i) {
                xAxisDateArray[i] = date = previous6Day.plusDays(i).getDayOfMonth() + "";
                dataKeyArray[i] = date;
            }
        }
        QFilter userFilter = SscEfficiencyAnalysisCardPlugin.userFilter(sscId, (String)this.getView().getFormShowParameter().getCustomParam("usergroup"));
        QFilter filters = userFilter.and("pooltype", "=", (Object)"2").and("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK).and("completetime", ">=", (Object)beginQueryDate).and("completetime", "<", (Object)endQueryDate);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_taskhistory", (String)"id,personid,usergroup.id,coefficient,completetime", (QFilter[])filters.toArray());
        IFormView view = this.getView();
        if (tasks.isEmpty()) {
            view.setVisible(Boolean.FALSE, new String[]{"contentflexcore", "detailbtn", "cc_icon_popover"});
            view.setVisible(Boolean.TRUE, new String[]{"defaultflex"});
            String text = "month".equals(dateRange) ? ResManager.loadKDString((String)"\u8fc7\u53bb6\u4e2a\u6708\u6682\u65e0\u5df2\u5b8c\u6210\u7684\u4efb\u52a1", (String)"SscEfficiencyAnalysisCardPlugin_10", (String)"ssc-task-mobile", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8fc7\u53bb7\u5929\u6682\u65e0\u5df2\u5b8c\u6210\u7684\u4efb\u52a1", (String)"SscEfficiencyAnalysisCardPlugin_11", (String)"ssc-task-mobile", (Object[])new Object[0]);
            ((Label)view.getControl("defaultlabel")).setText(text);
            return null;
        }
        view.setVisible(Boolean.TRUE, new String[]{"contentflexcore", "detailbtn", "cc_icon_popover"});
        view.setVisible(Boolean.FALSE, new String[]{"defaultflex"});
        ArrayList<EfficiencyModel> items = new ArrayList<EfficiencyModel>(this.xAxisItemNum);
        BigDecimal zero = BigDecimal.ZERO.setScale(1, 4);
        BigDecimal errorCount = BigDecimal.ZERO;
        Map<String, List<DynamicObject>> taskGroupByCompleteDate = tasks.stream().collect(Collectors.groupingBy(t -> dateFormat.format(t.getDate("completetime"))));
        for (int i2 = 0; i2 < this.xAxisItemNum; ++i2) {
            List<DynamicObject> ts = taskGroupByCompleteDate.get(dataKeyArray[i2]);
            if (ts != null && ts.size() > 0) {
                BigDecimal taskCount = zero;
                for (DynamicObject t2 : ts) {
                    BigDecimal curTask = t2.getBigDecimal("coefficient");
                    if (curTask.compareTo(zero) <= 0) {
                        curTask = BigDecimal.ONE;
                        errorCount = errorCount.add(BigDecimal.ONE);
                    }
                    taskCount = taskCount.add(curTask);
                }
                Map<Long, List<DynamicObject>> taskGroupByPerson = ts.stream().collect(Collectors.groupingBy(e -> e.getLong("personid")));
                int peopleCount = taskGroupByPerson.size();
                BigDecimal efficiency = taskCount.divide(new BigDecimal(peopleCount), 1, 4);
                items.add(new EfficiencyModel(taskCount.setScale(1, 4), efficiency, peopleCount));
                continue;
            }
            items.add(new EfficiencyModel(zero, zero, 0));
        }
        this.refreshErrorCountFP(errorCount);
        if (firstLoad) {
            this.getPageCache().put("CACHE_SHARE_VALUE", ((EfficiencyModel)items.get(this.xAxisItemNum - 1)).getEfficiency().toString());
        }
        return new Object[]{xAxisDateArray, items};
    }

    private void createTendChart(Object[] xAxisAndItems) {
        if (xAxisAndItems == null) {
            return;
        }
        CustomChart tendChart = (CustomChart)this.getControl("efficiencytendchart");
        tendChart.clearData();
        tendChart.setShowLegend(true);
        tendChart.setLegendPropValue("left", (Object)"0%");
        tendChart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
        tendChart.setShowTooltip(true);
        tendChart.addTooltip("trigger", (Object)"axis");
        String taskStr = ResManager.loadKDString((String)"\u5b8c\u6210\u4efb\u52a1\u91cf\uff1a", (String)"SscEfficiencyAnalysisCardPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]);
        String peopleStr = ResManager.loadKDString((String)"\u5904\u7406\u4eba\u6570\uff1a", (String)"SscEfficiencyAnalysisCardPlugin_5", (String)"ssc-task-mobile", (Object[])new Object[0]);
        String efficStr = ResManager.loadKDString((String)"\u4eba\u5747\u6548\u80fd\uff1a", (String)"SscEfficiencyAnalysisCardPlugin_4", (String)"ssc-task-mobile", (Object[])new Object[0]);
        tendChart.addTooltip("formatter", (Object)("function(i) {var d = i[0].data;return '" + taskStr + "' + d.value.toFixed(1) + '<br />" + peopleStr + "' + d.p + '<br />" + efficStr + "' +  d.e.toFixed(1);}"));
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        tendChart.addFuncPath(toolTipFuncPath);
        tendChart.setMargin(Position.left, "4%");
        tendChart.setMargin(Position.right, "4%");
        String taskStr2 = ResManager.loadKDString((String)"\u5b8c\u6210\u4efb\u52a1\u91cf", (String)"SscEfficiencyAnalysisCardPlugin_8", (String)"ssc-task-mobile", (Object[])new Object[0]);
        BarSeries barSeries = tendChart.createBarSeries(taskStr2);
        barSeries.setPropValue("yAxisIndex", (Object)0);
        barSeries.setPropValue("barWidth", (Object)18);
        barSeries.setPropValue("itemStyle", Collections.singletonMap("normal", Collections.singletonMap("color", "#276FF5")));
        barSeries.setPropValue("label", Collections.singletonMap("show", Boolean.FALSE));
        String efficStr2 = ResManager.loadKDString((String)"\u4eba\u5747\u6548\u80fd", (String)"SscEfficiencyAnalysisCardPlugin_9", (String)"ssc-task-mobile", (Object[])new Object[0]);
        LineSeries lineSeries = tendChart.createLineSeries(efficStr2);
        lineSeries.setPropValue("yAxisIndex", (Object)1);
        lineSeries.setPropValue("itemStyle", Collections.singletonMap("normal", Collections.singletonMap("color", "#38E47A")));
        HashMap[] barData = new HashMap[this.xAxisItemNum];
        Number[] lineData = new Number[this.xAxisItemNum];
        BigDecimal maxTask = BigDecimal.ZERO;
        BigDecimal maxEfficiency = BigDecimal.ZERO;
        ArrayList items = (ArrayList)xAxisAndItems[1];
        for (int i = 0; i < items.size(); ++i) {
            EfficiencyModel model = (EfficiencyModel)items.get(i);
            BigDecimal curEfficiency = model.getEfficiency();
            BigDecimal curTask = model.getTaskOfDate();
            HashMap<String, Number> barItem = new HashMap<String, Number>();
            barItem.put("value", curTask);
            barItem.put("e", curEfficiency);
            barItem.put("p", model.getPeopleCount());
            barData[i] = barItem;
            lineData[i] = curEfficiency;
            if (curTask.compareTo(maxTask) > 0) {
                maxTask = curTask;
            }
            if (curEfficiency.compareTo(maxEfficiency) <= 0) continue;
            maxEfficiency = curEfficiency;
        }
        barSeries.setPropValue("data", (Object)barData);
        lineSeries.setPropValue("data", (Object)lineData);
        Axis xAxis = tendChart.createXAxis(null, AxisType.category);
        xAxis.setPropValue("axisTick", Collections.singletonMap("show", Boolean.FALSE));
        xAxis.setPropValue("axisLine", Collections.singletonMap("show", Boolean.FALSE));
        xAxis.setPropValue("axisLabel", Collections.singletonMap("color", "#999999"));
        xAxis.setPropValue("data", xAxisAndItems[0]);
        BigDecimal splitNum = new BigDecimal("4");
        Axis yAxis1 = tendChart.createYAxis(taskStr2, AxisType.value);
        yAxis1.setPropValue("axisTick", Collections.singletonMap("show", Boolean.FALSE));
        yAxis1.setPropValue("axisLine", Collections.singletonMap("show", Boolean.FALSE));
        yAxis1.setPropValue("axisLabel", Collections.singletonMap("color", "#999999"));
        yAxis1.setPropValue("splitLine", Collections.singletonMap("show", Boolean.FALSE));
        BigDecimal fitMaxTask = EfficiencyHelper.calcFitMaxValue(maxTask);
        yAxis1.setPropValue("max", (Object)fitMaxTask);
        yAxis1.setPropValue("interval", (Object)fitMaxTask.divide(splitNum, 1, 4));
        yAxis1.setPropValue("axisLabel", Collections.singletonMap("formatter", "function(v, i) {return v.toFixed(1)}"));
        ArrayList<String> yAxisLabelFuncPath0 = new ArrayList<String>();
        yAxisLabelFuncPath0.add("yAxis");
        yAxisLabelFuncPath0.add("0");
        yAxisLabelFuncPath0.add("axisLabel");
        yAxisLabelFuncPath0.add("formatter");
        tendChart.addFuncPath(yAxisLabelFuncPath0);
        Axis yAxis2 = tendChart.createYAxis(efficStr2, AxisType.value);
        yAxis2.setPropValue("axisTick", Collections.singletonMap("show", Boolean.FALSE));
        yAxis2.setPropValue("axisLine", Collections.singletonMap("show", Boolean.FALSE));
        yAxis2.setPropValue("axisLabel", Collections.singletonMap("color", "#999999"));
        yAxis2.setPropValue("splitLine", Collections.singletonMap("lineStyle", Collections.singletonMap("type", "dotted")));
        BigDecimal fitMaxEfficiency = EfficiencyHelper.calcFitMaxValue(maxEfficiency);
        yAxis2.setPropValue("max", (Object)fitMaxEfficiency);
        yAxis2.setPropValue("interval", (Object)fitMaxEfficiency.divide(splitNum, 1, 4));
        yAxis2.setPropValue("axisLabel", Collections.singletonMap("formatter", "function(v, i) {return v.toFixed(1)}"));
        ArrayList<String> yAxisLabelFuncPath1 = new ArrayList<String>();
        yAxisLabelFuncPath1.add("yAxis");
        yAxisLabelFuncPath1.add("1");
        yAxisLabelFuncPath1.add("axisLabel");
        yAxisLabelFuncPath1.add("formatter");
        tendChart.addFuncPath(yAxisLabelFuncPath1);
        tendChart.refresh();
    }

    private static QFilter userFilter(Long sscid, String usergroup) {
        QFilter userFilter = new QFilter("sscid", "=", (Object)sscid);
        if (usergroup == null || "".equals(usergroup) || "-1".equals(usergroup)) {
            return userFilter;
        }
        return userFilter.and("usergroup.id", "=", (Object)Long.valueOf(usergroup));
    }

    private void jumpToGroupEfficiencyPage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_effic_group_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(ResManager.loadKDString((String)"\u4eba\u5747\u6548\u80fd\u5206\u5e03", (String)"SscEfficiencyAnalysisCardPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        parameter.setCustomParam("sharecenter", formShowParameter.getCustomParam("sharecenter"));
        parameter.setCustomParam("usergroup", formShowParameter.getCustomParam("usergroup"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.EfficiencyTrendCard.getCaption());
        String shareValue = this.getPageCache().get("CACHE_SHARE_VALUE");
        String content = String.format(ResManager.loadKDString((String)"\u672c\u6708\u4eba\u5747\u6548\u80fd\uff1a%s", (String)"SscEfficiencyAnalysisCardPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]), shareValue);
        args.put("content", content);
        args.put("cellContent", content);
    }

    private void showMessage(String title, String msg) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("confirmType", ConfirmTypes.Default.getValue());
        map.put("button_type", MessageBoxOptions.None.getValue());
        map.put("msg", msg);
        map.put("title", title);
        ((AbstractFormView)this.getView()).getClientProxy().addAction("showConfirm", map);
    }

    private void refreshErrorCountFP(BigDecimal errorCount) {
        if (errorCount.compareTo(BigDecimal.ZERO) > 0) {
            ((Label)this.getControl("errorcountlabel")).setText(String.format(ResManager.loadKDString((String)"%s\u6761\u4efb\u52a1\u83b7\u53d6\u4efb\u52a1\u91cf\u7cfb\u6570\u5931\u8d25\uff0c\u9ed8\u8ba4\u4e3a\u6807\u51c6\u7cfb\u65701.00\u3002", (String)"SscEfficiencyAnalysisCardPlugin_12", (String)"ssc-task-mobile", (Object[])new Object[0]), errorCount));
            this.getView().setVisible(Boolean.TRUE, new String[]{"errorcountfp"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"errorcountfp"});
        }
    }
}

