/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.efficiency;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.common.TeamLeaderApi;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.efficiency.EfficiencyModel;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplatePlugin;
import kd.ssc.task.mobile.utils.CommonUtils;

public class SscEfficiencyGroupMobFormPlugin
extends SscCardTemplatePlugin
implements RowClickEventListener {
    private static final String ALGO_KEY = SscEfficiencyGroupMobFormPlugin.class.getName();
    public static final String KEY_ENTRY = "entryentity";
    public static final String KEY_LISTFP = "listfp";
    public static final String KEY_SELECTED_DATE = "datefield";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (KEY_SELECTED_DATE.equals(e.getProperty().getName())) {
            this.refreshGroupEfficiencyList();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid expenseGrid = (AbstractGrid)this.getView().getControl(KEY_ENTRY);
        expenseGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(KEY_ENTRY);
        DynamicObject curRow = (DynamicObject)entryEntity.get(row);
        String userGroupId = curRow.getString("usergroupid");
        String userGroupName = curRow.getString("usergroupname");
        String sscName = this.getPageCache().get("sscName");
        Date selectedDate = (Date)model.getValue(KEY_SELECTED_DATE);
        this.jumpToUserEfficiencyPage(userGroupId, userGroupName, sscName, selectedDate);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String sscIdStr = (String)this.getView().getFormShowParameter().getCustomParam("sharecenter");
        if (sscIdStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u5171\u4eab\u4e2d\u5fc3\u3002", (String)"SscEfficiencyGroupMobFormPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
        this.refreshGroupEfficiencyList();
    }

    private void refreshGroupEfficiencyList() {
        DynamicObjectCollection groups;
        IFormView view = this.getView();
        Long sscId = Long.parseLong((String)view.getFormShowParameter().getCustomParam("sharecenter"));
        String userGroupId = (String)view.getFormShowParameter().getCustomParam("usergroup");
        String singleGroupName = null;
        if (userGroupId == null || "".equals(userGroupId) || "-1".equals(userGroupId)) {
            long userId = Long.parseLong(RequestContext.get().getUserId());
            QFilter qFilter = new QFilter("createorg", "=", (Object)sscId);
            boolean isAdmin = TeamLeaderApi.isAdminRole(String.valueOf(sscId), userId, "HXLFBW8ZGNH");
            if (!isAdmin) {
                qFilter.and("entryentity.userfield", "=", (Object)userId);
                if (TeamLeaderApi.isOpenTeamleader(String.valueOf(sscId))) {
                    qFilter.and("entryentity.teamleader", "=", (Object)Boolean.TRUE);
                }
            }
            groups = QueryServiceHelper.query((String)"task_usergroup", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
        } else {
            DynamicObject group = QueryServiceHelper.queryOne((String)"task_usergroup", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(userGroupId))});
            groups = new DynamicObjectCollection();
            groups.add((Object)group);
            singleGroupName = group.getString("name");
        }
        if (groups.size() == 0) {
            view.setVisible(Boolean.FALSE, new String[]{KEY_LISTFP});
            BigDecimal zero = new BigDecimal("0.0");
            ((Label)view.getControl("efficiency")).setText(zero.toString());
            ((Label)view.getControl("taskcount")).setText(zero.toString());
            ((Label)view.getControl("peoplecount")).setText("0");
            return;
        }
        LocalDate selectedDate = ((Date)this.getModel().getValue(KEY_SELECTED_DATE)).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Date beginQueryDate = CommonUtils.localDate2Date(selectedDate.with(TemporalAdjusters.firstDayOfMonth()));
        Date endQueryDate = CommonUtils.localDate2Date(selectedDate.with(TemporalAdjusters.lastDayOfMonth()).plusDays(1L));
        QFilter filters = SscEfficiencyGroupMobFormPlugin.userFilter(sscId, userGroupId).and("pooltype", "=", (Object)"2").and("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK).and("completetime", ">=", (Object)beginQueryDate).and("completetime", "<", (Object)endQueryDate);
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"task_taskhistory", (String)"id,personid,usergroup.id,coefficient,completetime", (QFilter[])filters.toArray());
        Map<Long, List<DynamicObject>> taskGroupByUserGroup = tasks.stream().collect(Collectors.groupingBy(e -> e.getLong("usergroup.id")));
        ArrayList<EfficiencyModel> entryList = new ArrayList<EfficiencyModel>();
        BigDecimal zero = BigDecimal.ZERO.setScale(1, 4);
        BigDecimal totalTaskCount = BigDecimal.ZERO;
        HashSet<Long> totalPeopleSet = new HashSet<Long>();
        for (DynamicObject group : groups) {
            long usergroup = group.getLong("id");
            List<DynamicObject> taskOfOneGroup = taskGroupByUserGroup.get(usergroup);
            if (taskOfOneGroup != null) {
                BigDecimal taskCount = BigDecimal.ZERO;
                for (DynamicObject task : taskOfOneGroup) {
                    BigDecimal curTask = task.getBigDecimal("coefficient");
                    if (curTask.compareTo(BigDecimal.ZERO) <= 0) {
                        curTask = BigDecimal.ONE;
                    }
                    taskCount = taskCount.add(curTask);
                }
                totalTaskCount = totalTaskCount.add(taskCount);
                Set<Long> userOfOneGroup = taskOfOneGroup.stream().collect(Collectors.groupingBy(e -> e.getLong("personid"))).keySet();
                totalPeopleSet.addAll(userOfOneGroup);
                int peopleCount = userOfOneGroup.size();
                BigDecimal efficiencyOfOneGroup = taskCount.divide(new BigDecimal(peopleCount), 1, 4);
                entryList.add(new EfficiencyModel(group.getLong("id"), group.getString("name"), taskCount.setScale(1, 4), efficiencyOfOneGroup, peopleCount));
                continue;
            }
            entryList.add(new EfficiencyModel(group.getLong("id"), group.getString("name"), zero, zero, 0));
        }
        entryList.sort((a, b) -> b.getEfficiency().compareTo(a.getEfficiency()));
        this.createRows(entryList);
        int totalPeopleCount = totalPeopleSet.size();
        BigDecimal totalEfficiency = totalPeopleCount > 0 ? totalTaskCount.divide(new BigDecimal(totalPeopleCount), 1, 4) : new BigDecimal("0.0");
        ((Label)view.getControl("efficiency")).setText(totalEfficiency.toString());
        ((Label)view.getControl("taskcount")).setText(totalTaskCount.setScale(1, 4).toString());
        ((Label)view.getControl("peoplecount")).setText(totalPeopleCount + "");
        String name = CommonQueryHelper.getNameById("bos_org", sscId);
        this.getPageCache().put("sscName", name);
        ((Label)view.getControl("sscentername")).setText(name);
        if (singleGroupName == null) {
            ((Label)view.getControl("usergrouplabel")).setText(ResManager.loadKDString((String)"\u5168\u90e8\u7528\u6237\u7ec4", (String)"SscEfficiencyGroupMobFormPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            ((Label)view.getControl("usergrouplabel")).setText(singleGroupName);
        }
    }

    private void createRows(ArrayList<EfficiencyModel> entryList) {
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY);
        model.beginInit();
        int size = entryList.size();
        model.batchCreateNewEntryRow(KEY_ENTRY, size);
        DynamicObjectCollection efficiencyEntryEntity = model.getEntryEntity(KEY_ENTRY);
        DynamicProperty userGroupId = efficiencyEntryEntity.getDynamicObjectType().getProperty("usergroupid");
        DynamicProperty userGroupName = efficiencyEntryEntity.getDynamicObjectType().getProperty("usergroupname");
        DynamicProperty taskAndPeople = efficiencyEntryEntity.getDynamicObjectType().getProperty("taskpeople");
        DynamicProperty effciencyOfGroup = efficiencyEntryEntity.getDynamicObjectType().getProperty("effciencyofgroup");
        for (int i = 0; i < size; ++i) {
            EfficiencyModel efficiencyModel = entryList.get(i);
            DynamicObject entry = (DynamicObject)efficiencyEntryEntity.get(i);
            userGroupId.setValueFast((Object)entry, (Object)efficiencyModel.getGroupId());
            userGroupName.setValueFast((Object)entry, (Object)efficiencyModel.getGroupName());
            taskAndPeople.setValueFast((Object)entry, (Object)(efficiencyModel.getTaskOfGroup() + "/" + efficiencyModel.getPeopleCount()));
            effciencyOfGroup.setValueFast((Object)entry, (Object)efficiencyModel.getEfficiency());
        }
        model.endInit();
        IFormView view = this.getView();
        this.getView().updateView(KEY_ENTRY);
        view.setVisible(Boolean.TRUE, new String[]{KEY_LISTFP});
    }

    private void jumpToUserEfficiencyPage(String userGroupId, String userGroupName, String sscName, Date selectedDate) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_effic_user_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(ResManager.loadKDString((String)"\u4eba\u5747\u6548\u80fd\u5206\u5e03", (String)"SscEfficiencyGroupMobFormPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]));
        parameter.setCustomParam("sharecenter", this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        parameter.setCustomParam("usergroup", (Object)userGroupId);
        parameter.setCustomParam("sscName", (Object)sscName);
        parameter.setCustomParam("userGroupName", (Object)userGroupName);
        parameter.setCustomParam("selectedDate", (Object)selectedDate);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private static QFilter userFilter(Long sscid, String usergroup) {
        QFilter userFilter = new QFilter("sscid", "=", (Object)sscid);
        if (usergroup == null || "".equals(usergroup) || "-1".equals(usergroup)) {
            return userFilter;
        }
        return userFilter.and("usergroup.id", "=", (Object)Long.valueOf(usergroup));
    }
}

