/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.RefreshResultType;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.mobile.common.TeamLeaderApi;
import kd.ssc.task.mobile.formplugin.index.TeamLeaderHelper;

public class AbstractFilterPlugin
extends AbstractMobFormPlugin {
    public static final Log logger = LogFactory.getLog(AbstractFilterPlugin.class);
    private static final String VIEW_PERMID = "47150e89000000ac";
    protected static final String CTRL_SHARECENTER = "sharecenter";
    protected static final String CTRL_USERGROUP = "usergroup";
    protected static final String CTRL_CARD_COMTAINER = "cardcontainer";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgF7 = (BasedataEdit)this.getControl(CTRL_SHARECENTER);
        orgF7.addBeforeF7SelectListener(evt -> {
            QFilter qFilter = TeamLeaderHelper.getPermSscOrgsQFilters();
            evt.addCustomQFilter(qFilter);
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initShareCenterAndUserGroup();
    }

    private void initShareCenterAndUserGroup() {
        Object setShareCenter = this.getShareCenterId();
        if (setShareCenter == null) {
            long userId = RequestContext.get().getCurrUserId();
            if (PermissionServiceHelper.isSuperUser((long)userId)) {
                setShareCenter = this.getSetShareCenter(Collections.emptyList(), true);
                this.getModel().setValue(CTRL_SHARECENTER, setShareCenter);
            } else if (this.checkIndexPermission(userId)) {
                List<Long> sscIds = TeamLeaderHelper.getSscIds(userId, "ssc_index_m");
                if (sscIds.isEmpty()) {
                    this.showMessageAndExit(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u5171\u4eab\u4e2d\u5fc3\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractFilterPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]));
                    return;
                }
                Set<Long> nopermissionSscIdSet = TeamLeaderHelper.getNopermissionSscIdSet(sscIds);
                sscIds.removeAll(nopermissionSscIdSet);
                if (sscIds.isEmpty()) {
                    this.showMessageAndExit(ResManager.loadKDString((String)"\u67e5\u770b\u8be5\u9875\u9762\u9700\u5177\u5907\u7528\u6237\u7ec4\u7684\u7ec4\u957f\u6743\u9650\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7ef4\u62a4\u3002", (String)"AbstractFilterPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]));
                    return;
                }
                setShareCenter = this.getSetShareCenter(sscIds, false);
                this.getModel().setValue(CTRL_SHARECENTER, setShareCenter);
            } else {
                this.showMessageAndExit(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5171\u4eab\u6d1e\u5bdf\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"AbstractFilterPlugin_4", (String)"ssc-task-mobile", (Object[])new Object[0]));
                return;
            }
        }
        if (StringUtils.isBlank((Object)setShareCenter)) {
            return;
        }
        this.setGroup(setShareCenter, this.getUserId(), Boolean.TRUE);
        Object userGroupId = this.getUserGroupId();
        this.pageCache(setShareCenter, userGroupId);
        this.buildCardData(setShareCenter, userGroupId);
    }

    public void refreshData() {
        super.refreshData();
        this.refresh();
        this.setRefreshSuccess();
    }

    private boolean checkIndexPermission(long userId) {
        return PermissionServiceHelper.hasSpecificPerm((long)userId, null, (String)"ssc_index_m", (String)VIEW_PERMID);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (CTRL_SHARECENTER.equals(propertyName)) {
            Object oldUserGroupId = this.getUserGroupId();
            Object shareCenterId = this.getShareCenterId();
            if (!TeamLeaderHelper.checkPermShareCenter(shareCenterId)) {
                logger.error("checkPermShareCenter : forbidden operation");
                this.getView().close();
                throw new KDBizException("forbidden operation");
            }
            this.setGroup(shareCenterId, this.getUserId(), Boolean.FALSE);
            Object newUserGroupId = this.getUserGroupId();
            if (newUserGroupId != null && newUserGroupId.equals(oldUserGroupId)) {
                this.pageCache(shareCenterId, newUserGroupId);
                this.rebuildCardData(shareCenterId, newUserGroupId);
            }
        } else if (CTRL_USERGROUP.equals(propertyName)) {
            Object shareCenterId = this.getShareCenterId();
            Object newUserGroupId = this.getUserGroupId();
            this.pageCache(shareCenterId, newUserGroupId);
            this.rebuildCardData(shareCenterId, newUserGroupId);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getCallBackId().equals("exitCallback")) {
            this.getView().close();
        }
    }

    protected String getSetShareCenter(List<Long> sscIds, Boolean isSuperUser) {
        String param;
        String sscId = this.getView().getPageCache().get(CTRL_SHARECENTER);
        if (StringUtils.isNotBlank((Object)sscId)) {
            return sscId.toString();
        }
        Object customParam = this.getView().getFormShowParameter().getCustomParam(CTRL_SHARECENTER);
        if (customParam != null && StringUtils.isNotEmpty((CharSequence)(param = String.valueOf(customParam))) && (isSuperUser.booleanValue() || sscIds.contains(Long.parseLong(param)))) {
            return param;
        }
        if (isSuperUser.booleanValue()) {
            return TeamLeaderHelper.getTop1SscId() + "";
        }
        return String.valueOf(sscIds.get(0));
    }

    protected void setGroup(Object shareCenterId, Long userId, Boolean init) {
        QFilter qFilter = new QFilter("createorg", "=", (Object)Long.valueOf(shareCenterId.toString()));
        boolean isAdmin = TeamLeaderApi.isAdminRole(String.valueOf(shareCenterId), userId, "HXLFBW8ZGNH");
        if (!isAdmin) {
            qFilter.and("entryentity.userfield", "=", (Object)userId);
            if (TeamLeaderApi.isOpenTeamleader(String.valueOf(shareCenterId))) {
                qFilter.and("entryentity.teamleader", "=", (Object)Boolean.TRUE);
            }
        }
        DynamicObjectCollection groups = QueryServiceHelper.query((String)"task_usergroup", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
        ComboEdit combo = (ComboEdit)this.getControl(CTRL_USERGROUP);
        if (groups.isEmpty()) {
            if (isAdmin) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5171\u4eab\u4e2d\u5fc3\u672a\u914d\u7f6e\u4efb\u4f55\u7528\u6237\u7ec4\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u5b8c\u6210\u6570\u636e\u914d\u7f6e\u3002", (String)"AbstractFilterPlugin_5", (String)"ssc-task-mobile", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5171\u4eab\u4e2d\u5fc3\u4e0b\uff0c\u60a8\u6ca1\u6709\u4efb\u4f55\u7528\u6237\u7ec4\u7684\u6570\u636e\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u3002", (String)"AbstractFilterPlugin_6", (String)"ssc-task-mobile", (Object[])new Object[0]));
            }
            this.getModel().setValue(CTRL_USERGROUP, null);
            combo.setComboItems(null);
            return;
        }
        List<ComboItem> comboItems = AbstractFilterPlugin.revertComboItems(groups, isAdmin);
        combo.setComboItems(comboItems);
        this.getModel().setValue(CTRL_USERGROUP, (Object)this.getSetGroup(comboItems, init));
        this.getView().updateView(CTRL_USERGROUP);
    }

    protected String getSetGroup(List<ComboItem> list, Boolean init) {
        if (init.booleanValue()) {
            String usergroup = this.getView().getPageCache().get(CTRL_USERGROUP);
            if (usergroup != null) {
                return usergroup;
            }
            Object customParam = this.getView().getFormShowParameter().getCustomParam(CTRL_USERGROUP);
            if (customParam != null) {
                return customParam.toString();
            }
        }
        return list.get(0).getValue();
    }

    protected static List<ComboItem> revertComboItems(DynamicObjectCollection groups, boolean isAdmin) {
        List<ComboItem> collect = groups.stream().map(dynamicObject -> {
            ComboItem citem = new ComboItem();
            citem.setCaption(new LocaleString(dynamicObject.getString("name")));
            citem.setValue(dynamicObject.getString("id"));
            return citem;
        }).collect(Collectors.toList());
        if (isAdmin && collect.size() > 1) {
            collect.add(0, AbstractFilterPlugin.createComBoItem());
        }
        return collect;
    }

    protected static ComboItem createComBoItem() {
        ComboItem citem = new ComboItem();
        citem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8\u7528\u6237\u7ec4", (String)"AbstractFilterPlugin_7", (String)"ssc-task-mobile", (Object[])new Object[0])));
        citem.setValue("-1");
        return citem;
    }

    protected Object getShareCenterId() {
        Object value = this.getModel().getValue(CTRL_SHARECENTER);
        if (value != null) {
            return ((DynamicObject)value).get("id");
        }
        return null;
    }

    protected Object getUserGroupId() {
        return this.getModel().getValue(CTRL_USERGROUP);
    }

    protected Long getUserId() {
        return RequestContext.get().getCurrUserId();
    }

    protected void showMessage(String msg) {
        this.getView().showConfirm(msg, MessageBoxOptions.OK);
    }

    protected void showMessageAndExit(String msg) {
        this.getView().showConfirm(msg, MessageBoxOptions.OK, new ConfirmCallBackListener("exitCallback", (IFormPlugin)this));
    }

    protected void addCustomCards(String formIdsStr, Object sscId, Object usergroup) {
        Container cardcontainer = (Container)this.getView().getControl(CTRL_CARD_COMTAINER);
        if (StringUtils.isNotEmpty((CharSequence)formIdsStr)) {
            String[] formIds = formIdsStr.split(",");
            cardcontainer.deleteControls(formIds);
            if (usergroup == null) {
                return;
            }
            FlexPanelAp flex = new FlexPanelAp();
            flex.setGrow(0);
            flex.setShrink(0);
            flex.setRadius("8px");
            for (String formId : formIds) {
                flex.setKey(formId);
                ArrayList<Map> list = new ArrayList<Map>(1);
                list.add(flex.createControl());
                cardcontainer.addControls(list);
                this.addCard(formId, sscId, usergroup);
            }
        }
    }

    protected boolean addCard(String formId, Object sscId, Object usergroup) {
        try {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId(formId);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(formId);
            showParameter.setCustomParam(CTRL_SHARECENTER, sscId);
            showParameter.setCustomParam(CTRL_USERGROUP, usergroup);
            this.getView().showForm((FormShowParameter)showParameter);
            return true;
        }
        catch (KDException ignore) {
            logger.info("\u6dfb\u52a0\u5361\u7247\u53d1\u751f\u5f02\u5e38: %s", (Object)formId);
            return false;
        }
    }

    private void pageCache(Object sscId, Object usergroup) {
        this.getPageCache().put(CTRL_SHARECENTER, String.valueOf(sscId));
        this.getPageCache().put(CTRL_USERGROUP, String.valueOf(usergroup));
    }

    protected void buildCardData(Object sscId, Object usergroup) {
    }

    protected void rebuildCardData(Object sscId, Object usergroup) {
        this.getView().getFormShowParameter().setCustomParam(CTRL_SHARECENTER, sscId);
        this.getView().getFormShowParameter().setCustomParam(CTRL_USERGROUP, usergroup);
        this.getView().invokeOperation("refresh");
    }

    public void refresh() {
        String sscId = this.getPageCache().get(CTRL_SHARECENTER);
        String usergroup = this.getPageCache().get(CTRL_USERGROUP);
        this.rebuildCardData(sscId, usergroup);
    }

    protected void setRefreshSuccess() {
        ((MobileFormView)this.getView()).setRefreshResult(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f", (String)"AbstractFilterPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]), Integer.valueOf(200), RefreshResultType.Success);
    }
}

