/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.index;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplatePlugin;
import kd.ssc.task.mobile.template.datespan.DateRangePO;
import kd.ssc.task.mobile.template.datespan.DateSpanEnum;
import kd.ssc.task.mobile.utils.CastUtils;

public abstract class SscCardTemplateSingleDateSpanPlugin
extends SscCardTemplatePlugin {
    private static final String ACTIONID_DATERANGE = "ACTIONID_DATERANGE";
    private static final String CTRL_DATE_SPAN_PANEL = "date_span_panel";
    private static final String CTRL_DATE_SPAN_LABEL = "date_span_panel_label";
    private static final String CACHE_DateRangePO = "CACHE_DateRangePO";

    protected abstract void dateRangeChange(DateRangePO var1);

    protected void setShareValue(DateRangePO dateRange, String value) {
        if (DateSpanEnum.CURRENT_MONTH.getNumber().equals(dateRange.getSpanType())) {
            this.getPageCache().put("CACHE_SHARE_VALUE", value);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_DATE_SPAN_PANEL});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDateRangePanel();
    }

    protected void initDateRangePanel() {
        DateRangePO dateRangePO = this.getDateRange();
        Label dateSpanLabel = (Label)this.getView().getControl(CTRL_DATE_SPAN_LABEL);
        dateSpanLabel.setText(dateRangePO.getSpanTypeDesc());
    }

    protected DateRangePO getDefaultDateRangePO() {
        return new DateRangePO(DateSpanEnum.CURRENT_MONTH);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (CTRL_DATE_SPAN_PANEL.contains(key)) {
            this.showDateSpanSelectModalPage();
        }
    }

    protected void showDateSpanSelectModalPage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_datespan_select_m");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> custParam = new HashMap<String, String>();
        custParam.put("position", "bottom");
        parameter.getOpenStyle().setCustParam(custParam);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONID_DATERANGE));
        DateRangePO dateRange = this.getDateRange();
        parameter.setCustomParam("span_date_type", (Object)dateRange.getSpanType());
        parameter.setCustomParam("start_span_date", (Object)dateRange.getStartDateStr());
        parameter.setCustomParam("end_span_date", (Object)dateRange.getEndDateStr());
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (ACTIONID_DATERANGE.contains(actionId) && closedCallBackEvent.getReturnData() != null) {
            Label dateSpanLabel = (Label)this.getView().getControl(CTRL_DATE_SPAN_LABEL);
            Map returnDataMap = (Map)CastUtils.cast(closedCallBackEvent.getReturnData());
            DateRangePO dateRange = new DateRangePO((String)returnDataMap.get("dateSpanType"), (Date)returnDataMap.get("startTime"), (Date)returnDataMap.get("endTime"));
            this.cacheDateRangePO(SerializationUtils.toJsonString((Object)dateRange));
            this.dateRangeChange(dateRange);
            dateSpanLabel.setText(dateRange.getSpanTypeDesc());
        }
    }

    protected void cacheDateRangePO(String dateRangeStr) {
        this.getPageCache().put(CACHE_DateRangePO, dateRangeStr);
    }

    protected DateRangePO getDateRange() {
        String dateRangeJson = this.getPageCache().get(CACHE_DateRangePO);
        if (dateRangeJson == null) {
            dateRangeJson = (String)this.getView().getFormShowParameter().getCustomParam("dateRange");
            if (dateRangeJson == null) {
                return this.getDefaultDateRangePO();
            }
            this.cacheDateRangePO(dateRangeJson);
        }
        return (DateRangePO)SerializationUtils.fromJsonString((String)dateRangeJson, DateRangePO.class);
    }

    protected String getDateRangeStr() {
        String dateRangeJson = this.getPageCache().get(CACHE_DateRangePO);
        if (dateRangeJson == null) {
            return SerializationUtils.toJsonString((Object)this.getDefaultDateRangePO());
        }
        return dateRangeJson;
    }
}

