/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.ssc.task.mobile.common.UserParameterHelper;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.enums.ISubject;
import kd.ssc.task.mobile.enums.SubjectEnum;
import kd.ssc.task.mobile.formplugin.index.AbstractFilterPlugin;
import kd.ssc.task.mobile.formplugin.index.SscIndexSelectCardPlugin;

public class SscTaskIndexPlugin
extends AbstractFilterPlugin {
    public static final String FORMID = "ssc_index_m";
    private static final String CTRL_WORKLOADAP = "workloadap";
    private static final String CTRL_QUALITYAP = "qualityap";
    private static final String CTRL_AUTOMATIONAP = "automationap";
    private static final String CTRL_SERVICEAP = "serviceap";
    private static final String CTRL_EFFICIENCYAP = "efficiencyap";
    private static final String CTRL_MOREAP = "moreap";
    private static final String CTRL_BTN_CUSTOM_CARD = "btn_custom_card";
    private static final String CALLBACKID_CUSTOM_CARD = "actionid_custom_card";
    public static final String CACHE_CUSTOM_CARDS = "cache_custom_cards_formIds";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_WORKLOADAP, CTRL_QUALITYAP, CTRL_AUTOMATIONAP, CTRL_SERVICEAP, CTRL_EFFICIENCYAP, CTRL_MOREAP, CTRL_BTN_CUSTOM_CARD});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    protected void buildCardData(Object sscId, Object usergroup) {
        super.buildCardData(sscId, usergroup);
        String formIdsStr = this.getCustomCards();
        if (formIdsStr == null) {
            formIdsStr = "scc_taskpool_card_m,ssc_unqualified_card_m";
            UserParameterHelper.saveCustomCard(formIdsStr);
        }
        this.addCustomCards(formIdsStr, sscId, usergroup);
    }

    private String getCustomCards() {
        String cacheCards = this.getView().getPageCache().get(CACHE_CUSTOM_CARDS);
        if (cacheCards != null) {
            this.getView().getPageCache().remove(CACHE_CUSTOM_CARDS);
            return cacheCards;
        }
        return UserParameterHelper.getCustomCard();
    }

    @Override
    protected void addCustomCards(String formIdsStr, Object sscId, Object usergroup) {
        Container cardcontainer = (Container)this.getView().getControl("cardcontainer");
        Set<String> cardSet = this.getCardSet();
        String cacheIdnexCards = this.getView().getPageCache().get("CACHE_IDNEX_CARDS");
        if (cacheIdnexCards != null) {
            String[] cacheFormIds = cacheIdnexCards.split(",");
            cardSet.addAll(Arrays.asList(cacheFormIds));
        }
        cardcontainer.deleteControls(cardSet.toArray(new String[0]));
        if (usergroup == null) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)formIdsStr)) {
            String[] formIds = formIdsStr.split(",");
            LinkedHashSet<String> strings = new LinkedHashSet<String>(Arrays.asList(formIds));
            strings.remove("");
            StringJoiner stringJoiner = new StringJoiner(",");
            FlexPanelAp flex = new FlexPanelAp();
            flex.setGrow(0);
            flex.setShrink(0);
            flex.setRadius("8px");
            int i = 0;
            for (String formId : strings) {
                flex.setKey(formId);
                ArrayList<Map> list = new ArrayList<Map>(1);
                list.add(flex.createControl());
                cardcontainer.insertControls(++i, list);
                boolean addCard = this.addCard(formId, sscId, usergroup);
                if (!addCard) continue;
                stringJoiner.add(formId);
            }
            String addFormIdsStr = stringJoiner.toString();
            if (!StringUtils.equals((CharSequence)formIdsStr, (CharSequence)addFormIdsStr)) {
                UserParameterHelper.saveCustomCard(addFormIdsStr);
            }
            this.getView().getPageCache().put("CACHE_IDNEX_CARDS", formIdsStr);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "workloadap": {
                this.workloadap();
                break;
            }
            case "qualityap": {
                this.qualityap();
                break;
            }
            case "automationap": {
                this.automationap();
                break;
            }
            case "serviceap": {
                this.serviceap();
                break;
            }
            case "efficiencyap": {
                this.efficiencyap();
                break;
            }
            case "moreap": {
                this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"SscTaskIndexPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]));
                break;
            }
            case "btn_custom_card": {
                this.btnCustomCard();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null && CALLBACKID_CUSTOM_CARD.equals(actionId) && "refresh".equals(returnData)) {
            this.refresh();
        }
    }

    protected void efficiencyap() {
        this.jumpSubjectCardPage(SubjectEnum.EFFICIENCYAP);
    }

    protected void serviceap() {
        this.jumpSubjectCardPage(SubjectEnum.SERVICEAP);
    }

    protected void automationap() {
        this.jumpSubjectCardPage(SubjectEnum.AUTOMATIONAP);
    }

    protected void qualityap() {
        this.jumpSubjectCardPage(SubjectEnum.QUALITYAP);
    }

    protected void workloadap() {
        this.jumpSubjectCardPage(SubjectEnum.WORKLOADAP);
    }

    protected void btnCustomCard() {
        Object userGroupId = this.getUserGroupId();
        if (userGroupId == null || StringUtils.isEmpty((CharSequence)userGroupId.toString())) {
            this.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u7ec4", (String)"SscTaskIndexPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
            return;
        }
        SscIndexSelectCardPlugin.jumpMeBy((AbstractFormPlugin)this, CALLBACKID_CUSTOM_CARD);
    }

    protected void jumpSubjectCardPage(ISubject subject) {
        Object shareCenterId = this.getShareCenterId();
        Object userGroupId = this.getUserGroupId();
        if (userGroupId == null || StringUtils.isEmpty((CharSequence)userGroupId.toString())) {
            this.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7528\u6237\u7ec4", (String)"SscTaskIndexPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
            return;
        }
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_subject_card_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(subject.geCaption());
        parameter.setCustomParam("formIds", (Object)subject.getFormIds());
        parameter.setCustomParam("sharecenter", shareCenterId);
        parameter.setCustomParam("usergroup", userGroupId);
        parameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected Set<String> getCardSet() {
        return CardEnum.toSet();
    }

    public static void backToIndex(IFormView view, Object sharecenter, Object usergroup) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(FORMID);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("sharecenter", sharecenter);
        showParameter.setCustomParam("usergroup", usergroup);
        view.showForm((FormShowParameter)showParameter);
    }
}

