/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.index;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.ssc.task.mobile.common.TeamLeaderApi;

public class TeamLeaderHelper {
    private static String AlgoKey = TeamLeaderHelper.class.getName();

    public static QFilter getPermSscOrgsQFilters() {
        long userId = RequestContext.get().getCurrUserId();
        return TeamLeaderHelper.getPermSscOrgsQFilters(userId);
    }

    public static QFilter getPermSscOrgsQFilters(long userId) {
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            return new QFilter(OrgViewTypeEnum.IS_SCC.getFieldKey(), "=", (Object)"1");
        }
        List<Long> orgs = TeamLeaderHelper.getAllSscIds(userId, "ssc_index_m");
        return new QFilter("id", "in", orgs);
    }

    public static boolean checkPermShareCenter(Object shareCenterId) {
        Set<Long> orgs = TeamLeaderHelper.getPermSscOrgs();
        return orgs.contains(Long.valueOf(shareCenterId.toString()));
    }

    public static Set<Long> getPermSscOrgs() {
        long currUserId = RequestContext.get().getCurrUserId();
        return TeamLeaderHelper.getPermSscOrgs(currUserId);
    }

    public static Set<Long> getPermSscOrgs(long userId) {
        if (PermissionServiceHelper.isSuperUser((long)userId)) {
            return TeamLeaderHelper.getAllSscOrgIds();
        }
        List<Long> permOrgs = TeamLeaderHelper.getAllSscIds(userId, "ssc_index_m");
        return new HashSet<Long>(permOrgs);
    }

    public static List<Long> getAllSscIds(Long userid, String formId) {
        List<Long> sscIds = TeamLeaderHelper.getSscIds(userid, formId);
        sscIds.removeAll(TeamLeaderHelper.getNopermissionSscIdSet(sscIds));
        return sscIds;
    }

    public static List<Long> getSscIds(Long userid, String formId) {
        HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userid, (String)OrgViewTypeEnum.IS_SCC.getViewType(), (String)AppMetadataCache.getAppInfo((String)"ssc").getId(), (String)formId, (String)"47150e89000000ac");
        List longs = hasPermOrgs.getHasPermOrgs();
        return OrgUnitServiceHelper.filterOrgDuty((List)longs, (String)OrgViewTypeEnum.IS_SCC.getViewType());
    }

    public static Set<Long> getNopermissionSscIdSet(List<Long> sscIds) {
        long userId = RequestContext.get().getCurrUserId();
        Map<String, Boolean> paramsMaps = TeamLeaderApi.getParamBatch("usegrouptl", sscIds);
        Set<Long> openOrgIds = paramsMaps.entrySet().stream().filter(Map.Entry::getValue).map(entry -> Long.valueOf((String)entry.getKey())).collect(Collectors.toSet());
        if (openOrgIds.size() > 0) {
            TeamLeaderHelper.clearOpenOrgIds(userId, openOrgIds);
        }
        return openOrgIds;
    }

    public static void clearOpenOrgIds(Long userId, Set<Long> openOrgIds) {
        Set<Long> manageSsc;
        Map<Long, Set<String>> orgRolemap = TeamLeaderApi.getOrgRoleAssignMap(userId);
        if (orgRolemap.size() > 0) {
            Iterator<Long> iterator = openOrgIds.iterator();
            while (iterator.hasNext()) {
                Long orgid = iterator.next();
                Set<String> roles = orgRolemap.get(orgid);
                if (roles == null || !roles.contains("HXLFBW8ZGNH")) continue;
                iterator.remove();
            }
        }
        if (openOrgIds.size() > 0 && (manageSsc = TeamLeaderHelper.getManageSsc(userId)).size() > 0) {
            openOrgIds.removeAll(manageSsc);
        }
    }

    public static Set<Long> getManageSsc(Long userId) {
        HashSet<Long> manageSscSet = new HashSet<Long>(16);
        QFilter filter1 = new QFilter("entryentity.teamleader", "=", (Object)"1");
        QFilter filter2 = new QFilter("entryentity.userfield.id", "=", (Object)userId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"task_usergroup", (String)"id,entryentity.teamleader,entryentity.userfield.id,createorg.id", (QFilter[])new QFilter[]{filter1, filter2});
        for (DynamicObject usergroup : query) {
            manageSscSet.add(usergroup.getLong("createorg.id"));
        }
        return manageSscSet;
    }

    public static Long getTop1SscId() {
        QFilter qFilter = new QFilter(OrgViewTypeEnum.IS_SCC.getFieldKey(), "=", (Object)"1");
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)AlgoKey, (String)"bos_org", (String)"id", (QFilter[])qFilter.toArray(), (String)"number asc", (int)1);){
            Iterator iterator = dataSet.iterator();
            if (iterator.hasNext()) {
                Long l = ((Row)iterator.next()).getLong("id");
                return l;
            }
            Long l = null;
            return l;
        }
    }

    public static Set<Long> getAllSscOrgIds() {
        return new HashSet<Long>(OrgUnitServiceHelper.getAllOrg((String)"12"));
    }
}

