/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.intelligence;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.index.SscDateSpanCardTemplatePlugin;
import kd.ssc.task.mobile.formplugin.intelligence.SscIntelligenceAuditPercentDataHelper;
import kd.ssc.task.mobile.template.datespan.DateSpanPO;
import kd.ssc.task.mobile.utils.CommonUtils;

public class SscIntelligenceAuditDistributeFormPlugin
extends SscDateSpanCardTemplatePlugin
implements RowClickEventListener {
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entryentity = (CardEntry)this.getControl("entryentity");
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DateSpanPO dateSpanPO = null;
        String dateSpanStr = (String)this.getView().getFormShowParameter().getCustomParam("dateSpan");
        if (StringUtils.isNotBlank((CharSequence)dateSpanStr)) {
            dateSpanPO = (DateSpanPO)SerializationUtils.fromJsonString((String)dateSpanStr, DateSpanPO.class);
        }
        this.setDateSpanPO(dateSpanPO);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        LocalDate startTime = CommonUtils.date2LocalDate(dateSpanPO.getStartDateSpan());
        LocalDate endTime = CommonUtils.date2LocalDate(dateSpanPO.getEndDateSpan());
        DataSet allCompletedTaskDataSet = this.getAllCompletedTaskDataSet();
        DataSet completedTaskDataSetofDateSpan = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet, "completetime", startTime, endTime);
        this.initialPermPanel();
        this.initialTaskPanel(completedTaskDataSetofDateSpan);
        this.initialTaskListGroupedByBusinessBill(completedTaskDataSetofDateSpan);
    }

    private void initialTaskListGroupedByBusinessBill(DataSet allCompletedTaskDataSet) {
        Map<String, List<DynamicObject>> tasksMapByBillType = ORM.create().toPlainDynamicObjectCollection(allCompletedTaskDataSet.copy()).stream().collect(Collectors.groupingBy(dy -> dy.getString("billtype.id")));
        List<Map<String, Object>> listDataParameterMap = this.translateTasksToListDataParameters(tasksMapByBillType);
        this.fillDataIntoList(listDataParameterMap);
    }

    private List<Map<String, Object>> translateTasksToListDataParameters(Map<String, List<DynamicObject>> tasksMapByBillType) {
        ArrayList<Map<String, Object>> parameterList = new ArrayList<Map<String, Object>>(tasksMapByBillType.size());
        if (CollectionUtils.isEmpty(tasksMapByBillType)) {
            this.fillDataWhichIsZero(parameterList, tasksMapByBillType);
            return parameterList;
        }
        for (Map.Entry<String, List<DynamicObject>> entry : tasksMapByBillType.entrySet()) {
            List<DynamicObject> allTaskOfBillType = entry.getValue();
            long inteAuditCount = allTaskOfBillType.stream().filter(dy -> dy.getBoolean("autoprocess")).count();
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("bill_name", entry.getValue().get(0).getString("billtype.name"));
            parameterMap.put("inte_audit_percent_entry", new BigDecimal(inteAuditCount).multiply(new BigDecimal(100)).divide(new BigDecimal(allTaskOfBillType.size()), 1, 4));
            parameterMap.put("inteaudit_totaltask", inteAuditCount + "/" + allTaskOfBillType.size());
            parameterMap.put("billId", entry.getValue().get(0).getString("billtype.id"));
            parameterList.add(parameterMap);
        }
        this.fillDataWhichIsZero(parameterList, tasksMapByBillType);
        parameterList.sort((map1, map2) -> ((BigDecimal)map2.get("inte_audit_percent_entry")).compareTo((BigDecimal)map1.get("inte_audit_percent_entry")));
        return parameterList;
    }

    private void initialPermPanel() {
        Label sscLabel = (Label)this.getControl("label_ssc");
        sscLabel.setText(CommonQueryHelper.getNameById("bos_org", this.getSscId()));
        Label groupLabel = (Label)this.getControl("label_group");
        if (this.getGroupId() == -1L) {
            groupLabel.setText(ResManager.loadKDString((String)"\u5168\u90e8\u7528\u6237\u7ec4", (String)"SscIntelligenceAuditDistributeFormPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            groupLabel.setText(CommonQueryHelper.getNameById("task_usergroup", this.getGroupId()));
        }
    }

    private void initialTaskPanel(DataSet completedTaskDataSetofDateSpan) {
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        Label timeLabel = (Label)this.getControl("inte_audit_time");
        timeLabel.setText(dateSpanPO.getSpanTypeDesc());
        int inteAuditTaskCount = completedTaskDataSetofDateSpan.copy().filter("autoprocess = true").count("id", true);
        Label inteAuditTaskCountLabel = (Label)this.getControl("inte_audit_task_count");
        inteAuditTaskCountLabel.setText(String.valueOf(inteAuditTaskCount));
        int allTaskCount = completedTaskDataSetofDateSpan.copy().count("id", true);
        Label allTaskCountLabel = (Label)this.getControl("total_task_count");
        allTaskCountLabel.setText(String.valueOf(allTaskCount));
        BigDecimal currentPercent = allTaskCount == 0 ? new BigDecimal("0.0000") : new BigDecimal(inteAuditTaskCount).divide(new BigDecimal(allTaskCount), 10, 4);
        Label percentLabel = (Label)this.getControl("inte_audit_percent");
        percentLabel.setText(currentPercent.multiply(new BigDecimal(100)).setScale(1, 4) + "%");
    }

    private DataSet getAllCompletedTaskDataSet() {
        return QueryServiceHelper.queryDataSet((String)"MobileTaskBusinessDataHelper_average", (String)"task_taskhistory", (String)"id,pooltype,costwaittime,autoprocess,createTime,completetime,personid,billtype.id,billtype.name", (QFilter[])new QFilter[]{new QFilter("pooltype", "=", (Object)"2"), new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK), this.userFilter(this.getSscId(), this.getGroupId())}, null);
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("entryentity".equals(key)) {
            int currIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(currIndex);
            this.JumpToToDoTaskUserDetailPage(dynamicObject);
        }
    }

    private void JumpToToDoTaskUserDetailPage(DynamicObject currentClickDynamicObject) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_inteaudit_condition_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("sharecenter", (Object)this.getSscId().toString());
        parameter.setCustomParam("usergroup", (Object)this.getGroupId().toString());
        parameter.setCustomParam("billTypeId", (Object)currentClickDynamicObject.getString("billid"));
        parameter.setCustomParam("dateSpan", (Object)SerializationUtils.toJsonString((Object)this.getDateSpanPO()));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void fillDataWhichIsZero(List<Map<String, Object>> parameterList, Map<String, List<DynamicObject>> tasksMapByGroupId) {
        DynamicObjectCollection taskBills = QueryServiceHelper.query((String)"task_taskbill", (String)"id,number,name", (QFilter[])new QFilter("ssccenter", "=", (Object)this.getSscId()).toArray());
        Set<String> billIdsWhichNotEmpty = tasksMapByGroupId.keySet();
        List billIdsWhichIsEmpty = taskBills.stream().filter(dy -> !billIdsWhichNotEmpty.contains(dy.getString("id"))).collect(Collectors.toList());
        for (DynamicObject dynamicObject : billIdsWhichIsEmpty) {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("bill_name", dynamicObject.getString("name"));
            parameterMap.put("inte_audit_percent_entry", new BigDecimal(-1));
            parameterMap.put("inteaudit_totaltask", "0/0");
            parameterMap.put("billId", dynamicObject.getString("id"));
            parameterList.add(parameterMap);
        }
    }

    private void fillDataIntoList(List<Map<String, Object>> listDataParameterMap) {
        if (CollectionUtils.isEmpty(listDataParameterMap)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity"});
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        int size = listDataParameterMap.size();
        model.batchCreateNewEntryRow("entryentity", size);
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentity");
        DynamicProperty billName = dynamicObjects.getDynamicObjectType().getProperty("bill_name");
        DynamicProperty inteAuditPercentEntry = dynamicObjects.getDynamicObjectType().getProperty("inte_audit_percent_entry");
        DynamicProperty inteauditTotaltask = dynamicObjects.getDynamicObjectType().getProperty("inteaudit_totaltask");
        DynamicProperty billId = dynamicObjects.getDynamicObjectType().getProperty("billid");
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = listDataParameterMap.get(i);
            DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
            billName.setValueFast((Object)entry, map.get("bill_name"));
            inteAuditPercentEntry.setValueFast((Object)entry, (Object)(((BigDecimal)map.get("inte_audit_percent_entry")).compareTo(new BigDecimal(-1)) == 0 ? "-" : map.get("inte_audit_percent_entry") + "%"));
            inteauditTotaltask.setValueFast((Object)entry, map.get("inteaudit_totaltask"));
            billId.setValueFast((Object)entry, map.get("billId"));
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private Long getSscId() {
        long sscId = -1L;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("sharecenter")))) {
            sscId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        }
        return sscId;
    }

    private Long getGroupId() {
        return Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("usergroup"));
    }

    private QFilter userFilter(Long sscId, Long userGroupId) {
        QFilter userFilter = new QFilter("sscid", "=", (Object)sscId);
        if (userGroupId == null || userGroupId == -1L) {
            return userFilter;
        }
        return userFilter.and("usergroup.id", "=", (Object)userGroupId);
    }
}

