/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.intelligence;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.PageUtils;
import kd.ssc.task.mobile.formplugin.index.SscDateSpanCardTemplatePlugin;
import kd.ssc.task.mobile.formplugin.intelligence.SscIntelligenceAuditPercentDataHelper;
import kd.ssc.task.mobile.template.datespan.DateSpanEnum;
import kd.ssc.task.mobile.template.datespan.DateSpanPO;
import kd.ssc.task.mobile.template.datespan.DateSpanWrapper;
import kd.ssc.task.mobile.utils.CommonUtils;

public class SscIntelligenceAuditPercentCardFormPlugin
extends SscDateSpanCardTemplatePlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"imtate_label", "detail_label", "vector_of_cost", "vector_of_efficency", "vector_of_qualification", "vector_of_auto", "imtate_label"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initInteAuditData();
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"vector_of_cost")) {
            PageUtils.showTip(this.getView(), ResManager.loadKDString((String)"\u8282\u7701\u4eba\u529b(\u9884\u4f30)", (String)"SscIntelligenceAuditPercentCardFormPlugin_8", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ee5\u4eba\u5747\u6548\u80fd\u8ba1\u7b97\uff0c\u5f53\u524d\u667a\u80fd\u5ba1\u5355\u4efb\u52a1\u6539\u4e3a\u4eba\u5de5\u5ba1\u6838\u9700\u8981\u7684\u4eba\u5929\u3002", (String)"SscIntelligenceAuditPercentCardFormPlugin_9", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"vector_of_efficency")) {
            PageUtils.showTip(this.getView(), ResManager.loadKDString((String)"\u6548\u7387\u53d8\u5316(\u9884\u4f30)", (String)"SscIntelligenceAuditPercentCardFormPlugin_17", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u7684\u5e73\u5747\u5904\u7406\u65f6\u957f\uff0c\u4e0e\u4eba\u5de5\u5ba1\u6838\u7684\u5e73\u5747\u5904\u7406\u65f6\u957f\u7684\u6bd4\u8f83\u3002", (String)"SscIntelligenceAuditPercentCardFormPlugin_11", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"vector_of_qualification")) {
            PageUtils.showTip(this.getView(), ResManager.loadKDString((String)"\u8d28\u91cf\u53d8\u5316(\u9884\u4f30)", (String)"SscIntelligenceAuditPercentCardFormPlugin_18", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u7684\u8d28\u68c0\u4e0d\u5408\u683c\u7387\uff0c\u4e0e\u4eba\u5de5\u5ba1\u6838\u7684\u8d28\u68c0\u4e0d\u5408\u683c\u7387\u7684\u6bd4\u8f83\u3002", (String)"SscIntelligenceAuditPercentCardFormPlugin_13", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"vector_of_auto")) {
            PageUtils.showTip(this.getView(), ResManager.loadKDString((String)"\u667a\u80fd\u5ba1\u5355\u7387", (String)"SscIntelligenceAuditPercentCardFormPlugin_14", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u667a\u80fd\u673a\u5668\u4eba\u5ba1\u6838\u7684\u4efb\u52a1\u5360\u603b\u4efb\u52a1\u7684\u6bd4\u4f8b\u3002", (String)"SscIntelligenceAuditPercentCardFormPlugin_15", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"imtate_label")) {
            this.jumpToInteAuditImitatePage();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"detail_label")) {
            this.jumpToInteAuditDetailDistributePage();
        }
    }

    private void jumpToInteAuditImitatePage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_inteaudit_imitate_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("sharecenter", (Object)this.getSscid().toString());
        parameter.setCustomParam("usergroup", (Object)this.getUsergroup().toString());
        parameter.setCustomParam("dateSpan", (Object)SerializationUtils.toJsonString((Object)this.getDateSpanPO()));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void jumpToInteAuditDetailDistributePage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_inteaudit_distri_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("sharecenter", (Object)this.getSscid().toString());
        parameter.setCustomParam("usergroup", (Object)this.getUsergroup().toString());
        parameter.setCustomParam("dateSpan", (Object)SerializationUtils.toJsonString((Object)this.getDateSpanPO()));
        this.getView().showForm((FormShowParameter)parameter);
    }

    @Override
    protected void operationAfterSwitchDateSpan(DateSpanPO dateSpanPO) {
        super.operationAfterSwitchDateSpan(dateSpanPO);
        this.initInteAuditData();
    }

    private void initInteAuditData() {
        DataSet allCompletedTaskDataSet = this.getAllCompletedTaskDataSet();
        if (this.isEmptyTasks(allCompletedTaskDataSet)) {
            this.setNoDataView(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u672a\u53d1\u73b0\u5df2\u5904\u7406\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u5f00\u5c55\u5ba1\u6838\u5de5\u4f5c\u3002", (String)"SscIntelligenceAuditPercentCardFormPlugin_16", (String)"ssc-task-mobile", (Object[])new Object[0]));
            this.setPropDataTag(0);
            return;
        }
        this.setPropDataTag(1);
        this.fillInteAuditPercentPanel(allCompletedTaskDataSet);
        this.fillInteAuditEfficencyCompare(allCompletedTaskDataSet);
    }

    private void fillInteAuditEfficencyCompare(DataSet allCompletedTaskDataSet) {
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        DateSpanWrapper dateSpanWrapper = new DateSpanWrapper(dateSpanPO);
        LocalDate startTime = CommonUtils.date2LocalDate(dateSpanPO.getStartDateSpan());
        LocalDate endTime = CommonUtils.date2LocalDate(dateSpanPO.getEndDateSpan());
        LocalDate lastLinkStartTime = CommonUtils.date2LocalDate(dateSpanWrapper.getLinkStartDate());
        LocalDate lastLinkEndTime = CommonUtils.date2LocalDate(dateSpanWrapper.getLinkEndDate());
        int dateType = dateSpanWrapper.getDateType();
        if (dateType > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap111"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap11"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap112"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1111"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1121"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap11111"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap111"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap11"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap112"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1111"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1121"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap11111"});
        }
        int currentInteAuditTaskCount = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet.copy(), "completetime", startTime, endTime).filter("autoprocess = true").count("id", true);
        int lastInteAuditTaskCount = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet.copy(), "completetime", lastLinkStartTime, lastLinkEndTime).filter("autoprocess = true").count("id", true);
        BigDecimal earlierOfInteAuditPercent = SscIntelligenceAuditPercentDataHelper.compareRatio(new BigDecimal(currentInteAuditTaskCount), new BigDecimal(lastInteAuditTaskCount));
        Label costLabel = (Label)this.getControl("label_cost");
        costLabel.setText(String.valueOf(currentInteAuditTaskCount));
        SscIntelligenceAuditPercentDataHelper.setLabel(this.getView(), "month_ealier_cost", earlierOfInteAuditPercent, false);
        BigDecimal currentDecreaseTimeCostByDay = SscIntelligenceAuditPercentDataHelper.getDecreaseTimeCostByDay(allCompletedTaskDataSet.copy(), startTime, endTime);
        BigDecimal lastDecreaseTimeCostByDay = SscIntelligenceAuditPercentDataHelper.getDecreaseTimeCostByDay(allCompletedTaskDataSet.copy(), lastLinkStartTime, lastLinkEndTime);
        BigDecimal earlierOfDecreaseCostPercent = SscIntelligenceAuditPercentDataHelper.compareRatio(currentDecreaseTimeCostByDay, lastDecreaseTimeCostByDay);
        Label peopleLabel = (Label)this.getControl("label_people");
        peopleLabel.setText(currentDecreaseTimeCostByDay == null ? "-" : currentDecreaseTimeCostByDay.setScale(1, 4).toString());
        SscIntelligenceAuditPercentDataHelper.setLabel(this.getView(), "month_ealier_people", earlierOfDecreaseCostPercent, false);
        BigDecimal currentAuditTimeByHour = SscIntelligenceAuditPercentDataHelper.getAuditTimeByAuditType(allCompletedTaskDataSet.copy(), startTime, endTime, "0");
        BigDecimal lastAuditTimeByHour = SscIntelligenceAuditPercentDataHelper.getAuditTimeByAuditType(allCompletedTaskDataSet.copy(), lastLinkStartTime, lastLinkEndTime, "0");
        BigDecimal earlierOfAuditTimePercent = SscIntelligenceAuditPercentDataHelper.compareRatio(currentAuditTimeByHour, lastAuditTimeByHour);
        Label timeLabel = (Label)this.getControl("label_time");
        timeLabel.setText(currentAuditTimeByHour == null ? "-" : currentAuditTimeByHour.setScale(1, 4).toString());
        SscIntelligenceAuditPercentDataHelper.setLabel(this.getView(), "month_ealier_time", earlierOfAuditTimePercent, true);
        BigDecimal currentEfficency = null;
        BigDecimal lastEfficency = null;
        BigDecimal currentArtificialAuditTimeByHour = SscIntelligenceAuditPercentDataHelper.getAuditTimeByAuditType(allCompletedTaskDataSet.copy(), startTime, endTime, "2");
        currentEfficency = SscIntelligenceAuditPercentDataHelper.compareRatio(currentAuditTimeByHour, currentArtificialAuditTimeByHour);
        BigDecimal lastArtificialAuditTimeByHour = SscIntelligenceAuditPercentDataHelper.getAuditTimeByAuditType(allCompletedTaskDataSet.copy(), lastLinkStartTime, lastLinkEndTime, "2");
        lastEfficency = SscIntelligenceAuditPercentDataHelper.compareRatio(lastAuditTimeByHour, lastArtificialAuditTimeByHour);
        BigDecimal earlierOfEfficencyPercent = SscIntelligenceAuditPercentDataHelper.compareRatio(currentEfficency, lastEfficency);
        if (currentEfficency != null && currentEfficency.compareTo(BigDecimal.ZERO) > 0) {
            ((Label)this.getControl("label_efficency_change")).setText(ResManager.loadKDString((String)"\u6548\u7387\u4e0b\u964d(\u9884\u4f30)", (String)"SscIntelligenceAuditPercentCardFormPlugin_6", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else if (currentEfficency != null && currentEfficency.compareTo(BigDecimal.ZERO) <= 0) {
            ((Label)this.getControl("label_efficency_change")).setText(ResManager.loadKDString((String)"\u6548\u7387\u63d0\u5347(\u9884\u4f30)", (String)"SscIntelligenceAuditPercentCardFormPlugin_10", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
        Label efficencyLabel = (Label)this.getControl("label_eff");
        efficencyLabel.setText(currentEfficency == null ? "-" : currentEfficency.abs().multiply(new BigDecimal(100)).setScale(1, 4) + "%");
        SscIntelligenceAuditPercentDataHelper.setLabel(this.getView(), "month_ealier_eff", earlierOfEfficencyPercent, false);
        DataSet qualifiedDataSet = this.getQualifiedDataSet();
        DataSet currentQualifiedDataSet = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(qualifiedDataSet.copy(), "auditcompletetime", startTime, endTime);
        DataSet lastQualifiedDataSet = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(qualifiedDataSet.copy(), "auditcompletetime", lastLinkStartTime, lastLinkEndTime);
        Label qualperLabel = (Label)this.getControl("label_qualper");
        Label qualLabel = (Label)this.getControl("label_qual");
        if (currentQualifiedDataSet.copy().count("id", true) == 0) {
            qualperLabel.setText("-");
            SscIntelligenceAuditPercentDataHelper.setLabel(this.getView(), "month_ealier_qualper", null, true);
            qualLabel.setText("-");
            SscIntelligenceAuditPercentDataHelper.setLabel(this.getView(), "month_ealier_qual", null, false);
        } else {
            BigDecimal currentUnqualifiedPercent = SscIntelligenceAuditPercentDataHelper.getUnqualifiedPercent(currentQualifiedDataSet.copy(), "0");
            BigDecimal lastUnqualifiedPercent = SscIntelligenceAuditPercentDataHelper.getUnqualifiedPercent(lastQualifiedDataSet.copy(), "0");
            BigDecimal earlierOfUnqualifiedPercent = SscIntelligenceAuditPercentDataHelper.compareRatio(currentUnqualifiedPercent, lastUnqualifiedPercent);
            qualperLabel.setText(currentUnqualifiedPercent == null ? "-" : currentUnqualifiedPercent.multiply(new BigDecimal(100)).setScale(1, 4) + "%");
            SscIntelligenceAuditPercentDataHelper.setLabel(this.getView(), "month_ealier_qualper", earlierOfUnqualifiedPercent, true);
            BigDecimal currentUnAutoProcessUnqualifiedPercent = SscIntelligenceAuditPercentDataHelper.getUnqualifiedPercent(currentQualifiedDataSet.copy(), "2");
            BigDecimal lastUnAutoProcessUnqualifiedPercent = SscIntelligenceAuditPercentDataHelper.getUnqualifiedPercent(lastQualifiedDataSet.copy(), "2");
            BigDecimal currentQualifiedChangePercent = SscIntelligenceAuditPercentDataHelper.compareRatio(currentUnqualifiedPercent, currentUnAutoProcessUnqualifiedPercent);
            BigDecimal lastQualifiedChangePercent = SscIntelligenceAuditPercentDataHelper.compareRatio(lastUnqualifiedPercent, lastUnAutoProcessUnqualifiedPercent);
            BigDecimal earlierOfQualifiedChangePercent = SscIntelligenceAuditPercentDataHelper.compareRatio(currentQualifiedChangePercent, lastQualifiedChangePercent);
            if (currentQualifiedChangePercent != null && currentQualifiedChangePercent.compareTo(BigDecimal.ZERO) > 0) {
                ((Label)this.getControl("label_qualification")).setText(ResManager.loadKDString((String)"\u8d28\u91cf\u4e0b\u964d(\u9884\u4f30)", (String)"SscIntelligenceAuditPercentCardFormPlugin_19", (String)"ssc-task-mobile", (Object[])new Object[0]));
            } else if (currentQualifiedChangePercent != null && currentQualifiedChangePercent.compareTo(BigDecimal.ZERO) <= 0) {
                ((Label)this.getControl("label_qualification")).setText(ResManager.loadKDString((String)"\u8d28\u91cf\u63d0\u5347(\u9884\u4f30)", (String)"SscIntelligenceAuditPercentCardFormPlugin_12", (String)"ssc-task-mobile", (Object[])new Object[0]));
            }
            qualLabel.setText(currentQualifiedChangePercent == null ? "-" : currentQualifiedChangePercent.abs().multiply(new BigDecimal(100)).setScale(1, 4) + "%");
            SscIntelligenceAuditPercentDataHelper.setLabel(this.getView(), "month_ealier_qual", earlierOfQualifiedChangePercent, false);
        }
    }

    private void fillInteAuditPercentPanel(DataSet allCompletedTaskDataSet) {
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        DateSpanWrapper dateSpanWrapper = new DateSpanWrapper(dateSpanPO);
        LocalDate startTime = CommonUtils.date2LocalDate(dateSpanPO.getStartDateSpan());
        LocalDate endTime = CommonUtils.date2LocalDate(dateSpanPO.getEndDateSpan());
        LocalDate lastPreviousStartTime = CommonUtils.date2LocalDate(dateSpanWrapper.getPreviousStartDate());
        LocalDate lastPreviousEndTime = CommonUtils.date2LocalDate(dateSpanWrapper.getPreviousEndDate());
        LocalDate lastLinkStartTime = CommonUtils.date2LocalDate(dateSpanWrapper.getLinkStartDate());
        LocalDate lastLinkEndTime = CommonUtils.date2LocalDate(dateSpanWrapper.getLinkEndDate());
        int dateType = dateSpanWrapper.getDateType();
        switch (dateType) {
            case 1: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"year_ealier"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"labelap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap5"});
                break;
            }
            case 2: {
                this.getView().setVisible(Boolean.FALSE, new String[]{"year_ealier"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelap"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap5"});
                break;
            }
            default: {
                this.getView().setVisible(Boolean.FALSE, new String[]{"year_ealier"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"labelap"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
            }
        }
        BigDecimal currentPercent = SscIntelligenceAuditPercentDataHelper.getInteAuditPercentCount(allCompletedTaskDataSet.copy(), startTime, endTime);
        Label percentLabel = (Label)this.getControl("percent_label");
        assert (currentPercent != null);
        percentLabel.setText(currentPercent.setScale(1, 4) + "%");
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbar");
        progressBar.setPercent(currentPercent.intValue());
        if (DateSpanEnum.CURRENT_MONTH.getNumber().equals(this.getDateSpanPO().getDateSpanType()) && this.getPageCache().get("CACHE_SHARE_VALUE") == null) {
            this.getPageCache().put("CACHE_SHARE_VALUE", currentPercent.setScale(1, 4) + "%");
        }
        BigDecimal lastYearofMonthPercent = SscIntelligenceAuditPercentDataHelper.getInteAuditPercentCount(allCompletedTaskDataSet.copy(), lastPreviousStartTime, lastPreviousEndTime);
        BigDecimal yearEarlierOfMonthPercent = SscIntelligenceAuditPercentDataHelper.compareRatio(currentPercent, lastYearofMonthPercent);
        SscIntelligenceAuditPercentDataHelper.setLabel(this.getView(), "year_ealier", yearEarlierOfMonthPercent, false);
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
        BigDecimal lastMonthofMonthPercent = SscIntelligenceAuditPercentDataHelper.getInteAuditPercentCount(allCompletedTaskDataSet.copy(), lastLinkStartTime, lastLinkEndTime);
        BigDecimal monthEarlierOfMonthPercent = SscIntelligenceAuditPercentDataHelper.compareRatio(currentPercent, lastMonthofMonthPercent);
        SscIntelligenceAuditPercentDataHelper.setLabel(this.getView(), "month_ealier", monthEarlierOfMonthPercent, false);
        BigDecimal allTaskPercent = SscIntelligenceAuditPercentDataHelper.getInteAuditPercentCount(allCompletedTaskDataSet.copy(), null, null);
        BigDecimal averagePercent = SscIntelligenceAuditPercentDataHelper.compareRatio(currentPercent, allTaskPercent);
        SscIntelligenceAuditPercentDataHelper.setLabel(this.getView(), "average", averagePercent, false);
    }

    private DataSet getAllCompletedTaskDataSet() {
        return QueryServiceHelper.queryDataSet((String)"MobileTaskBusinessDataHelper_average", (String)"task_taskhistory", (String)"id,pooltype,costwaittime,autoprocess,createTime,completetime,personid", (QFilter[])new QFilter[]{new QFilter("pooltype", "=", (Object)"2"), new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK), this.userFilter(this.getSscid(), this.getUsergroup())}, null);
    }

    private DataSet getQualifiedDataSet() {
        String sql = "SELECT t1.FID as id,t1.FTASKCREATETIME as createTime,t1.fqualityresult as qualityresult,t2.fautoprocess as autoprocess,t2.fcompletetime as auditcompletetime FROM T_TK_TASKHISTORY t1, T_TK_TASKHISTORY t2 WHERE t1.FSOURCETASKID = t2.FID AND t1.FSSCID = ? AND t1.fqualitysamplelibraryid > 0";
        ArrayList<Long> params = new ArrayList<Long>();
        params.add(this.getSscid());
        if (this.getUsergroup() != -1L) {
            sql = sql + " AND t2.FUSERGROUP = ?";
            params.add(this.getUsergroup());
        }
        return DB.queryDataSet((String)"SscUnqualifiedDataHelper_cal", (DBRoute)DBRoute.of((String)"ssc"), (String)sql, (Object[])params.toArray());
    }

    private QFilter userFilter(Long sscId, Long userGroupId) {
        QFilter userFilter = new QFilter("sscid", "=", (Object)sscId);
        if (userGroupId == -1L) {
            return userFilter;
        }
        return userFilter.and("usergroup.id", "=", (Object)userGroupId);
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.InteAuditPercentCard.getCaption());
        String content = ResManager.loadKDString((String)"\u672c\u6708\u667a\u80fd\u5ba1\u5355\u7387\uff1a%s", (String)"SscIntelligenceAuditPercentCardFormPlugin_7", (String)"ssc-task-mobile", (Object[])new Object[0]);
        String shareValue = this.getPageCache().get("CACHE_SHARE_VALUE");
        String shareContent = String.format(content, StringUtils.isBlank((CharSequence)shareValue) ? "-" : shareValue);
        args.put("content", shareContent);
        args.put("cellContent", shareContent);
    }

    private boolean isEmptyTasks(DataSet allCompletedTaskDataSet) {
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        LocalDate startTime = CommonUtils.date2LocalDate(dateSpanPO.getStartDateSpan());
        LocalDate endTime = CommonUtils.date2LocalDate(dateSpanPO.getEndDateSpan());
        DataSet completedTaskDataSetofDateSpan = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet.copy(), "completetime", startTime, endTime);
        return completedTaskDataSetofDateSpan.count("id", true) == 0;
    }
}

