/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.intelligence;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.index.SscDateSpanCardTemplatePlugin;
import kd.ssc.task.mobile.formplugin.intelligence.SscIntelligenceAuditPercentDataHelper;
import kd.ssc.task.mobile.template.datespan.DateSpanPO;
import kd.ssc.task.mobile.utils.CommonUtils;

public class SscIntelligenceAuditPercentImitateFormPlugin
extends SscDateSpanCardTemplatePlugin {
    private static final Log log = LogFactory.getLog(SscIntelligenceAuditPercentImitateFormPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"vector_settting", "vector_resettting", "flexpanelap7611"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DateSpanPO dateSpanPO = null;
        String dateSpanStr = (String)this.getView().getFormShowParameter().getCustomParam("dateSpan");
        if (StringUtils.isNotBlank((CharSequence)dateSpanStr)) {
            dateSpanPO = (DateSpanPO)SerializationUtils.fromJsonString((String)dateSpanStr, DateSpanPO.class);
        }
        this.setDateSpanPO(dateSpanPO);
        Label dateSpanPanelLabel = (Label)this.getControl("date_span_panel_label");
        dateSpanPanelLabel.setText(dateSpanPO == null ? "" : dateSpanPO.getSpanTypeDesc());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isEmptyTasks()) {
            this.showEmptyDataPage(Boolean.TRUE);
            return;
        }
        this.showEmptyDataPage(Boolean.FALSE);
        this.initialPermPanel();
        this.initialInteAuditImitate();
        this.initialSuggestPanel();
    }

    @Override
    protected void operationAfterSwitchDateSpan(DateSpanPO dateSpanPO) {
        super.operationAfterSwitchDateSpan(dateSpanPO);
        if (this.isEmptyTasks()) {
            this.showEmptyDataPage(Boolean.TRUE);
            return;
        }
        this.showEmptyDataPage(Boolean.FALSE);
        this.initialInteAuditImitate();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("imitate_value_setting".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            String imitateValue = (String)closedCallBackEvent.getReturnData();
            this.getPageCache().put("imitate_value_" + this.getDateSpanPO().getDateSpanType(), imitateValue);
            if (!this.isEmptyTasks()) {
                this.initialInteAuditImitate();
            }
        }
    }

    private void initialPermPanel() {
        Label sscLabel = (Label)this.getControl("label_ssc");
        sscLabel.setText(CommonQueryHelper.getNameById("bos_org", this.getSscId()));
        Label groupLabel = (Label)this.getControl("label_group");
        if (this.getGroupId() == -1L) {
            groupLabel.setText(ResManager.loadKDString((String)"\u5168\u90e8\u7528\u6237\u7ec4", (String)"SscIntelligenceAuditPercentImitateFormPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            groupLabel.setText(CommonQueryHelper.getNameById("task_usergroup", this.getGroupId()));
        }
    }

    private void initialInteAuditImitate() {
        DataSet allCompletedTaskDataSet = this.getAllCompletedTaskDataSet();
        this.fillInteAuditPercentPanel(allCompletedTaskDataSet);
        this.initialInteAuditImitateCompareData(allCompletedTaskDataSet);
    }

    private void fillInteAuditPercentPanel(DataSet allCompletedTaskDataSet) {
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        LocalDate startTime = CommonUtils.date2LocalDate(dateSpanPO.getStartDateSpan());
        LocalDate endTime = CommonUtils.date2LocalDate(dateSpanPO.getEndDateSpan());
        String imitate_value = this.getView().getPageCache().get("imitate_value_" + dateSpanPO.getDateSpanType());
        BigDecimal inteAuditPercentCount = SscIntelligenceAuditPercentDataHelper.getInteAuditPercentCount(allCompletedTaskDataSet.copy(), startTime, endTime);
        if (inteAuditPercentCount == null) {
            return;
        }
        BigDecimal currentPercent = inteAuditPercentCount.setScale(2, 4);
        ProgressBar progress_current_percent = (ProgressBar)this.getControl("progress_current_percent");
        progress_current_percent.setPercent(currentPercent.intValue(), currentPercent.setScale(1, 4).toString() + "%");
        this.getPageCache().put("current_inte_audit_percent", currentPercent.toString());
        if (StringUtils.isNotBlank((CharSequence)imitate_value)) {
            ProgressBar progress_new_percent = (ProgressBar)this.getControl("progress_new_percent");
            progress_new_percent.setPercent(new BigDecimal(imitate_value).intValue(), new BigDecimal(imitate_value).setScale(1, 4).toString() + "%");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_setting"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel_new"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"suggestion_panel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tips_panel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_new"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel_setting"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"suggestion_panel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tips_panel"});
        }
    }

    private void initialInteAuditImitateCompareData(DataSet allCompletedTaskDataSet) {
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        LocalDate startTime = CommonUtils.date2LocalDate(dateSpanPO.getStartDateSpan());
        LocalDate endTime = CommonUtils.date2LocalDate(dateSpanPO.getEndDateSpan());
        String imitate_value = this.getView().getPageCache().get("imitate_value_" + dateSpanPO.getDateSpanType());
        int currentInteAuditTaskCount = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet.copy(), "completetime", startTime, endTime).filter("autoprocess = true").count("id", true);
        this.setFixedLabel("current_audit_count", "#276FF5", String.format(ResManager.loadKDString((String)"%s\u4e2a", (String)"SscIntelligenceAuditPercentImitateFormPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]), currentInteAuditTaskCount));
        BigDecimal earlierOfInteAuditTaskCount = BigDecimal.ZERO;
        int newInteAuditTaskCount = 0;
        if (StringUtils.isNotBlank((CharSequence)imitate_value)) {
            newInteAuditTaskCount = new BigDecimal(SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet.copy(), "completetime", startTime, endTime).count("id", true)).multiply(new BigDecimal(imitate_value)).divide(new BigDecimal(100), 0, 4).intValue();
            this.setFixedLabel("new_audit_count", "#1BA854", String.format(ResManager.loadKDString((String)"%s\u4e2a", (String)"SscIntelligenceAuditPercentImitateFormPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]), newInteAuditTaskCount));
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel_percent_1"});
            earlierOfInteAuditTaskCount = SscIntelligenceAuditPercentDataHelper.compareRatio(new BigDecimal(newInteAuditTaskCount), new BigDecimal(currentInteAuditTaskCount));
            SscIntelligenceAuditPercentDataHelper.setLabelNoColor(this.getView(), "percent_audit_count", earlierOfInteAuditTaskCount);
        } else {
            this.setFixedLabel("new_audit_count", "#1BA854", "--");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_percent_1"});
        }
        BigDecimal currentDecreaseTimeCost = SscIntelligenceAuditPercentDataHelper.getDecreaseTimeCostByDay(allCompletedTaskDataSet.copy(), startTime, endTime);
        this.setFixedLabel("current_decrease_cost", "#276FF5", currentDecreaseTimeCost == null ? "--" : String.format(ResManager.loadKDString((String)"%s\u4eba\u5929", (String)"SscIntelligenceAuditPercentImitateFormPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]), currentDecreaseTimeCost.setScale(1, 4)));
        if (StringUtils.isNotBlank((CharSequence)imitate_value)) {
            BigDecimal newDecreaseTimeCost;
            if (currentDecreaseTimeCost != null && earlierOfInteAuditTaskCount != null) {
                newDecreaseTimeCost = currentDecreaseTimeCost.add(currentDecreaseTimeCost.multiply(earlierOfInteAuditTaskCount));
                this.setFixedLabel("new_decrease_cost", "#1BA854", String.format(ResManager.loadKDString((String)"%s\u4eba\u5929", (String)"SscIntelligenceAuditPercentImitateFormPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]), newDecreaseTimeCost.setScale(1, 4)));
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel_percent_2"});
                BigDecimal earlierOfDecreaseCostPercent = SscIntelligenceAuditPercentDataHelper.compareRatio(newDecreaseTimeCost, currentDecreaseTimeCost);
                SscIntelligenceAuditPercentDataHelper.setLabelNoColor(this.getView(), "percent_decrease_cost", earlierOfDecreaseCostPercent);
            } else if (earlierOfInteAuditTaskCount == null) {
                newDecreaseTimeCost = this.getDecreaseTimeCostByInteAuditCount(newInteAuditTaskCount, allCompletedTaskDataSet.copy(), startTime, endTime);
                this.setFixedLabel("new_decrease_cost", "#1BA854", newDecreaseTimeCost == null ? "--" : String.format(ResManager.loadKDString((String)"%s\u4eba\u5929", (String)"SscIntelligenceAuditPercentImitateFormPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]), newDecreaseTimeCost.setScale(1, 4)));
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel_percent_2"});
                SscIntelligenceAuditPercentDataHelper.setLabelNoColor(this.getView(), "percent_decrease_cost", null);
            } else {
                this.setFixedLabel("new_decrease_cost", "#1BA854", "--");
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel_percent_2"});
                SscIntelligenceAuditPercentDataHelper.setLabelNoColor(this.getView(), "percent_decrease_cost", null);
            }
        } else {
            this.setFixedLabel("new_decrease_cost", "#1BA854", "--");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_percent_2"});
        }
        BigDecimal currentAuditTimeByHour = SscIntelligenceAuditPercentDataHelper.getAuditTimeByAuditType(allCompletedTaskDataSet.copy(), startTime, endTime, "0");
        this.setFixedLabel("current_audit_time", "#276FF5", currentAuditTimeByHour == null ? "--" : String.format(ResManager.loadKDString((String)"%s\u5c0f\u65f6/\u5355", (String)"SscIntelligenceAuditPercentImitateFormPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]), currentAuditTimeByHour.setScale(1, 4)));
        BigDecimal newAuditTimeByHour = BigDecimal.ZERO;
        if (StringUtils.isNotBlank((CharSequence)imitate_value)) {
            BigDecimal currentAuditTimeByHourOfArtificial = SscIntelligenceAuditPercentDataHelper.getAuditTimeByAuditType(allCompletedTaskDataSet.copy(), startTime, endTime, "2");
            BigDecimal currentAuditTimeByHourOfIntelligence = SscIntelligenceAuditPercentDataHelper.getAuditTimeByAuditType(allCompletedTaskDataSet.copy(), startTime, endTime, "1");
            int allAuditTaskCount = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet.copy(), "completetime", startTime, endTime).count("id", true);
            int newArtificialAuditTaskCount = allAuditTaskCount - newInteAuditTaskCount;
            if (allAuditTaskCount == 0) {
                newAuditTimeByHour = null;
            } else {
                BigDecimal currentArtificialAuditTimes = currentAuditTimeByHourOfArtificial == null ? BigDecimal.ZERO : currentAuditTimeByHourOfArtificial.multiply(new BigDecimal(newArtificialAuditTaskCount));
                BigDecimal currentIntelligenceAuditTimes = currentAuditTimeByHourOfIntelligence == null ? BigDecimal.ZERO : currentAuditTimeByHourOfIntelligence.multiply(new BigDecimal(newInteAuditTaskCount));
                newAuditTimeByHour = currentArtificialAuditTimes.add(currentIntelligenceAuditTimes).divide(new BigDecimal(allAuditTaskCount), 10, 4);
            }
            this.setFixedLabel("new_audit_time", "#1BA854", newAuditTimeByHour == null ? "--" : String.format(ResManager.loadKDString((String)"%s\u5c0f\u65f6/\u5355", (String)"SscIntelligenceAuditPercentImitateFormPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]), newAuditTimeByHour.setScale(1, 4)));
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel_percent_3"});
            BigDecimal earlierOfAuditTimePercent = SscIntelligenceAuditPercentDataHelper.compareRatio(newAuditTimeByHour, currentAuditTimeByHour);
            SscIntelligenceAuditPercentDataHelper.setLabelNoColor(this.getView(), "percent_audit_time", earlierOfAuditTimePercent);
        } else {
            this.setFixedLabel("new_audit_time", "#1BA854", "--");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_percent_3"});
        }
        BigDecimal currentInteAuditTimeByHour = SscIntelligenceAuditPercentDataHelper.getAuditTimeByAuditType(allCompletedTaskDataSet.copy(), startTime, endTime, "2");
        BigDecimal currentEfficency = SscIntelligenceAuditPercentDataHelper.compareRatio(currentAuditTimeByHour, currentInteAuditTimeByHour);
        if (currentEfficency != null && currentEfficency.compareTo(BigDecimal.ZERO) > 0) {
            this.setFixedLabel("label_efficency_change", "", ResManager.loadKDString((String)"\u6548\u7387\u4e0b\u964d(\u9884\u4f30)", (String)"SscIntelligenceAuditPercentImitateFormPlugin_4", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else if (currentEfficency != null && currentEfficency.compareTo(BigDecimal.ZERO) <= 0) {
            this.setFixedLabel("label_efficency_change", "", ResManager.loadKDString((String)"\u6548\u7387\u63d0\u5347(\u9884\u4f30)", (String)"SscIntelligenceAuditPercentImitateFormPlugin_5", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
        this.setFixedLabel("current_efficency_change", "#276FF5", currentEfficency == null ? "--" : currentEfficency.abs().multiply(new BigDecimal(100)).setScale(1, 4) + "%");
        if (StringUtils.isNotBlank((CharSequence)imitate_value)) {
            BigDecimal newEfficency = SscIntelligenceAuditPercentDataHelper.compareRatio(newAuditTimeByHour, currentInteAuditTimeByHour);
            this.setFixedLabel("new_efficency_change", "#1BA854", newEfficency == null ? "--" : newEfficency.abs().multiply(new BigDecimal(100)).setScale(1, 4) + "%");
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel_percent_4"});
            BigDecimal earlierOfEfficency = SscIntelligenceAuditPercentDataHelper.compareRatio(newEfficency, currentEfficency);
            SscIntelligenceAuditPercentDataHelper.setLabelNoColor(this.getView(), "percent_efficency_change", earlierOfEfficency);
        } else {
            this.setFixedLabel("new_efficency_change", "#1BA854", "--");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_percent_4"});
        }
        DataSet qualifiedDataSet = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(this.getQualifiedDataSet(), "auditcompletetime", startTime, endTime);
        BigDecimal currentUnqualifiedPercent = SscIntelligenceAuditPercentDataHelper.getUnqualifiedPercent(qualifiedDataSet.copy(), "0");
        this.setFixedLabel("current_unqulify", "#276FF5", currentUnqualifiedPercent == null ? "--" : currentUnqualifiedPercent.multiply(new BigDecimal(100)).setScale(1, 4) + "%");
        BigDecimal newUnQulifiedPercent = null;
        if (StringUtils.isNotBlank((CharSequence)imitate_value)) {
            BigDecimal currentIntelligenceCheckPercent = SscIntelligenceAuditPercentDataHelper.getCheckPercent(allCompletedTaskDataSet.copy(), qualifiedDataSet.copy(), startTime, endTime, "1");
            BigDecimal currentArtificialCheckPercent = SscIntelligenceAuditPercentDataHelper.getCheckPercent(allCompletedTaskDataSet.copy(), qualifiedDataSet.copy(), startTime, endTime, "2");
            BigDecimal currentInteUnqualifiedPercent = SscIntelligenceAuditPercentDataHelper.getUnqualifiedPercent(qualifiedDataSet.copy(), "1");
            BigDecimal currentArtiUnqualifiedPercent = SscIntelligenceAuditPercentDataHelper.getUnqualifiedPercent(qualifiedDataSet.copy(), "2");
            int allAuditTaskCount = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet.copy(), "completetime", startTime, endTime).count("id", true);
            int newArtificialAuditTaskCount = allAuditTaskCount - newInteAuditTaskCount;
            if (currentArtificialCheckPercent == null || currentArtiUnqualifiedPercent == null || currentIntelligenceCheckPercent == null || currentInteUnqualifiedPercent == null) {
                newUnQulifiedPercent = null;
                log.info("currentArtificialCheckPercent :" + currentArtificialCheckPercent + " -- currentArtiUnqualifiedPercent :" + currentArtiUnqualifiedPercent + " -- currentIntelligenceCheckPercent :" + currentIntelligenceCheckPercent + " -- currentInteUnqualifiedPercent :" + currentInteUnqualifiedPercent);
            } else {
                BigDecimal newUnQulifiedTaskCount = new BigDecimal(newArtificialAuditTaskCount).multiply(currentArtificialCheckPercent).multiply(currentArtiUnqualifiedPercent).add(new BigDecimal(newInteAuditTaskCount).multiply(currentIntelligenceCheckPercent).multiply(currentInteUnqualifiedPercent));
                BigDecimal newCheckTaskCount = new BigDecimal(newArtificialAuditTaskCount).multiply(currentArtificialCheckPercent).add(new BigDecimal(newInteAuditTaskCount).multiply(currentIntelligenceCheckPercent));
                log.info("newUnQulifiedTaskCount :" + newUnQulifiedTaskCount + " -- newCheckTaskCount :" + newCheckTaskCount);
                if (newCheckTaskCount.compareTo(BigDecimal.ZERO) != 0) {
                    newUnQulifiedPercent = newUnQulifiedTaskCount.divide(newCheckTaskCount, 10, 4);
                    log.info("normal.1 -- newUnQulifiedPercent :" + newUnQulifiedPercent);
                } else if (newUnQulifiedTaskCount.compareTo(BigDecimal.ZERO) == 0) {
                    newUnQulifiedPercent = BigDecimal.ZERO;
                    log.info("normal.2 -- newUnQulifiedPercent :" + newUnQulifiedPercent);
                }
            }
            log.info("normal.3 -- newUnQulifiedPercent :" + newUnQulifiedPercent);
            this.setFixedLabel("new_unqulify", "#1BA854", newUnQulifiedPercent == null ? "--" : newUnQulifiedPercent.multiply(new BigDecimal(100)).setScale(1, 4) + "%");
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel_percent_5"});
            BigDecimal earlierOfUnqualifiedPercent = SscIntelligenceAuditPercentDataHelper.compareRatio(newUnQulifiedPercent, currentUnqualifiedPercent);
            SscIntelligenceAuditPercentDataHelper.setLabelNoColor(this.getView(), "percent_unqulify", earlierOfUnqualifiedPercent);
        } else {
            this.setFixedLabel("new_unqulify", "#1BA854", "--");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_percent_5"});
        }
        BigDecimal currentUnAutoProcessUnqualifiedPercent = SscIntelligenceAuditPercentDataHelper.getUnqualifiedPercent(qualifiedDataSet.copy(), "2");
        BigDecimal currentQualifiedChangePercent = SscIntelligenceAuditPercentDataHelper.compareRatio(currentUnqualifiedPercent, currentUnAutoProcessUnqualifiedPercent);
        if (currentQualifiedChangePercent != null && currentQualifiedChangePercent.compareTo(BigDecimal.ZERO) > 0) {
            this.setFixedLabel("label_qualification", "", ResManager.loadKDString((String)"\u8d28\u91cf\u4e0b\u964d(\u9884\u4f30)", (String)"SscIntelligenceAuditPercentImitateFormPlugin_6", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else if (currentQualifiedChangePercent != null && currentQualifiedChangePercent.compareTo(BigDecimal.ZERO) <= 0) {
            this.setFixedLabel("label_qualification", "", ResManager.loadKDString((String)"\u8d28\u91cf\u63d0\u5347(\u9884\u4f30)", (String)"SscIntelligenceAuditPercentImitateFormPlugin_7", (String)"ssc-task-mobile", (Object[])new Object[0]));
        }
        this.setFixedLabel("current_qualification", "#276FF5", currentQualifiedChangePercent == null ? "--" : currentQualifiedChangePercent.abs().multiply(new BigDecimal(100)).setScale(1, 4) + "%");
        if (StringUtils.isNotBlank((CharSequence)imitate_value)) {
            BigDecimal newQualifiedChangePercent = SscIntelligenceAuditPercentDataHelper.compareRatio(newUnQulifiedPercent, currentUnAutoProcessUnqualifiedPercent);
            this.setFixedLabel("new_qualification", "#1BA854", newQualifiedChangePercent == null ? "--" : newQualifiedChangePercent.abs().multiply(new BigDecimal(100)).setScale(1, 4) + "%");
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanel_percent_6"});
            BigDecimal earlierOfQulification = SscIntelligenceAuditPercentDataHelper.compareRatio(newQualifiedChangePercent, currentQualifiedChangePercent);
            SscIntelligenceAuditPercentDataHelper.setLabelNoColor(this.getView(), "percent_qualification", earlierOfQulification);
        } else {
            this.setFixedLabel("new_qualification", "#1BA854", "--");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_percent_6"});
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"vector_settting") || StringUtils.equals((CharSequence)key, (CharSequence)"vector_resettting")) {
            this.openImitateSettingPage();
        } else if ("flexpanelap7611".equals(key)) {
            this.jumpToInteAuditDetailDistributePage();
        }
    }

    private void openImitateSettingPage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_imitatevalue_m");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> custParam = new HashMap<String, String>();
        custParam.put("position", "bottom");
        parameter.getOpenStyle().setCustParam(custParam);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "imitate_value_setting"));
        parameter.setCustomParam("current_inte_audit_percent", (Object)this.getPageCache().get("current_inte_audit_percent"));
        String currentImitateValue = this.getPageCache().get("imitate_value_" + this.getDateSpanPO().getDateSpanType());
        parameter.setCustomParam("imitate_inte_audit_percent", (Object)currentImitateValue);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setFixedLabel(String new_audit_count, String color, String text) {
        if (StringUtils.isNotEmpty((CharSequence)color)) {
            HashMap<String, String> ctrl = new HashMap<String, String>();
            ctrl.put("fc", color);
            this.getView().updateControlMetadata(new_audit_count, ctrl);
        }
        ((Label)this.getControl(new_audit_count)).setText(text);
    }

    private DataSet getAllCompletedTaskDataSet() {
        return QueryServiceHelper.queryDataSet((String)"MobileTaskBusinessDataHelper_average", (String)"task_taskhistory", (String)"id,pooltype,costwaittime,autoprocess,createTime,completetime,personid", (QFilter[])new QFilter[]{new QFilter("pooltype", "=", (Object)"2"), new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK), this.userFilter(this.getSscId(), this.getGroupId())}, null);
    }

    private void jumpToInteAuditDetailDistributePage() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_inteaudit_distri_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCustomParam("sharecenter", (Object)this.getSscId().toString());
        parameter.setCustomParam("usergroup", (Object)this.getGroupId().toString());
        parameter.setCustomParam("dateSpan", (Object)SerializationUtils.toJsonString((Object)this.getDateSpanPO()));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private QFilter userFilter(Long sscId, Long userGroupId) {
        QFilter userFilter = new QFilter("sscid", "=", (Object)sscId);
        if (userGroupId == null || userGroupId == -1L) {
            return userFilter;
        }
        return userFilter.and("usergroup.id", "=", (Object)userGroupId);
    }

    private Long getSscId() {
        long sscId = -1L;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("sharecenter")))) {
            sscId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        }
        return sscId;
    }

    private Long getGroupId() {
        return Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("usergroup"));
    }

    private DataSet getQualifiedDataSet() {
        String sql = "SELECT t1.FID as id,t1.FTASKCREATETIME as createTime,t1.fqualityresult as qualityresult,t2.fautoprocess as autoprocess,t2.fcompletetime as auditcompletetime FROM T_TK_TASKHISTORY t1, T_TK_TASKHISTORY t2 WHERE t1.FSOURCETASKID = t2.FID AND t1.FSSCID = ? AND t1.fqualitysamplelibraryid > 0";
        ArrayList<Long> params = new ArrayList<Long>();
        params.add(this.getSscId());
        if (this.getGroupId() != -1L) {
            sql = sql + " AND t2.FUSERGROUP = ?";
            params.add(this.getGroupId());
        }
        return DB.queryDataSet((String)"SscUnqualifiedDataHelper_cal", (DBRoute)DBRoute.of((String)"ssc"), (String)sql, (Object[])params.toArray());
    }

    private void initialSuggestPanel() {
        ((Label)this.getControl("label_audit_tip")).setText(ResManager.loadKDString((String)"\u63d0\u9ad8\u667a\u80fd\u5ba1\u5355\u7387\uff0c\u53ef\u80fd\u968f\u7740\u5355\u636e\u5185\u5bb9\u590d\u6742\u5ea6\u63d0\u9ad8\u800c\u5bfc\u81f4\u5ba1\u5355\u8d28\u91cf\u4e0b\u964d\uff0c\u5efa\u8bae\u4e1a\u52a1\u903b\u8f91\u8f83\u590d\u6742\u7684\u5355\u636e\u4fdd\u7559\u4eba\u5de5\u5ba1\u6838\uff0c\u540c\u65f6\u589e\u52a0\u667a\u80fd\u5ba1\u5355\u7684\u62bd\u68c0\u529b\u5ea6", (String)"SscIntelligenceAuditPercentImitateFormPlugin_8", (String)"ssc-task-mobile", (Object[])new Object[0]));
    }

    private boolean isEmptyTasks() {
        DataSet allCompletedTaskDataSet = this.getAllCompletedTaskDataSet();
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        LocalDate startTime = CommonUtils.date2LocalDate(dateSpanPO.getStartDateSpan());
        LocalDate endTime = CommonUtils.date2LocalDate(dateSpanPO.getEndDateSpan());
        DataSet completedTaskDataSetofDateSpan = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet.copy(), "completetime", startTime, endTime);
        return completedTaskDataSetofDateSpan.count("id", true) == 0;
    }

    private void showEmptyDataPage(Boolean isEmpty) {
        if (isEmpty.booleanValue()) {
            ((Label)this.getControl("defaultlabel")).setText(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u672a\u53d1\u73b0\u5df2\u5904\u7406\u4efb\u52a1\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u5f00\u5c55\u5ba1\u6838\u5de5\u4f5c\u3002", (String)"SscIntelligenceAuditPercentImitateFormPlugin_9", (String)"ssc-task-mobile", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap6"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"suggestion_panel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tips_panel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"defaultflex"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap6"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"defaultflex"});
        }
    }

    public BigDecimal getDecreaseTimeCostByInteAuditCount(int inteAuditTaskCount, DataSet allCompletedTaskDataSet, LocalDate startTime, LocalDate endTime) {
        BigDecimal decreaseTimeCostByDay = null;
        int personCount = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet.copy(), "completetime", startTime, endTime).filter("autoprocess = false").count("personid", true);
        DataSet dataSet = SscIntelligenceAuditPercentDataHelper.getcompletedTaskDataSetOfSpan(allCompletedTaskDataSet, "completetime", startTime, endTime).executeSql("select count(1) as taskcount,sum(costwaittime) as costwaittime where autoprocess = false");
        Iterator iterator = dataSet.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Integer taskcount = row.getInteger("taskcount");
            BigDecimal costwaittime = row.getBigDecimal("costwaittime");
            BigDecimal costWaittimeOfDay = costwaittime.multiply(new BigDecimal(personCount)).divide(new BigDecimal(8), 10, 4);
            if (costwaittime.compareTo(BigDecimal.ZERO) > 0 && taskcount != 0) {
                decreaseTimeCostByDay = new BigDecimal(inteAuditTaskCount).multiply(costWaittimeOfDay).divide(new BigDecimal(taskcount), 10, 4);
            }
        }
        dataSet.close();
        return decreaseTimeCostByDay;
    }
}

