/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.quality;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.orm.ORM;
import kd.ssc.task.mobile.formplugin.quality.SscUnqualifiedDataHelper;
import kd.ssc.task.mobile.formplugin.quality.dto.QualityPointCountResult;
import kd.ssc.task.mobile.formplugin.quality.dto.QualityPointCountResultData;
import kd.ssc.task.mobile.utils.CommonUtils;
import kd.ssc.task.mobile.utils.DataSetCloseHelper;

public class SscQualityProportionDataHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QualityPointCountResultData getData(Long sscid, Long usergroup, Date startDate, Date endDate) {
        QualityPointCountResultData data = new QualityPointCountResultData();
        ArrayList<QualityPointCountResult> results = new ArrayList<QualityPointCountResult>();
        try (DataSetCloseHelper closeHelper = DataSetCloseHelper.get();){
            DataSet dataSet = SscUnqualifiedDataHelper.getQualitysamplelibraryDataSet(sscid, usergroup, startDate, endDate);
            closeHelper.add(dataSet);
            int countQuality = dataSet.copy().count("id", false);
            data.setCountQuality(countQuality);
            if (countQuality == 0) {
                QualityPointCountResultData qualityPointCountResultData = data;
                return qualityPointCountResultData;
            }
            DataSet dsUnQualityTask = dataSet.filter("qualityresult = '0'");
            closeHelper.add(dsUnQualityTask);
            DataSet copyDateSet = dsUnQualityTask.copy();
            closeHelper.add(copyDateSet);
            int countUnQuality = copyDateSet.count("id", false);
            data.setCountUnQuality(countUnQuality);
            if (countUnQuality == 0) {
                QualityPointCountResultData qualityPointCountResultData = data;
                return qualityPointCountResultData;
            }
            DataSet dsAllMessageRecord = SscQualityProportionDataHelper.getAllMessageRecordDataSet();
            closeHelper.add(dsAllMessageRecord);
            DataSet dsAllCheckPoint = SscQualityProportionDataHelper.getAllCheckPointDataSet();
            closeHelper.add(dsAllCheckPoint);
            DataSet dsUnpassCheckingPoint = dsUnQualityTask.join(dsAllMessageRecord.filter("ischeckok = false"), JoinType.LEFT).on("id", "taskid").select(new String[]{"pointid", "taskid"}).finish().groupBy(new String[]{"pointid", "taskid"}).finish().groupBy(new String[]{"pointid"}).count("pointtimes").finish();
            closeHelper.add(dsUnpassCheckingPoint);
            DataSet dsReuslt = dsUnpassCheckingPoint.join(dsAllCheckPoint, JoinType.INNER).on("pointid", "id").select(new String[]{"pointid", "name as pointname", "pointtimes"}).finish().orderBy(new String[]{"pointtimes desc", "pointid asc"});
            closeHelper.add(dsReuslt);
            for (Row row : dsReuslt) {
                QualityPointCountResult result = new QualityPointCountResult();
                result.setPointid(row.getLong("pointid"));
                result.setPointname(row.getString("pointname"));
                result.setPointtimes(row.getInteger("pointtimes"));
                results.add(result);
            }
            data.setResults(results);
        }
        return data;
    }

    public static int calculateQualityPointCountResult(List<QualityPointCountResult> results) {
        int pointtimesAll = results.stream().mapToInt(QualityPointCountResult::getPointtimes).sum();
        for (QualityPointCountResult result : results) {
            result.setPercent(CommonUtils.divide(result.getPointtimes() * 100, pointtimesAll, 1));
        }
        return pointtimesAll;
    }

    public static DataSet getAllCheckPointDataSet() {
        ORM orm = ORM.create();
        String selectFields = "id,name,number";
        return orm.queryDataSet("kd.ssc.task.mobile.formplugin.quality.SscQualityProportionDataHelper", "task_checkingpoint", selectFields, null);
    }

    public static DataSet getAllMessageRecordDataSet() {
        ORM orm = ORM.create();
        String selectFields = "point as pointid,qualitycheck as taskid,ischeckok, reviewmethod, entryentity.messagetype as messagetype, entryentity.isnewmessage as isnewmessage";
        return orm.queryDataSet("kd.ssc.task.mobile.formplugin.quality.SscQualityProportionDataHelper", "task_qualitymessagerecord", selectFields, null);
    }
}

