/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.quality;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.PageUtils;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplateSingleDateSpanPlugin;
import kd.ssc.task.mobile.formplugin.quality.SscUnqualifiedDataHelper;
import kd.ssc.task.mobile.formplugin.quality.SscUnqualifiedDetailPlugin;
import kd.ssc.task.mobile.formplugin.quality.dto.DataResults;
import kd.ssc.task.mobile.formplugin.quality.dto.UnqualifiedCountResult;
import kd.ssc.task.mobile.template.datespan.DateRangePO;
import kd.ssc.task.mobile.template.datespan.DateSpanWrapper;

public class SscUnqualifiedCardPlugin
extends SscCardTemplateSingleDateSpanPlugin {
    private static final String CTRL_BTN_UNQUALIFIED_DETAIL = "btn_unqualified_detail";

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.UnqualifiedCard.getCaption());
        String shareContent = this.getShareContent(ResManager.loadKDString((String)"\u672c\u6708\u8d28\u68c0\u4e0d\u5408\u683c\u7387\uff1a%s", (String)"SscUnqualifiedCardPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672c\u6708\u672a\u53d1\u73b0\u5df2\u5b8c\u6210\u7684\u8d28\u68c0\u4efb\u52a1", (String)"SscUnqualifiedCardPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]));
        args.put("content", shareContent);
        args.put("cellContent", shareContent);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_BTN_UNQUALIFIED_DETAIL});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.dateRangeChange(this.getDateRange());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String optKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)CTRL_BTN_UNQUALIFIED_DETAIL, (CharSequence)optKey)) {
            this.btnDetail();
        }
    }

    private void btnDetail() {
        Long sscid = this.getSscid();
        Long usergroup = this.getUsergroup();
        SscUnqualifiedDetailPlugin.jumpMeBy(this.getView(), sscid.toString(), usergroup.toString(), this.getDateRangeStr());
    }

    @Override
    protected void dateRangeChange(DateRangePO dateRange) {
        Long usergroup;
        Long sscid = this.getSscid();
        DataResults results = SscUnqualifiedDataHelper.getData(sscid, usergroup = this.getUsergroup(), dateRange.getStartDate(), dateRange.getEndDate());
        BigDecimal ratio = results.getResultThis().unqualifiedRatio();
        if (this.notEmptypage(ratio)) {
            DateSpanWrapper wrapper = new DateSpanWrapper(dateRange.getStartDate(), dateRange.getEndDate());
            this.setPropDataTag(wrapper.getDateType() + 1);
            this.setPanelData(results);
            this.setShareValue(dateRange, results.getResultThis().unqualifiedRatiotextPercent());
        } else {
            this.setShareValue(dateRange, "");
        }
    }

    private boolean notEmptypage(BigDecimal ratio) {
        if (ratio == null) {
            this.setPropDataTag(0);
            this.setNoDataView(ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u5df2\u5b8c\u6210\u7684\u8d28\u68c0\u4efb\u52a1", (String)"SscUnqualifiedCardPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected void setNoDataView(String tip) {
        super.setNoDataView(tip);
    }

    private void setPanelData(DataResults results) {
        this.set_label_unqualified_percent(results.getResultThis());
        if (results.getResultLink() != null) {
            BigDecimal compareWithPreMonth = results.compareWithLink();
            PageUtils.setLabel(this.getView(), "label_rate_hb", compareWithPreMonth);
            BigDecimal compareWithAverage = results.compareWithAverage();
            PageUtils.setLabel(this.getView(), "label_rate_jz", compareWithAverage);
        }
        int progressRatio = results.thisProgressRatio();
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap_qualified");
        Label progressBarLabel = (Label)this.getView().getControl("labelapcompleterate");
        progressBar.setPercent(progressRatio);
        progressBarLabel.setText(progressRatio + "%");
    }

    private void set_label_unqualified_percent(UnqualifiedCountResult result) {
        String labelKey = "label_unqualified_percent";
        Label label = (Label)this.getView().getControl(labelKey);
        String ratiotextPercent = result.unqualifiedRatiotextPercent();
        label.setText(ratiotextPercent);
        String labelkey2 = "label_unqualified_count";
        Label label2 = (Label)this.getView().getControl(labelkey2);
        label2.setText(result.getUnqualifiedCount() + "");
    }
}

