/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.quality;

import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.ssc.task.mobile.formplugin.quality.SscQualityProportionDataHelper;
import kd.ssc.task.mobile.formplugin.quality.dto.DataResults;
import kd.ssc.task.mobile.formplugin.quality.dto.UnqualifiedCountResult;
import kd.ssc.task.mobile.template.datespan.DateSpanWrapper;
import kd.ssc.task.mobile.utils.CommonUtils;
import kd.ssc.task.mobile.utils.DataSetCloseHelper;
import kd.ssc.task.mobile.utils.DateSpanCommonUtils;
import kd.ssc.task.mobile.utils.SQLBuilder;

public final class SscUnqualifiedDataHelper {
    public static DataSet getQualitysamplelibraryDataSet(Long sscid, Long usergroup, Date startDate, Date endDate) {
        SQLBuilder builder = new SQLBuilder().append(" AND t1.FTASKCREATETIME >= ? ", startDate).append(" AND t1.FTASKCREATETIME < ? ", CommonUtils.nextDate(endDate));
        DataSet dataSet = usergroup == null || usergroup.equals(-1L) ? DB.queryDataSet((String)SscQualityProportionDataHelper.class.getName(), (DBRoute)DBRoute.of((String)"ssc"), (String)("SELECT t1.FID as id,t1.fqualityresult as qualityresult,t1.FTASKCREATETIME as taskcreatetime FROM T_TK_TASKHISTORY t1 WHERE  t1.FSSCID = ? AND t1.fqualitysamplelibraryid > 0 " + builder.getExpression()), (Object[])builder.toArray(sscid)) : DB.queryDataSet((String)SscQualityProportionDataHelper.class.getName(), (DBRoute)DBRoute.of((String)"ssc"), (String)("SELECT t1.FID as id,t1.fqualityresult as qualityresult,t1.FTASKCREATETIME as taskcreatetime FROM T_TK_TASKHISTORY t1, T_TK_TASKHISTORY t2 WHERE t1.FSOURCETASKID = t2.FID AND t1.FSSCID = ? AND t2.FUSERGROUP = ? AND t1.fqualitysamplelibraryid > 0 " + builder.getExpression()), (Object[])builder.toArray(sscid, usergroup));
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataResults getData(Long sscid, Long usergroup, Date startDate, Date endDate) {
        DataResults results = new DataResults();
        try (DataSetCloseHelper closeHelper = DataSetCloseHelper.get();){
            DateSpanWrapper wrapper = new DateSpanWrapper(startDate, endDate);
            DataSet dataSet = SscUnqualifiedDataHelper.getQualitysamplelibraryDataSet(sscid, usergroup, null, null);
            closeHelper.add(dataSet);
            UnqualifiedCountResult result1 = SscUnqualifiedDataHelper.selectUnqualifiedCountResult(dataSet.copy(), startDate, endDate);
            results.setResultThis(result1);
            if (wrapper.canCompareToAvg()) {
                UnqualifiedCountResult result2 = SscUnqualifiedDataHelper.selectUnqualifiedCountResult(dataSet.copy(), null, null);
                results.setResultAll(result2);
            }
            if (wrapper.canCompareToLink()) {
                UnqualifiedCountResult result3 = SscUnqualifiedDataHelper.selectUnqualifiedCountResult(dataSet, wrapper.getLinkStartDate(), wrapper.getLinkEndDate());
                results.setResultLink(result3);
            }
            int noCompleteCount = SscUnqualifiedDataHelper.calTaskTask(sscid, usergroup, startDate, endDate);
            results.getResultThis().setNoCompleteCount(noCompleteCount);
        }
        return results;
    }

    private static UnqualifiedCountResult selectUnqualifiedCountResult(DataSet dataSet, Date startDate, Date endDate) {
        try (DataSet ds = DateSpanCommonUtils.filterDataSet(dataSet, "taskcreatetime", startDate, endDate).groupBy().count("total").sum("(case when qualityresult='0' then 1 else 0 end)", "portion").finish();){
            UnqualifiedCountResult result = new UnqualifiedCountResult();
            if (ds.hasNext()) {
                Row row = ds.next();
                Integer portion = row.getInteger("portion");
                Integer total = row.getInteger("total");
                result.setUnqualifiedCount(portion);
                result.setCompleteCount(total);
            }
            UnqualifiedCountResult unqualifiedCountResult = result;
            return unqualifiedCountResult;
        }
    }

    private static int calTaskTask(Long sscid, Long usergroup, Date startDate, Date endDate) {
        SQLBuilder builder = new SQLBuilder().append(" AND t1.FTASKCREATETIME >= ? ", startDate).append(" AND t1.FTASKCREATETIME < ? ", CommonUtils.nextDate(endDate));
        Integer count = usergroup.equals(-1L) ? (Integer)DB.query((DBRoute)DBRoute.of((String)"ssc"), (String)("SELECT count(*) as c FROM T_TK_TASK t1 WHERE  t1.FSSCID = ? AND t1.fqualitysamplelibraryid > 0 " + builder.getExpression()), (Object[])builder.toArray(sscid), e -> {
            if (e.next()) {
                return e.getInt("c");
            }
            return 0;
        }) : (Integer)DB.query((DBRoute)DBRoute.of((String)"ssc"), (String)("SELECT count(*) as c FROM T_TK_TASK t1, T_TK_TASKHISTORY t2 WHERE  t1.FSOURCETASKID = t2.FID AND t1.FSSCID = ? AND t2.FUSERGROUP = ? AND t1.fqualitysamplelibraryid > 0 " + builder.getExpression()), (Object[])builder.toArray(sscid, usergroup), e -> {
            if (e.next()) {
                return e.getInt("c");
            }
            return 0;
        });
        return count;
    }
}

