/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.quality;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.ssc.task.mobile.common.UserParameterHelper;
import kd.ssc.task.mobile.common.chart.M;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplatePlugin;
import kd.ssc.task.mobile.formplugin.quality.SscUnqualifiedTrendDataHelper;
import kd.ssc.task.mobile.formplugin.quality.dto.UnqualifiedCountResult;
import kd.ssc.task.mobile.formplugin.warn.SscWarningValueRatioPlugin;
import kd.ssc.task.mobile.formplugin.warn.WarnValueModel;
import kd.ssc.task.mobile.formplugin.warn.WarnkeyModel;
import kd.ssc.task.mobile.utils.CastUtils;
import kd.ssc.task.mobile.utils.OperationLogUtil;

public class SscUnqualifiedTrendCardPlugin
extends SscCardTemplatePlugin {
    public static final String FORMID = "ssc_unqualified_trend_m";
    private static final String CTRL_BTN_UTREND_WARNVAL = "btn_utrend_warnval";
    private static final String CTRL_POINTLINECHARTAP_UTREND = "pointlinechartap_utrend";
    private static final String CTRL_LABELAPTIP_UT = "labelaptiput";
    private static final String ACTIONID_WARNING_VALUE = "ACTIONID_WARNING_VALUE";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CTRL_BTN_UTREND_WARNVAL});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showChart();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String optKey = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)CTRL_BTN_UTREND_WARNVAL, (CharSequence)optKey)) {
            this.btnSetWarningValue();
        }
    }

    private void btnSetWarningValue() {
        String warnningValue = UserParameterHelper.getWarnningValue(this.getWarningKey().textkey());
        WarnValueModel warningValue = WarnValueModel.parse(warnningValue);
        SscWarningValueRatioPlugin.jumpMeBy((AbstractFormPlugin)this, ACTIONID_WARNING_VALUE, warningValue.getWarningValue(), warningValue.getWarningNotice());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (ACTIONID_WARNING_VALUE.equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            Map returnDataMap = (Map)CastUtils.cast(closedCallBackEvent.getReturnData());
            String warnningValue = UserParameterHelper.getWarnningValue(this.getWarningKey().textkey());
            WarnValueModel valueModel = WarnValueModel.parse(warnningValue);
            valueModel.setWarningValue((String)returnDataMap.get("key_warning_value"));
            valueModel.setWarningNotice((String)returnDataMap.get("key_warning_notice"));
            long value = Long.parseLong(valueModel.getWarningValue());
            if (value >= 0L && value <= 100L) {
                UserParameterHelper.saveWarningValue(this.getWarningKey().textkey(), valueModel.textValue());
                OperationLogUtil.log(ResManager.loadKDString((String)"\u8bbe\u7f6e\u4e0d\u5408\u683c\u7387\u9884\u8b66\u503c", (String)"SscUnqualifiedTrendCardPlugin_8", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bbe\u7f6e\u4e0d\u5408\u683c\u7387\u9884\u8b66\u503c\u6210\u529f\u3002", (String)"SscUnqualifiedTrendCardPlugin_9", (String)"ssc-task-mobile", (Object[])new Object[0]), FORMID);
                this.refreshAfterResetWarningValue();
            }
        }
    }

    private void refreshAfterResetWarningValue() {
        IFormView view = this.getView();
        view.invokeOperation("refresh");
        this.getView().sendFormAction(view);
    }

    private void showChart() {
        Long sscid = this.getSscid();
        Long usergroup = this.getUsergroup();
        LocalDate startDate = LocalDate.now().minusMonths(5L).with(TemporalAdjusters.firstDayOfMonth());
        List<UnqualifiedCountResult> results = SscUnqualifiedTrendDataHelper.getData(sscid, usergroup, startDate);
        UnqualifiedCountResult result = results.get(5);
        this.getPageCache().put("CACHE_SHARE_VALUE", result.unqualifiedRatiotextPercent());
        this.setPanelData(results);
    }

    private void setPanelData(List<UnqualifiedCountResult> results) {
        PointLineChart chart = this.initPointLineChart();
        SscUnqualifiedTrendCardPlugin.setXAxis(chart, results);
        Integer warningV = this.getWarningValue();
        BigDecimal fixMaxValue = this.getFixMaxValue(results, warningV);
        this.setYAxis(chart, fixMaxValue);
        chart.addFuncPath(M.arraylist("yAxis", 0, "axisLabel", "formatter"));
        LineSeries series = this.createSeries(chart, warningV);
        if (warningV != null && warningV > 0) {
            LineSeries warningLineSeries = chart.createLineSeries("line");
            warningLineSeries.setPropValue("symbol", (Object)"none");
            warningLineSeries.setLineColor("rgba(255,255,255,0)");
            warningLineSeries.setPropValue("data", M.arraylist(warningV));
        }
        List list = results.stream().map(result -> {
            BigDecimal bigDecimal = result.unqualifiedRatio();
            if (bigDecimal != null) {
                return bigDecimal.multiply(new BigDecimal("100").setScale(1, 4));
            }
            return null;
        }).collect(Collectors.toList());
        series.setPropValue("data", list);
        this.setTipPanel(results);
        this.getView().updateView();
    }

    private void setTipPanel(List<UnqualifiedCountResult> results) {
        List emptyList = results.stream().filter(result -> result.unqualifiedRatio() == null).collect(Collectors.toList());
        if (emptyList.size() == 0) {
            this.setPropDataTag(results.size());
        } else if (emptyList.size() == results.size()) {
            this.setPropDataTag(0);
            this.setNoDataView(ResManager.loadKDString((String)"\u8fc7\u53bb6\u4e2a\u6708\u672a\u53d1\u73b0\u5df2\u5b8c\u6210\u7684\u8d28\u68c0\u4efb\u52a1", (String)"SscUnqualifiedTrendCardPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            this.setPropDataTag(results.size() - emptyList.size());
            String xnamejoining = emptyList.stream().map(UnqualifiedCountResult::getXnames).collect(Collectors.joining("\u3001"));
            Label label_tip = (Label)this.getControl(CTRL_LABELAPTIP_UT);
            label_tip.setText(String.format(ResManager.loadKDString((String)"%s\u672a\u53d1\u73b0\u5df2\u5b8c\u6210\u7684\u8d28\u68c0\u4efb\u52a1\u3002", (String)"SscUnqualifiedTrendCardPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]), xnamejoining));
        }
    }

    private static void setXAxis(PointLineChart chart, List<UnqualifiedCountResult> results) {
        Axis xAxis = chart.createXAxis("", AxisType.category);
        xAxis.setPropValue("boundaryGap", (Object)Boolean.FALSE);
        xAxis.setPropValue("axisLine", (Object)M.map().kv("lineStyle", map -> map.kv("color", "#E5E5E5").kv("width", 1)));
        xAxis.setPropValue("axisLabel", (Object)M.map().kv("color", "#999").kv("fontSize", 12));
        List collect = results.stream().map(result -> M.map().kv("value", result.getXnames()).kv("textStyle", M.map("fontSize", 12))).collect(Collectors.toList());
        xAxis.setPropValue("data", collect);
    }

    protected BigDecimal getFixMaxValue(List<UnqualifiedCountResult> items, Integer warningV) {
        double maxV = items.stream().mapToDouble(value -> {
            BigDecimal bigDecimal = value.unqualifiedRatio();
            if (bigDecimal != null) {
                return bigDecimal.multiply(new BigDecimal("100").setScale(1, 4)).doubleValue();
            }
            return 0.0;
        }).max().orElse(100.0);
        if ((maxV = Math.max(maxV, warningV == null ? 0.0 : warningV.doubleValue())) <= 0.4) {
            return new BigDecimal("0.4");
        }
        return null;
    }

    private void setYAxis(PointLineChart chart, BigDecimal fixMaxValue) {
        Axis yAxis = chart.createYAxis(ResManager.loadKDString((String)"\u8d28\u68c0\u4e0d\u5408\u683c\u7387(%)", (String)"SscUnqualifiedTrendCardPlugin_4", (String)"ssc-task-mobile", (Object[])new Object[0]), AxisType.value);
        if (fixMaxValue != null) {
            yAxis.setPropValue("max", (Object)fixMaxValue);
            yAxis.setPropValue("interval", (Object)fixMaxValue.divide(new BigDecimal(4), 1, 4));
        }
        yAxis.setPropValue("nameLocation", (Object)"end");
        yAxis.setPropValue("nameTextStyle", (Object)M.map().kv("color", "#999").kv("fontSize", 12).kv("align", "left").list("padding", 0, 0, 0, -10));
        yAxis.setPropValue("axisLine", M.map("show", Boolean.FALSE));
        yAxis.setPropValue("type", (Object)"value");
        yAxis.setPropValue("axisLabel", (Object)M.map().kv("color", "#999").kv("fontSize", 12));
        yAxis.setPropValue("splitLine", (Object)M.map().kv("lineStyle", map -> map.kv("type", "dashed").kv("color", "#e5e5e5")));
        yAxis.setPropValue("axisTick", M.map("show", Boolean.FALSE));
    }

    private LineSeries createSeries(PointLineChart chart, Integer warningV) {
        LineSeries series = chart.createLineSeries(ResManager.loadKDString((String)"\u4e0d\u5408\u683c\u7387", (String)"SscUnqualifiedTrendCardPlugin_5", (String)"ssc-task-mobile", (Object[])new Object[0]));
        series.setPropValue("symbolSize", (Object)6);
        series.setPropValue("lineStyle", (Object)M.map().kv("normal", map -> map.kv("width", 1).kv("color", "#276FF5")));
        series.setPropValue("itemStyle", (Object)M.map().kv("normal", map -> map.kv("color", "rgba(10,154,255,1)")));
        series.setPropValue("label", (Object)M.map().kv("normal", map -> map.kv("show", Boolean.FALSE).kv("position", "top").kv("fontSize", 12).kv("distance", 20).kv("fontWeight", "12").kv("color", "rgba(10,154,255,1)")));
        if (warningV != null && warningV > 0) {
            String text = warningV + "%";
            series.setPropValue("markLine", (Object)M.map().kv("lineStyle", map -> map.kv("normal", map1 -> map1.kv("type", "dashed").kv("color", "rgba(255,153,28,1)"))).kv("label", map -> map.kv("normal", map1 -> map1.kv("position", "end").kv("formatter", text))).list("data", M.map().kv("yAxis", warningV).kv("symbol", "none")).kv("silent", "true"));
            series.addFuncPath(M.arraylist("markLine", "label", "normal", "formatter"));
        } else {
            series.setPropValue("markLine", null);
        }
        return series;
    }

    private Integer getWarningValue() {
        String text = UserParameterHelper.getWarnningValue(this.getWarningKey().textkey());
        WarnValueModel valueModel = WarnValueModel.parse(text);
        String warningValue = valueModel.getWarningValue();
        return StringUtils.isBlank((CharSequence)warningValue) ? null : Integer.valueOf(Integer.parseInt(warningValue));
    }

    private PointLineChart initPointLineChart() {
        PointLineChart chart = (PointLineChart)this.getControl(CTRL_POINTLINECHARTAP_UTREND);
        chart.clearData();
        chart.setShowTooltip(true);
        chart.addTooltip("trigger", (Object)"axis");
        chart.addTooltip("formatter", (Object)"function(item) {if(item[0].value===undefined){return '-'}else{ return item[0].value.toFixed(1)+'%';} }");
        chart.addFuncPath(M.arraylist("tooltip", "formatter"));
        chart.setShowLegend(false);
        chart.setLegendPropValue("selectedMode", (Object)Boolean.FALSE);
        chart.setMargin(Position.left, "5%");
        chart.setMargin(Position.top, "12%");
        chart.setMargin(Position.right, "12%");
        chart.setMargin(Position.bottom, "5%");
        return chart;
    }

    private WarnkeyModel getWarningKey() {
        return new WarnkeyModel(FORMID, this.getSscid(), this.getUsergroup());
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.UnqualifiedTrendCard.getCaption());
        String content = this.getShareContent(ResManager.loadKDString((String)"\u672c\u6708\u4e0d\u5408\u683c\u7387\uff1a%s", (String)"SscUnqualifiedTrendCardPlugin_7", (String)"ssc-task-mobile", (Object[])new Object[0]));
        args.put("content", content);
        args.put("cellContent", content);
    }

    @Override
    protected void onlyRead() {
        super.onlyRead();
        this.getView().setVisible(Boolean.FALSE, new String[]{CTRL_BTN_UTREND_WARNVAL});
    }
}

