/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.quality;

import java.time.LocalDate;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.lang.Lang;
import kd.ssc.task.mobile.formplugin.quality.dto.UnqualifiedCountResult;
import kd.ssc.task.mobile.utils.CommonUtils;
import kd.ssc.task.mobile.utils.DataSetCloseHelper;

public class SscUnqualifiedTrendDataHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<UnqualifiedCountResult> getData(Long sscid, Long usergroup, LocalDate startDate) {
        ArrayList<UnqualifiedCountResult> results = new ArrayList<UnqualifiedCountResult>();
        try (DataSetCloseHelper closeHelper = DataSetCloseHelper.get();){
            DataSet dsHistory = usergroup == null || usergroup.equals(-1L) ? DB.queryDataSet((String)"SscUnqualifiedDataHelper_cal", (DBRoute)DBRoute.of((String)"ssc"), (String)"SELECT t1.FTASKCREATETIME as createTime,t1.FID as id,t1.fqualityresult as qualityresult FROM T_TK_TASKHISTORY t1 WHERE  t1.FSSCID = ? AND t1.fqualitysamplelibraryid > 0 AND t1.FTASKCREATETIME >= ? ", (Object[])new Object[]{sscid, startDate}) : DB.queryDataSet((String)"SscUnqualifiedDataHelper_cal", (DBRoute)DBRoute.of((String)"ssc"), (String)"SELECT t1.FTASKCREATETIME as createTime,t1.FID as id,t1.fqualityresult as qualityresult FROM T_TK_TASKHISTORY t1, T_TK_TASKHISTORY t2 WHERE t1.FSOURCETASKID = t2.FID AND t1.FSSCID = ? AND t2.FUSERGROUP = ? AND t1.fqualitysamplelibraryid > 0 AND t1.FTASKCREATETIME >= ? ", (Object[])new Object[]{sscid, usergroup, startDate});
            closeHelper.add(dsHistory);
            LocalDate now = LocalDate.now().plusDays(1L);
            while (startDate.isBefore(now)) {
                UnqualifiedCountResult result = new UnqualifiedCountResult();
                DataSet ds0 = dsHistory.copy().filter("createTime >= startDate AND createTime < endDate", SscUnqualifiedTrendDataHelper.createCreateTimeParams(startDate, startDate.plusMonths(1L)));
                DataSet dsUnqualified = ds0.copy().filter("qualityresult='0'");
                int unqualifiedCount = dsUnqualified.count("id", false);
                result.setUnqualifiedCount(unqualifiedCount);
                int completeCount = ds0.count("id", false);
                result.setCompleteCount(completeCount);
                String xnames = startDate.getMonth().getDisplayName(TextStyle.SHORT, Lang.get().getLocale());
                result.setXnames(xnames);
                results.add(result);
                startDate = startDate.plusMonths(1L);
            }
        }
        return results;
    }

    private static Map<String, Object> createCreateTimeParams(LocalDate startDate, LocalDate endDate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startDate", CommonUtils.localDate2Date(startDate));
        map.put("endDate", CommonUtils.localDate2Date(endDate.plusDays(1L)));
        return map;
    }
}

