/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.serviceap;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.PageUtils;
import kd.ssc.task.mobile.formplugin.index.SscCardTemplateSingleDateSpanPlugin;
import kd.ssc.task.mobile.template.AbstractDataProcess;
import kd.ssc.task.mobile.template.DynamicTabTemplatePlugin;
import kd.ssc.task.mobile.template.data.BasicDataModel;
import kd.ssc.task.mobile.template.data.TransferData;
import kd.ssc.task.mobile.template.datespan.DateRangePO;
import kd.ssc.task.mobile.template.datespan.DateSpanWrapper;
import kd.ssc.task.mobile.template.enums.BaseDataEnum;

public abstract class AbstractAnalyseCardPlugin
extends SscCardTemplateSingleDateSpanPlugin {
    protected static final String BTN_DETAIL_KEY = "button_detail";

    public abstract CardEnum getCard();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_DETAIL_KEY, "vectorap"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)BTN_DETAIL_KEY, (CharSequence)key)) {
            this.btnAnalyse();
        } else if (StringUtils.equals((CharSequence)"vectorap", (CharSequence)key)) {
            PageUtils.showTip(this.getView(), this.getTipsTitle(), this.getTipsContent());
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.dateRangeChange(this.getDateRange());
    }

    protected void btnAnalyse() {
        CardEnum card = this.getCard();
        AbstractDataProcess builder = card.getDataProcess();
        TransferData transferData = builder.build(this.getSscid(), this.getUsergroup(), this.getDateRange());
        transferData.getGroupbys().add(BaseDataEnum.ORGID.getCode());
        DynamicTabTemplatePlugin.jumpMeBy(this.getView(), card.getCaption(), transferData);
    }

    @Override
    protected void dateRangeChange(DateRangePO dateRange) {
        Long sscId = this.getSscid();
        Long userGroup = this.getUsergroup();
        AbstractDataProcess dataProcess = this.getCard().getDataProcess();
        BasicDataModel data = dataProcess.getCardData(sscId, userGroup, dateRange);
        this.setShareValue(dateRange, this.getShareValue(data));
        if (this.dataStatus(data)) {
            this.setData(data);
        }
    }

    protected void setData(BasicDataModel data) {
        IFormView view = this.getView();
        ((Label)view.getControl("labelcount")).setText(String.valueOf(data.getValue()));
        ((Label)view.getControl("labelrate")).setText(data.getPercent() + "%");
        PageUtils.setLabel(this.getView(), "linkpercentlabel", data.getLinkPercent());
        PageUtils.setLabel(this.getView(), "avgpercentlabel", data.getAvgPercent());
    }

    protected boolean dataStatus(BasicDataModel data) {
        if (data.getTotalValue().compareTo(BigDecimal.ZERO) == 0) {
            this.setPropDataTag(0);
            return false;
        }
        this.setPropDataTag(new DateSpanWrapper(this.getDateRange()).getDateType() + 1);
        return true;
    }

    protected String getShareValue(BasicDataModel data) {
        return "-";
    }

    protected String getTipsTitle() {
        return "-";
    }

    protected String getTipsContent() {
        return "-";
    }
}

