/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.workload;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.ssc.task.mobile.common.UserParameterHelper;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.index.SscDateSpanCardTemplatePlugin;
import kd.ssc.task.mobile.formplugin.workload.graph.TaskPoolGraphicHelper;
import kd.ssc.task.mobile.template.datespan.DateSpanPO;
import kd.ssc.task.mobile.utils.OperationLogUtil;

public class SscTaskPoolCardFormPlugin
extends SscDateSpanCardTemplatePlugin {
    public static final String FORMID = "scc_taskpool_card_m";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"text_warning"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getView().getParentView() != null) {
            super.registerParentView("ssc_index_m", "ssc_subject_card_m");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TaskPoolGraphicHelper.initTaskPoolGraph(this.getView(), this.getDateSpanPO());
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("text_warning".equals(key)) {
            this.showWariningNumberFrame();
        }
    }

    private void showWariningNumberFrame() {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("scc_warningnumber_m");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> custParam = new HashMap<String, String>();
        custParam.put("position", "bottom");
        parameter.getOpenStyle().setCustParam(custParam);
        parameter.setCustomParam("warning_key", (Object)this.getWarningKey());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "warningNumber"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private String getWarningKey() {
        return "scc_taskpool_card_m#" + this.getView().getFormShowParameter().getCustomParam("sharecenter") + "#" + this.getView().getFormShowParameter().getCustomParam("usergroup");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName = e.getProperty().getName();
        if ("radiogroupfield".equals(keyName)) {
            TaskPoolGraphicHelper.initTaskPoolGraph(this.getView(), this.getDateSpanPO());
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        HashMap returnDataMap;
        String warning_value;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("warningNumber".equals(actionId) && closedCallBackEvent.getReturnData() != null && (warning_value = (String)(returnDataMap = (HashMap)closedCallBackEvent.getReturnData()).get("warning_value")) != null && Long.parseLong(warning_value) >= 0L) {
            UserParameterHelper.saveKeyValue(this.getWarningKey(), this.getWarningDataStr(returnDataMap));
            OperationLogUtil.log(ResManager.loadKDString((String)"\u8bbe\u7f6e\u4efb\u52a1\u5b58\u91cf\u9884\u8b66\u503c", (String)"SscTaskPoolCardFormPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bbe\u7f6e\u4efb\u52a1\u5b58\u91cf\u9884\u8b66\u503c\u6210\u529f\u3002", (String)"SscTaskPoolCardFormPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]), FORMID);
            this.getPageCache().put("warning_key", this.getWarningDataStr(returnDataMap));
            this.refreshFormAfterResetTaskPoolWarningValue();
        }
    }

    @Override
    protected void operationAfterSwitchDateSpan(DateSpanPO dateSpanPO) {
        super.operationAfterSwitchDateSpan(dateSpanPO);
        TaskPoolGraphicHelper.initTaskPoolGraph(this.getView(), dateSpanPO);
    }

    private void refreshFormAfterResetTaskPoolWarningValue() {
        IFormView indexTaskPoolView;
        IFormView indexTaskStockTrendView;
        TaskPoolGraphicHelper.initTaskPoolGraph(this.getView(), this.getDateSpanPO());
        IFormView subjectTaskStockTrendView = super.getCardViewFromParent("ssc_subject_card_m", CardEnum.TaskStockTrendCard.getFormId());
        if (subjectTaskStockTrendView != null) {
            subjectTaskStockTrendView.invokeOperation("refresh");
            this.getView().sendFormAction(subjectTaskStockTrendView);
        }
        if ((indexTaskStockTrendView = super.getCardViewFromParent("ssc_index_m", CardEnum.TaskStockTrendCard.getFormId())) != null) {
            indexTaskStockTrendView.invokeOperation("refresh");
            this.getView().sendFormAction(indexTaskStockTrendView);
        }
        if ((indexTaskPoolView = super.getCardViewFromParent("ssc_index_m", CardEnum.TaskPoolCard.getFormId())) != null) {
            indexTaskPoolView.invokeOperation("refresh");
            this.getView().sendFormAction(indexTaskPoolView);
        }
    }

    private String getWarningDataStr(Map<String, String> returnDataMap) {
        String newWarningValueStr;
        String oldWarningValueStr = this.getUserCurrentWarningMapData(UserServiceHelper.getCurrentUserId()).get(this.getWarningKey());
        if (StringUtils.isNotBlank((CharSequence)oldWarningValueStr)) {
            String oldDateStr = oldWarningValueStr.split("#")[2];
            newWarningValueStr = returnDataMap.get("warning_value") + "#" + returnDataMap.get("warning_notice") + "#" + oldDateStr;
        } else {
            newWarningValueStr = returnDataMap.get("warning_value") + "#" + returnDataMap.get("warning_notice") + "#" + "0000-00-00";
        }
        return newWarningValueStr;
    }

    @Override
    protected void fillSscCardShareParam(HashMap<String, Object> args) {
        super.fillSscCardShareParam(args);
        args.put("title", CardEnum.TaskPoolCard.getCaption());
        String content = this.getShareContent(ResManager.loadKDString((String)"\u5f53\u524d\u5f85\u5904\u7406\uff1a%s", (String)"SscTaskPoolCardFormPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        args.put("content", content);
        args.put("cellContent", content);
    }

    @Override
    protected void onlyRead() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"text_warning"});
    }

    private Map<String, String> getUserCurrentWarningMapData(Long userId) {
        Map<String, String> jsonMap = new HashMap<String, String>();
        String sql = " SELECT FDATA FROM T_BAS_USERPARAMETER WHERE FUSERID=? AND FFORMID=? AND FEXTEND=? AND FISLISTOPTION=? ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FUSERID", -5, (Object)userId));
        params.add(new SqlParameter(":FFORMID", 12, (Object)"ssc_index_m"));
        params.add(new SqlParameter(":FEXTEND", 12, (Object)"SSC_USERPARAMETER_KEY"));
        params.add(new SqlParameter(":FISLISTOPTION", 16, (Object)Boolean.FALSE));
        ResultSetHandler action = rs -> rs.next() ? rs.getString(1) : null;
        String jsonData = (String)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray(new SqlParameter[0]), (ResultSetHandler)action);
        if (StringUtils.isNotBlank((CharSequence)jsonData)) {
            jsonMap = (Map)SerializationUtils.fromJsonString((String)jsonData, Map.class);
        }
        return jsonMap;
    }
}

