/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.workload;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.OrgRelationQueryHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;

public class SscToDoTaskGroupDetailCardFormPlugin
extends AbstractMobFormPlugin
implements TabSelectListener,
RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl("tabap");
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        CardEntry entryentity = (CardEntry)this.getControl("entryentity");
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initialPermPanel();
        this.initialTaskPanel();
        this.initialTaskList("tab_usergroup");
    }

    private void initialPermPanel() {
        Label sscLabel = (Label)this.getControl("label_ssc");
        sscLabel.setText(CommonQueryHelper.getNameById("bos_org", this.getSscId()));
        Label groupLabel = (Label)this.getControl("label_group");
        if (this.getGroupId() == -1L) {
            groupLabel.setText(ResManager.loadKDString((String)"\u5168\u90e8\u7528\u6237\u7ec4", (String)"SscToDoTaskGroupDetailCardFormPlugin_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            groupLabel.setText(CommonQueryHelper.getNameById("task_usergroup", this.getGroupId()));
        }
    }

    private void initialTaskPanel() {
        DynamicObjectCollection toDoTasks = this.getToDoTasks();
        this.initTaskLabel((List<DynamicObject>)toDoTasks);
        this.initTaskDealerNumberLabel((List<DynamicObject>)toDoTasks);
        this.initAverageTaskLabel((List<DynamicObject>)toDoTasks);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.initialTaskList(tabSelectEvent.getTabKey());
    }

    private void initialTaskList(String type) {
        DynamicObjectCollection toDoTasks = this.getToDoTasks();
        switch (type) {
            case "tab_usergroup": {
                Map<String, List<DynamicObject>> tasksMapByGroupId = toDoTasks.stream().collect(Collectors.groupingBy(dy -> dy.getString("usergroup.id")));
                this.initialListData(type, tasksMapByGroupId);
                break;
            }
            case "tab_org": {
                Map<String, List<DynamicObject>> tasksMapByOrg = toDoTasks.stream().collect(Collectors.groupingBy(dy -> dy.getString("orgid.id")));
                this.initialListData(type, tasksMapByOrg);
                break;
            }
            case "tab_business_doc": {
                Map<String, List<DynamicObject>> tasksMapByBillType = toDoTasks.stream().collect(Collectors.groupingBy(dy -> dy.getString("billtype.id")));
                this.initialListData(type, tasksMapByBillType);
            }
        }
    }

    private void initialListData(String type, Map<String, List<DynamicObject>> tasksMapByGroupId) {
        List<Map<String, Object>> listDataParameterMap = this.translateTasksToListDataParameters(tasksMapByGroupId, type);
        this.fillDataIntoList(listDataParameterMap);
    }

    private void fillDataIntoList(List<Map<String, Object>> listDataParameterMap) {
        if (CollectionUtils.isEmpty(listDataParameterMap)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity"});
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("entryentity", "setCardScrollBartoTop", new Object[]{Boolean.TRUE});
        model.beginInit();
        int size = listDataParameterMap.size();
        model.batchCreateNewEntryRow("entryentity", size);
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentity");
        DynamicProperty typeName = dynamicObjects.getDynamicObjectType().getProperty("type_name");
        DynamicProperty averageTaskNumber = dynamicObjects.getDynamicObjectType().getProperty("average_task_number");
        DynamicProperty taskNumber = dynamicObjects.getDynamicObjectType().getProperty("task_number");
        DynamicProperty tabType = dynamicObjects.getDynamicObjectType().getProperty("tab_type");
        DynamicProperty groupId = dynamicObjects.getDynamicObjectType().getProperty("groupid");
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = listDataParameterMap.get(i);
            DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
            typeName.setValueFast((Object)entry, map.get("type_name"));
            averageTaskNumber.setValueFast((Object)entry, map.get("average_task_number"));
            taskNumber.setValueFast((Object)entry, map.get("task_number"));
            tabType.setValueFast((Object)entry, map.get("tab_type"));
            groupId.setValueFast((Object)entry, map.get("groupid"));
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private List<Map<String, Object>> translateTasksToListDataParameters(Map<String, List<DynamicObject>> tasksMapByGroupId, String type) {
        ArrayList<Map<String, Object>> parameterList = new ArrayList<Map<String, Object>>(tasksMapByGroupId.size());
        if (CollectionUtils.isEmpty(tasksMapByGroupId)) {
            this.fillDataWhichIsZero(parameterList, tasksMapByGroupId, type);
            return parameterList;
        }
        for (Map.Entry<String, List<DynamicObject>> entry : tasksMapByGroupId.entrySet()) {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            switch (type) {
                case "tab_usergroup": {
                    parameterMap.put("type_name", entry.getValue().get(0).getString("usergroup.name"));
                    parameterMap.put("tab_type", "1");
                    parameterMap.put("groupid", entry.getValue().get(0).getString("usergroup.id"));
                    break;
                }
                case "tab_org": {
                    parameterMap.put("type_name", entry.getValue().get(0).getString("orgid.name"));
                    parameterMap.put("tab_type", "2");
                    break;
                }
                case "tab_business_doc": {
                    parameterMap.put("type_name", entry.getValue().get(0).getString("billtype.name"));
                    parameterMap.put("tab_type", "3");
                }
            }
            parameterMap.put("average_task_number", this.getAverageTaskNumber(entry.getValue()));
            parameterMap.put("task_number", entry.getValue().size());
            parameterList.add(parameterMap);
        }
        this.fillDataWhichIsZero(parameterList, tasksMapByGroupId, type);
        parameterList.sort((map1, map2) -> (Integer)map2.get("task_number") - (Integer)map1.get("task_number"));
        return parameterList;
    }

    private void fillDataWhichIsZero(List<Map<String, Object>> parameterList, Map<String, List<DynamicObject>> tasksMapByGroupId, String type) {
        switch (type) {
            case "tab_usergroup": {
                if (this.getGroupId() == -1L) {
                    DynamicObjectCollection allGroupBySscId = CommonQueryHelper.getAllGroupBySscId(this.getSscId(), this.getUserId());
                    Set<String> groupIdsWhichNotEmpty = tasksMapByGroupId.keySet();
                    List groupIdsWhichIsEmpty = allGroupBySscId.stream().filter(dy -> !groupIdsWhichNotEmpty.contains(dy.getString("id"))).collect(Collectors.toList());
                    for (DynamicObject dynamicObject : groupIdsWhichIsEmpty) {
                        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                        parameterMap.put("type_name", dynamicObject.getString("name"));
                        parameterMap.put("tab_type", "1");
                        parameterMap.put("groupid", dynamicObject.getString("id"));
                        parameterMap.put("average_task_number", 0.0);
                        parameterMap.put("task_number", 0);
                        parameterList.add(parameterMap);
                    }
                    break;
                }
                if (!CollectionUtils.isEmpty(parameterList)) break;
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"task_usergroup", (String)"id,number,name", (QFilter[])new QFilter("id", "=", (Object)this.getGroupId()).toArray());
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                parameterMap.put("type_name", dynamicObject.getString("name"));
                parameterMap.put("tab_type", "1");
                parameterMap.put("groupid", dynamicObject.getString("id"));
                parameterMap.put("average_task_number", 0.0);
                parameterMap.put("task_number", 0);
                parameterList.add(parameterMap);
                break;
            }
            case "tab_org": {
                Set<String> orgIdsWhichNotEmpty = tasksMapByGroupId.keySet();
                List<Long> allToOrg = OrgRelationQueryHelper.getFromOrgList(this.getSscId());
                DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter("id", "in", allToOrg).toArray());
                List orgIdsWhichIsEmpty = orgs.stream().filter(dy -> !orgIdsWhichNotEmpty.contains(dy.getString("id"))).collect(Collectors.toList());
                for (DynamicObject dynamicObject : orgIdsWhichIsEmpty) {
                    HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                    parameterMap.put("type_name", dynamicObject.getString("name"));
                    parameterMap.put("tab_type", "2");
                    parameterMap.put("average_task_number", 0.0);
                    parameterMap.put("task_number", 0);
                    parameterList.add(parameterMap);
                }
                break;
            }
            case "tab_business_doc": {
                DynamicObjectCollection taskBills = QueryServiceHelper.query((String)"task_taskbill", (String)"id,number,name", (QFilter[])new QFilter("ssccenter", "=", (Object)this.getSscId()).toArray());
                Set<String> billIdsWhichNotEmpty = tasksMapByGroupId.keySet();
                List billIdsWhichIsEmpty = taskBills.stream().filter(dy -> !billIdsWhichNotEmpty.contains(dy.getString("id"))).collect(Collectors.toList());
                for (DynamicObject dynamicObject : billIdsWhichIsEmpty) {
                    HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                    parameterMap.put("type_name", dynamicObject.getString("name"));
                    parameterMap.put("tab_type", "3");
                    parameterMap.put("average_task_number", 0.0);
                    parameterMap.put("task_number", 0);
                    parameterList.add(parameterMap);
                }
                break;
            }
        }
    }

    private String getAverageTaskNumber(List<DynamicObject> tasks) {
        long personNum = tasks.stream().map(dy -> dy.getLong("personid")).distinct().count();
        return new BigDecimal(tasks.size()).divide(new BigDecimal(personNum), 1, 4).toString();
    }

    private DynamicObjectCollection getToDoTasks() {
        QFilter userFilter = SscToDoTaskGroupDetailCardFormPlugin.userFilter(this.getSscId(), this.getGroupId());
        QFilter statusFilter = new QFilter("pooltype", "=", (Object)"1");
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        return QueryServiceHelper.query((String)"task_task", (String)"id,personid,usergroup.id,usergroup.number,usergroup.name,orgid.id,orgid.name,billtype.id,billtype.name", (QFilter[])new QFilter[]{userFilter, statusFilter, notQuaCheckTask});
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("entryentity".equals(key) && "tab_usergroup".equals(((Tab)this.getControl("tabap")).getCurrentTab())) {
            int currIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(currIndex);
            String groupId = dynamicObject.getString("groupid");
            if (StringUtils.isBlank((CharSequence)groupId) || "0".equals(groupId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u7528\u6237\u7ec4\u3002", (String)"SscToDoTaskGroupDetailCardFormPlugin_3", (String)"ssc-task-mobile", (Object[])new Object[0]));
            } else {
                this.JumpToToDoTaskUserDetailPage(groupId);
            }
        }
    }

    private void JumpToToDoTaskUserDetailPage(String groupId) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId("ssc_todotask_userdetail_m");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u4efb\u52a1\u5206\u5e03", (String)"SscToDoTaskGroupDetailCardFormPlugin_2", (String)"ssc-task-mobile", (Object[])new Object[0]));
        parameter.setCustomParam("sharecenter", (Object)this.getSscId().toString());
        parameter.setCustomParam("usergroup", (Object)groupId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void initTaskLabel(List<DynamicObject> toDoTasks) {
        int taskNumer = CollectionUtils.isEmpty(toDoTasks) ? 0 : toDoTasks.size();
        Label taskNumberLabel = (Label)this.getView().getControl("label_todo_number");
        taskNumberLabel.setText(String.valueOf(taskNumer));
    }

    private void initAverageTaskLabel(List<DynamicObject> toDoTasks) {
        long TaskDealerNumber = toDoTasks.stream().map(dy -> dy.getLong("personid")).distinct().count();
        BigDecimal average = TaskDealerNumber == 0L ? (toDoTasks.size() == 0 ? new BigDecimal("0.0") : new BigDecimal("-1.0")) : new BigDecimal(toDoTasks.size()).divide(new BigDecimal(TaskDealerNumber), 1, 4);
        Label taskNumberLabel = (Label)this.getView().getControl("label_average_number");
        taskNumberLabel.setText(String.valueOf(average));
    }

    private void initTaskDealerNumberLabel(List<DynamicObject> toDoTasks) {
        long TaskDealerNumber = toDoTasks.stream().map(dy -> dy.getLong("personid")).distinct().count();
        Label taskNumberLabel = (Label)this.getView().getControl("label_dealer_number");
        taskNumberLabel.setText(String.valueOf(TaskDealerNumber));
    }

    private Long getSscId() {
        Long sscId = -1L;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("sharecenter")))) {
            sscId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        }
        return sscId;
    }

    private Long getGroupId() {
        return Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("usergroup"));
    }

    private static QFilter userFilter(Long sscId, Long userGroupId) {
        QFilter userFilter = new QFilter("sscid", "=", (Object)sscId);
        if (userGroupId == null || userGroupId == -1L) {
            return userFilter;
        }
        return userFilter.and("usergroup.id", "=", (Object)userGroupId);
    }

    protected Long getUserId() {
        return Long.parseLong(RequestContext.get().getUserId());
    }
}

