/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.workload;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.common.workcalendar.SscWorkCalendarApi;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;

public class SscToDoTaskUserDetailFormPlugin
extends AbstractMobFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection toDoTasks = this.getToDoTasks();
        this.initialPermPanel();
        this.initialTaskPanel(toDoTasks);
        this.initialTaskList(toDoTasks);
    }

    private void initialPermPanel() {
        Label sscLabel = (Label)this.getControl("label_ssc");
        sscLabel.setText(CommonQueryHelper.getNameById("bos_org", this.getSscId()));
        Label groupLabel = (Label)this.getControl("label_group");
        if (this.getGroupId() == -1L) {
            groupLabel.setText(ResManager.loadKDString((String)"\u5168\u90e8\u7528\u6237\u7ec4", (String)"SscToDoTaskUserDetailFormPlugin_1", (String)"ssc-task-mobile", (Object[])new Object[0]));
        } else {
            groupLabel.setText(CommonQueryHelper.getNameById("task_usergroup", this.getGroupId()));
        }
    }

    private void initialTaskPanel(DynamicObjectCollection toDoTasks) {
        int taskNumer = CollectionUtils.isEmpty((Collection)toDoTasks) ? 0 : toDoTasks.size();
        Label taskNumberLabel = (Label)this.getView().getControl("label_todo_number");
        taskNumberLabel.setText(String.valueOf(taskNumer));
    }

    private void initialTaskList(DynamicObjectCollection toDoTasks) {
        if (CollectionUtils.isEmpty((Collection)toDoTasks)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"entryentity"});
        Map<String, List<DynamicObject>> tasksMapByGroupId = toDoTasks.stream().collect(Collectors.groupingBy(dy -> dy.getString("personid.id")));
        List tasks = tasksMapByGroupId.values().stream().sorted((o1, o2) -> o2.size() - o1.size()).collect(Collectors.toList());
        Map<Long, Boolean> workStatusMapOfGroudId = SscWorkCalendarApi.isPersonsWork(this.getSscId().toString(), this.getGroupId().toString());
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        int size = tasksMapByGroupId.size();
        model.batchCreateNewEntryRow("entryentity", size);
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("entryentity");
        DynamicProperty userName = dynamicObjects.getDynamicObjectType().getProperty("user_name");
        DynamicProperty isOnWork = dynamicObjects.getDynamicObjectType().getProperty("is_onwork");
        DynamicProperty taskNumber = dynamicObjects.getDynamicObjectType().getProperty("task_number");
        int i = 0;
        for (List objects : tasks) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            userName.setValueFast((Object)dynamicObject, (Object)((DynamicObject)objects.get(0)).getString("personid.name"));
            Boolean isWork = workStatusMapOfGroudId.get(((DynamicObject)objects.get(0)).getLong("personid.id"));
            isOnWork.setValueFast((Object)dynamicObject, (Object)(Boolean.TRUE.equals(isWork) ? "1" : "0"));
            taskNumber.setValueFast((Object)dynamicObject, (Object)objects.size());
            ++i;
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private DynamicObjectCollection getToDoTasks() {
        QFilter userFilter = SscToDoTaskUserDetailFormPlugin.userFilter(this.getSscId(), this.getGroupId());
        QFilter statusFilter = new QFilter("pooltype", "=", (Object)"1");
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        return QueryServiceHelper.query((String)"task_task", (String)"id,personid.id,personid.name", (QFilter[])new QFilter[]{userFilter, statusFilter, notQuaCheckTask});
    }

    private Long getSscId() {
        Long sscId = -1L;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("sharecenter")))) {
            sscId = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("sharecenter"));
        }
        return sscId;
    }

    private Long getGroupId() {
        return Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("usergroup"));
    }

    private static QFilter userFilter(Long sscId, Long userGroupId) {
        QFilter userFilter = new QFilter("sscid", "=", (Object)sscId);
        if (userGroupId == null || userGroupId == -1L) {
            return userFilter;
        }
        return userFilter.and("usergroup.id", "=", (Object)userGroupId);
    }
}

