/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.formplugin.workload.graph;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.common.UserParameterHelper;
import kd.ssc.task.mobile.common.chart.M;
import kd.ssc.task.mobile.enums.CardEnum;
import kd.ssc.task.mobile.formplugin.workload.constant.SecureStatusEnum;
import kd.ssc.task.mobile.template.datespan.DateSpanPO;
import kd.ssc.task.mobile.utils.CommonUtils;
import kd.ssc.task.mobile.utils.DateSpanCommonUtils;

public class TaskPoolGraphicHelper {
    public static void initTaskPoolGraph(IFormView view, DateSpanPO dateSpanPO) {
        BarChart taskPoolChart = (BarChart)view.getControl("task_pool_chart");
        taskPoolChart.clearData();
        List<Integer> seriesDataList = TaskPoolGraphicHelper.getSeriesDataByDate(view, dateSpanPO);
        TaskPoolGraphicHelper.setToolTip(taskPoolChart);
        TaskPoolGraphicHelper.setGrid(taskPoolChart);
        TaskPoolGraphicHelper.setXAxis(taskPoolChart, dateSpanPO);
        TaskPoolGraphicHelper.setYAxis(taskPoolChart);
        TaskPoolGraphicHelper.setSeries(taskPoolChart, view, seriesDataList);
        TaskPoolGraphicHelper.updateSecureStatusLabel(view, seriesDataList);
        view.updateView("task_pool_chart");
    }

    private static void updateSecureStatusLabel(IFormView view, List<Integer> seriesDataList) {
        SecureStatusEnum secureStatus = TaskPoolGraphicHelper.getSecureStatusFlag(view, seriesDataList);
        if (secureStatus.getNumber() == 4) {
            view.setVisible(Boolean.FALSE, new String[]{"imageap"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"imageap"});
            Image imageap = (Image)view.getControl("imageap");
            imageap.setUrl(secureStatus.getPicPath());
        }
        Label label = (Label)view.getControl("status_label");
        label.setText(secureStatus.getText());
    }

    private static SecureStatusEnum getSecureStatusFlag(IFormView view, List<Integer> seriesDataList) {
        Integer currentStock = seriesDataList.get(3);
        Integer warningValue = TaskPoolGraphicHelper.getWarningValue(view);
        if (warningValue == -1) {
            return SecureStatusEnum.UNSET;
        }
        BigDecimal percent = new BigDecimal(currentStock).divide(new BigDecimal(warningValue), 1, 3);
        if (percent.compareTo(new BigDecimal("0.9")) < 0) {
            return SecureStatusEnum.NORMAL;
        }
        if (percent.compareTo(new BigDecimal("1")) >= 0) {
            return SecureStatusEnum.DANGEROUS;
        }
        return SecureStatusEnum.WARNING;
    }

    private static void setToolTip(BarChart taskPoolChart) {
        HashMap<String, Object> lineStyleMap = new HashMap<String, Object>();
        lineStyleMap.put("color", "rgba(128,128,128,0.2)");
        lineStyleMap.put("width", 150);
        HashMap<String, Object> axisPointerMap = new HashMap<String, Object>();
        axisPointerMap.put("type", "shadow");
        axisPointerMap.put("lineStyle", lineStyleMap);
        taskPoolChart.addTooltip("trigger", (Object)"axis");
        taskPoolChart.addTooltip("axisPointer", axisPointerMap);
        taskPoolChart.addTooltip("formatter", (Object)"function(params){var tar=params[1]; return tar.name + '<br/>' + tar.seriesName+' : ' + tar.value;}");
        ArrayList<String> formatterPathList = new ArrayList<String>();
        formatterPathList.add("tooltip");
        formatterPathList.add("formatter");
        taskPoolChart.addFuncPath(formatterPathList);
    }

    private static void setGrid(BarChart taskPoolChart) {
        taskPoolChart.setMargin(Position.left, "3%");
        taskPoolChart.setMargin(Position.top, "12%");
        taskPoolChart.setMargin(Position.right, "12%");
        taskPoolChart.setMargin(Position.bottom, "3%");
    }

    private static void setXAxis(BarChart taskPoolChart, DateSpanPO dateSpanPO) {
        HashMap<String, Boolean> splitLineMap = new HashMap<String, Boolean>();
        splitLineMap.put("show", Boolean.FALSE);
        HashMap<String, Boolean> axisTickMap = new HashMap<String, Boolean>();
        axisTickMap.put("show", Boolean.FALSE);
        HashMap<String, Object> LineStyleMap = new HashMap<String, Object>();
        LineStyleMap.put("color", "#E8E8E8");
        LineStyleMap.put("width", 1);
        HashMap<String, HashMap<String, Object>> axisLineMap = new HashMap<String, HashMap<String, Object>>();
        axisLineMap.put("lineStyle", LineStyleMap);
        HashMap<String, Object> textStyleMap = new HashMap<String, Object>();
        textStyleMap.put("fontSize", 12);
        textStyleMap.put("color", "#999");
        HashMap<String, Object> dataMap1 = new HashMap<String, Object>();
        dataMap1.put("value", ResManager.loadKDString((String)"\u671f\u521d", (String)"TaskPoolGraphicHelper_8", (String)"ssc-task-mobile", (Object[])new Object[0]));
        dataMap1.put("textStyle", textStyleMap);
        HashMap<String, Object> dataMap2 = new HashMap<String, Object>();
        dataMap2.put("value", ResManager.loadKDString((String)"\u65b0\u589e", (String)"TaskPoolGraphicHelper_9", (String)"ssc-task-mobile", (Object[])new Object[0]));
        dataMap2.put("textStyle", textStyleMap);
        HashMap<String, Object> dataMap3 = new HashMap<String, Object>();
        dataMap3.put("value", ResManager.loadKDString((String)"\u5b8c\u6210", (String)"TaskPoolGraphicHelper_10", (String)"ssc-task-mobile", (Object[])new Object[0]));
        dataMap3.put("textStyle", textStyleMap);
        HashMap<String, Object> dataMap4 = new HashMap<String, Object>();
        dataMap4.put("value", TaskPoolGraphicHelper.getEndXLabel(dateSpanPO));
        dataMap4.put("textStyle", textStyleMap);
        ArrayList<HashMap<String, Object>> dataList = new ArrayList<HashMap<String, Object>>();
        dataList.add(dataMap1);
        dataList.add(dataMap2);
        dataList.add(dataMap3);
        dataList.add(dataMap4);
        Axis xAxis = taskPoolChart.createXAxis("");
        xAxis.setPropValue("type", (Object)"category");
        xAxis.setPropValue("splitLine", splitLineMap);
        xAxis.setPropValue("axisTick", axisTickMap);
        xAxis.setPropValue("axisLine", axisLineMap);
        xAxis.setPropValue("data", dataList);
    }

    private static String getEndXLabel(DateSpanPO dateSpanPO) {
        LocalDate endLocalDate = CommonUtils.date2LocalDate(dateSpanPO.getEndDateSpan());
        if (endLocalDate != null && endLocalDate.compareTo(LocalDate.now()) < 0) {
            return ResManager.loadKDString((String)"\u671f\u672b", (String)"TaskPoolGraphicHelper_11", (String)"ssc-task-mobile", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5f53\u524d", (String)"TaskPoolGraphicHelper_12", (String)"ssc-task-mobile", (Object[])new Object[0]);
    }

    private static void setYAxis(BarChart taskPoolChart) {
        HashMap<String, Object> nameTextStyleMap = new HashMap<String, Object>();
        nameTextStyleMap.put("color", "#999");
        nameTextStyleMap.put("fontSize", 12);
        nameTextStyleMap.put("align", "left");
        HashMap<String, Boolean> axisLineMap = new HashMap<String, Boolean>();
        axisLineMap.put("show", Boolean.FALSE);
        HashMap<String, Object> axisLabelMap = new HashMap<String, Object>();
        axisLabelMap.put("color", "#999");
        axisLabelMap.put("fontSize", 12);
        HashMap<String, Boolean> axisTickMap = new HashMap<String, Boolean>();
        axisTickMap.put("show", Boolean.FALSE);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("type", "dashed");
        lineStyleMap.put("color", "#e8e8e8");
        HashMap<String, HashMap<String, String>> splitLineMap = new HashMap<String, HashMap<String, String>>();
        splitLineMap.put("lineStyle", lineStyleMap);
        Axis yAxis = taskPoolChart.createYAxis(ResManager.loadKDString((String)"\u6570\u91cf", (String)"TaskPoolGraphicHelper_1", (String)"ssc-task-mobile", (Object[])new Object[0]), AxisType.value);
        yAxis.setPropValue("min", (Object)0);
        yAxis.setPropValue("nameLocation", (Object)"end");
        yAxis.setPropValue("nameTextStyle", nameTextStyleMap);
        yAxis.setPropValue("axisLine", axisLineMap);
        yAxis.setPropValue("axisLabel", axisLabelMap);
        yAxis.setPropValue("axisTick", axisTickMap);
        yAxis.setPropValue("splitLine", splitLineMap);
    }

    private static void setSeries(BarChart taskPoolChart, IFormView view, List<Integer> seriesDataList) {
        TaskPoolGraphicHelper.fillAuxSeries(taskPoolChart, seriesDataList, view);
        TaskPoolGraphicHelper.fillNumberSeries(taskPoolChart, seriesDataList);
    }

    private static List<Integer> getSeriesDataByDate(IFormView view, DateSpanPO dateSpanPO) {
        Integer increaseCount;
        Integer decreaseCount;
        LocalDate localDateSpanOfStart = CommonUtils.date2LocalDate(dateSpanPO.getStartDateSpan());
        LocalDate localDateSpanOfEnd = CommonUtils.date2LocalDate(dateSpanPO.getEndDateSpan());
        Long sscId = -1L;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)view.getFormShowParameter().getCustomParam("sharecenter")))) {
            sscId = Long.parseLong((String)view.getFormShowParameter().getCustomParam("sharecenter"));
        }
        String userGroupId = (String)view.getFormShowParameter().getCustomParam("usergroup");
        Integer currentCount = TaskPoolGraphicHelper.getCurrentCount(sscId, userGroupId);
        if (localDateSpanOfEnd != null && localDateSpanOfEnd.compareTo(LocalDate.now()) < 0) {
            decreaseCount = TaskPoolGraphicHelper.getDecreaseCount(sscId, userGroupId, localDateSpanOfEnd.plusDays(1L), LocalDate.now());
            increaseCount = TaskPoolGraphicHelper.getIncreaseCount(sscId, userGroupId, localDateSpanOfEnd.plusDays(1L), LocalDate.now());
            currentCount = currentCount + decreaseCount - increaseCount;
        }
        if (view.getPageCache().get("CACHE_SHARE_VALUE") == null) {
            view.getPageCache().put("CACHE_SHARE_VALUE", currentCount + "");
        }
        decreaseCount = TaskPoolGraphicHelper.getDecreaseCount(sscId, userGroupId, localDateSpanOfStart, localDateSpanOfEnd);
        increaseCount = TaskPoolGraphicHelper.getIncreaseCount(sscId, userGroupId, localDateSpanOfStart, localDateSpanOfEnd);
        Integer initialCount = currentCount + decreaseCount - increaseCount;
        return Arrays.asList(initialCount, increaseCount, decreaseCount, currentCount);
    }

    /*
     * Exception decompiling
     */
    private static Integer getIncreaseCount(Long sscId, String userGroupId, LocalDate start, LocalDate end) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Integer getDecreaseCount(Long sscId, String userGroupId, LocalDate start, LocalDate end) {
        QFilter userFilter = TaskPoolGraphicHelper.userFilter(sscId, userGroupId);
        QFilter completetimeFilter = DateSpanCommonUtils.timeSection("completetime", start, end);
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ssc", (String)"task_taskhistory", (String)"id", (QFilter[])new QFilter[]{userFilter, completetimeFilter, notQuaCheckTask}, null);){
            Integer n = dataSet.count("id", false);
            return n;
        }
    }

    private static Integer getCurrentCount(Long sscId, String userGroupId) {
        QFilter userFilter = TaskPoolGraphicHelper.userFilter(sscId, userGroupId);
        QFilter statusFilter = new QFilter("pooltype", "=", (Object)"1");
        QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ssc", (String)"task_task", (String)"id", (QFilter[])new QFilter[]{userFilter, statusFilter, notQuaCheckTask}, null);){
            Integer n = dataSet.count("id", false);
            return n;
        }
    }

    private static QFilter userFilter(Long sscId, String userGroupId) {
        QFilter userFilter = new QFilter("sscid", "=", (Object)sscId);
        if (userGroupId == null || "".equals(userGroupId) || "-1".equals(userGroupId)) {
            return userFilter;
        }
        return userFilter.and("usergroup.id", "=", (Object)Long.valueOf(userGroupId));
    }

    private static void fillAuxSeries(BarChart taskPoolChart, List<Integer> seriesDatas, IFormView view) {
        HashMap<String, String> normalMap1 = new HashMap<String, String>();
        normalMap1.put("barBorderColor", "rgba(0,0,0,0)");
        normalMap1.put("color", "rgba(0,0,0,0)");
        HashMap<String, HashMap<String, String>> itemStyleMap = new HashMap<String, HashMap<String, String>>();
        itemStyleMap.put("normal", normalMap1);
        HashMap<String, HashMap<String, HashMap<String, String>>> emphasisMap = new HashMap<String, HashMap<String, HashMap<String, String>>>();
        emphasisMap.put("itemStyle", itemStyleMap);
        HashMap<String, String> normalMap2 = new HashMap<String, String>();
        normalMap2.put("type", "dashed");
        normalMap2.put("color", "rgba(255,153,28,1)");
        HashMap<String, HashMap<String, String>> lineStyleMap = new HashMap<String, HashMap<String, String>>();
        lineStyleMap.put("normal", normalMap2);
        HashMap<String, String> normalMap3 = new HashMap<String, String>();
        normalMap3.put("position", "end");
        HashMap<String, HashMap<String, String>> labelMap = new HashMap<String, HashMap<String, String>>();
        labelMap.put("normal", normalMap3);
        HashMap<String, Object> markLineDataMap = new HashMap<String, Object>();
        markLineDataMap.put("yAxis", TaskPoolGraphicHelper.getWarningValue(view));
        markLineDataMap.put("symbol", "none");
        ArrayList<HashMap<String, Object>> markLineDataList = new ArrayList<HashMap<String, Object>>();
        markLineDataList.add(markLineDataMap);
        HashMap<String, Object> markLineMap = new HashMap<String, Object>();
        markLineMap.put("lineStyle", lineStyleMap);
        markLineMap.put("label", labelMap);
        markLineMap.put("data", markLineDataList);
        markLineMap.put("silent", "true");
        ArrayList<Integer> dataList = new ArrayList<Integer>();
        dataList.add(0);
        dataList.add(seriesDatas.get(0));
        dataList.add(seriesDatas.get(0) + seriesDatas.get(1) - seriesDatas.get(2));
        dataList.add(0);
        BarSeries barSeries = taskPoolChart.createBarSeries(ResManager.loadKDString((String)"\u8f85\u52a9", (String)"TaskPoolGraphicHelper_5", (String)"ssc-task-mobile", (Object[])new Object[0]));
        barSeries.setPropValue("stack", (Object)ResManager.loadKDString((String)"\u603b\u91cf", (String)"TaskPoolGraphicHelper_2", (String)"ssc-task-mobile", (Object[])new Object[0]));
        barSeries.setPropValue("barWidth", (Object)"30");
        barSeries.setPropValue("itemStyle", itemStyleMap);
        barSeries.setPropValue("emphasis", emphasisMap);
        barSeries.setPropValue("markLine", markLineMap);
        barSeries.setPropValue("data", dataList);
        Integer warningValue = TaskPoolGraphicHelper.getWarningValue(view);
        LineSeries lineSeries = taskPoolChart.createLineSeries(ResManager.loadKDString((String)"\u900f\u660e\u9884\u8b66\u8f85\u52a9", (String)"TaskPoolGraphicHelper_13", (String)"ssc-task-mobile", (Object[])new Object[0]));
        lineSeries.setPropValue("symbol", (Object)"none");
        lineSeries.setLineColor("rgba(255,255,255,0)");
        lineSeries.setPropValue("data", M.arraylist(warningValue));
    }

    private static void fillNumberSeries(BarChart taskPoolChart, List<Integer> seriesDatas) {
        HashMap<String, Object> normalMap1 = new HashMap<String, Object>();
        normalMap1.put("show", Boolean.TRUE);
        normalMap1.put("position", "top");
        normalMap1.put("fontSize", 12);
        HashMap<String, HashMap<String, Object>> labelMap = new HashMap<String, HashMap<String, Object>>();
        labelMap.put("normal", normalMap1);
        HashMap<String, String> itemStyleNormalMap = new HashMap<String, String>();
        itemStyleNormalMap.put("color", "(params)=>{let colors=['#276FF5','#FDC200','#1BA854','#276FF5']; return colors[params.dataIndex];}");
        HashMap<String, HashMap<String, String>> itemStyleMap = new HashMap<String, HashMap<String, String>>();
        itemStyleMap.put("normal", itemStyleNormalMap);
        HashMap<String, String> normalMap2 = new HashMap<String, String>();
        normalMap2.put("type", "dashed");
        normalMap2.put("color", "#666666");
        HashMap<String, HashMap<String, String>> lineStyleMap = new HashMap<String, HashMap<String, String>>();
        lineStyleMap.put("normal", normalMap2);
        ArrayList<Integer> coordList1 = new ArrayList<Integer>();
        coordList1.add(0);
        coordList1.add(seriesDatas.get(0));
        ArrayList<Integer> coordList2 = new ArrayList<Integer>();
        coordList2.add(1);
        coordList2.add(seriesDatas.get(0));
        HashMap<String, Object> markLineDataMap1 = new HashMap<String, Object>();
        markLineDataMap1.put("symbol", "none");
        markLineDataMap1.put("silent", "true");
        markLineDataMap1.put("coord", coordList1);
        HashMap<String, Object> markLineDataMap2 = new HashMap<String, Object>();
        markLineDataMap2.put("symbol", "none");
        markLineDataMap2.put("coord", coordList2);
        markLineDataMap2.put("silent", "true");
        ArrayList<Integer> coordList3 = new ArrayList<Integer>();
        coordList3.add(1);
        coordList3.add(seriesDatas.get(0) + seriesDatas.get(1));
        ArrayList<Integer> coordList4 = new ArrayList<Integer>();
        coordList4.add(2);
        coordList4.add(seriesDatas.get(0) + seriesDatas.get(1));
        HashMap<String, Object> markLineDataMap3 = new HashMap<String, Object>();
        markLineDataMap3.put("symbol", "none");
        markLineDataMap3.put("coord", coordList3);
        markLineDataMap3.put("silent", "true");
        HashMap<String, Object> markLineDataMap4 = new HashMap<String, Object>();
        markLineDataMap4.put("symbol", "none");
        markLineDataMap4.put("coord", coordList4);
        markLineDataMap4.put("silent", "true");
        ArrayList<Integer> coordList5 = new ArrayList<Integer>();
        coordList5.add(2);
        coordList5.add(seriesDatas.get(0) + seriesDatas.get(1) - seriesDatas.get(2));
        ArrayList<Integer> coordList6 = new ArrayList<Integer>();
        coordList6.add(3);
        coordList6.add(seriesDatas.get(0) + seriesDatas.get(1) - seriesDatas.get(2));
        HashMap<String, Object> markLineDataMap5 = new HashMap<String, Object>();
        markLineDataMap5.put("symbol", "none");
        markLineDataMap5.put("coord", coordList5);
        HashMap<String, Object> markLineDataMap6 = new HashMap<String, Object>();
        markLineDataMap6.put("symbol", "none");
        markLineDataMap6.put("coord", coordList6);
        ArrayList<List<Map>> markLineDataList = new ArrayList<List<Map>>();
        markLineDataList.add(Arrays.asList(markLineDataMap1, markLineDataMap2));
        markLineDataList.add(Arrays.asList(markLineDataMap3, markLineDataMap4));
        markLineDataList.add(Arrays.asList(markLineDataMap5, markLineDataMap6));
        HashMap<String, Object> markLineMap = new HashMap<String, Object>();
        markLineMap.put("symbol", "circle");
        markLineMap.put("symbolSize", 5);
        markLineMap.put("lineStyle", lineStyleMap);
        markLineMap.put("data", markLineDataList);
        BarSeries barSeries = taskPoolChart.createBarSeries(ResManager.loadKDString((String)"\u6570\u91cf", (String)"TaskPoolGraphicHelper_1", (String)"ssc-task-mobile", (Object[])new Object[0]));
        barSeries.setPropValue("stack", (Object)ResManager.loadKDString((String)"\u603b\u91cf", (String)"TaskPoolGraphicHelper_2", (String)"ssc-task-mobile", (Object[])new Object[0]));
        barSeries.setPropValue("barWidth", (Object)"30");
        barSeries.setPropValue("label", labelMap);
        barSeries.setPropValue("itemStyle", itemStyleMap);
        barSeries.setPropValue("markLine", markLineMap);
        barSeries.setPropValue("data", seriesDatas);
        ArrayList<String> formatterPathList = new ArrayList<String>();
        formatterPathList.add("itemStyle");
        formatterPathList.add("normal");
        formatterPathList.add("color");
        barSeries.addFuncPath(formatterPathList);
    }

    private static String getWarningKey(IFormView view) {
        return "scc_taskpool_card_m#" + view.getFormShowParameter().getCustomParam("sharecenter") + "#" + view.getFormShowParameter().getCustomParam("usergroup");
    }

    private static Integer getWarningValue(IFormView view) {
        IFormView taskPoolView;
        String warningStr = null;
        IFormView parentView = view.getParentView();
        if (parentView != null && (taskPoolView = parentView.getView(parentView.getPageCache().get("ssc_subject_card_m#" + CardEnum.TaskPoolCard.getFormId()))) != null) {
            warningStr = taskPoolView.getPageCache().get("warning_key");
        }
        if (StringUtils.isBlank(warningStr)) {
            warningStr = view.getPageCache().get("warning_key");
        }
        if (StringUtils.isBlank(warningStr)) {
            warningStr = UserParameterHelper.getKeyValue(TaskPoolGraphicHelper.getWarningKey(view));
        }
        String warningValueStr = null;
        if (warningStr != null) {
            warningValueStr = warningStr.split("#")[0];
        }
        return StringUtils.isBlank(warningValueStr) || Integer.parseInt(warningValueStr) == 0 ? -1 : Integer.parseInt(warningValueStr);
    }
}

