/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.task;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.ssc.task.mobile.common.UserParameterHelper;
import kd.ssc.task.mobile.formplugin.warn.WarnValueModel;
import kd.ssc.task.mobile.formplugin.warn.WarnkeyModel;

public class SscWarningNoticeTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(SscWarningNoticeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        String yyyyMMdd = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        Map<String, BigDecimal> ratiodataMap = this.getQualityTaskUnqualifiedRatiodataMap();
        Set<Long> userIds = this.getAllUserWarningData();
        for (Long userId : userIds) {
            Map<String, String> map = UserParameterHelper.getWarnningValueMap(userId);
            log.info("\u5f00\u59cb - \u53d1\u9001\u8d28\u68c0\u4e0d\u5408\u683c\u7387\u9884\u8b66\u901a\u77e5:" + userId + ":" + map);
            try {
                Set<Map.Entry<String, String>> keyvalues = map.entrySet();
                for (Map.Entry<String, String> keyvalue : keyvalues) {
                    BigDecimal setValue;
                    String warningValue;
                    String key = keyvalue.getKey();
                    String value = keyvalue.getValue();
                    WarnkeyModel keyModel = WarnkeyModel.parse(key);
                    WarnValueModel valueModle = WarnValueModel.parse(value);
                    String noticetime = valueModle.getNoticetime();
                    BigDecimal ratio = ratiodataMap.get(keyModel.textkey());
                    if (ratio == null || ratio.compareTo(BigDecimal.ZERO) == 0 || !StringUtils.equals((CharSequence)valueModle.getWarningNotice(), (CharSequence)"1") || StringUtils.equals((CharSequence)yyyyMMdd, (CharSequence)noticetime) || (warningValue = valueModle.getWarningValue()) == null || ratio.compareTo(setValue = new BigDecimal(warningValue)) < 0) continue;
                    MessageCenterServiceHelper.sendMessage((MessageInfo)SscWarningNoticeTask.createMessageInfo(userId, keyModel, ratio));
                    valueModle.setNoticetime(yyyyMMdd);
                    map.put(key, valueModle.textValue());
                }
                UserParameterHelper.saveWarningValueMap(userId, map);
                log.info("\u5b8c\u6210 - \u53d1\u9001\u8d28\u68c0\u4e0d\u5408\u683c\u7387\u9884\u8b66\u901a\u77e5:" + userId + ":" + map);
            }
            catch (Exception ex) {
                throw new KDException((Throwable)ex, BosErrorCode.systemError, new Object[]{String.format(ResManager.loadKDString((String)"[\u5171\u4eab\u6d1e\u5bdf]\u8d28\u68c0\u4e0d\u5408\u683c\u7387\u9884\u8b66\u503c\u901a\u77e5\u5b9a\u65f6\u4efb\u52a1,\u53d1\u9001\u6d88\u606f\u5931\u8d25:%s", (String)"SscWarningNoticeTask_2", (String)"ssc-task-mobile", (Object[])new Object[0]), map)});
            }
        }
    }

    public static MessageInfo createMessageInfo(Long userId, WarnkeyModel keyModel, BigDecimal ratio) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTag(ResManager.loadKDString((String)"\u5171\u4eab\u6d1e\u5bdf", (String)"SscWarningNoticeTask_3", (String)"ssc-task-mobile", (Object[])new Object[0]));
        messageInfo.setTitle(ResManager.loadKDString((String)"\u5171\u4eab\u6d1e\u5bdf\uff1a\u8d28\u68c0\u4e0d\u5408\u683c\u7387\u8d85\u8fc7\u9884\u8b66\u503c(\u5f53\u5929\u4e0d\u518d\u63d0\u9192)", (String)"SscWarningNoticeTask_0", (String)"ssc-task-mobile", (Object[])new Object[0]));
        String text = ResManager.loadKDString((String)"\u5f53\u6708\u8d28\u68c0\u4e0d\u5408\u683c\u7387%s%%\uff0c\u5df2\u8d85\u8fc7\u9884\u8b66\u503c\uff0c\u8bf7\u70b9\u51fb\u94fe\u63a5\u67e5\u770b\u8be6\u7ec6", (String)"SscWarningNoticeTask_1", (String)"ssc-task-mobile", (Object[])new Object[0]);
        messageInfo.setContent(String.format(text, ratio.setScale(1, 4)));
        messageInfo.setUserIds(new ArrayList<Long>(Collections.singletonList(userId)));
        messageInfo.setType("message");
        String accountId = RequestContext.get().getAccountId();
        messageInfo.setMobContentUrl(String.format("%s/mobile.html?accountId=%s&form=ssc_subject_card_m?notice=1&accountId=%s&sharecenter=%s&usergroup=%s&formIds=ssc_unqualified_card_m,ssc_unqualified_trend_m", UrlService.getDomainContextUrl(), accountId, accountId, keyModel.getSscid(), keyModel.getUsergroup()));
        messageInfo.setNotifyType("");
        return messageInfo;
    }

    /*
     * Exception decompiling
     */
    private Map<String, BigDecimal> getQualityTaskUnqualifiedRatiodataMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Set<Long> getAllUserWarningData() {
        String sql = " SELECT FUSERID FROM T_BAS_USERPARAMETER WHERE FFORMID=? AND FEXTEND=? AND FISLISTOPTION=? ";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FFORMID", 12, (Object)"ssc_index_m"));
        params.add(new SqlParameter(":FEXTEND", 12, (Object)"SSC_UK_WARNINGValue"));
        params.add(new SqlParameter(":FISLISTOPTION", 16, (Object)Boolean.FALSE));
        try (DataSet dsAll = DB.queryDataSet((String)"kd.ssc.task.mobile.task.AbstactWarningNoticeTask_userIds", (DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray(new SqlParameter[0]));){
            HashSet<Long> set = new HashSet<Long>();
            for (Row row : dsAll) {
                long userId = row.getLong(0);
                set.add(userId);
            }
            HashSet<Long> hashSet = set;
            return hashSet;
        }
    }

    private DataSet getQualityTaskDataSet() {
        return DB.queryDataSet((String)"kd.ssc.task.mobile.task.AbstactWarningNoticeTask_getQualityTaskDataSet", (DBRoute)DBRoute.of((String)"ssc"), (String)"SELECT t1.FSSCID as sscid,t2.FUSERGROUP as usergroup,t1.FID as id,t1.fqualityresult as qualityresult FROM T_TK_TASKHISTORY t1, T_TK_TASKHISTORY t2 WHERE t1.FSOURCETASKID = t2.FID AND t1.fqualitysamplelibraryid > 0 AND t1.FTASKCREATETIME >= ? ", (Object[])new Object[]{LocalDate.now().with(TemporalAdjusters.firstDayOfMonth())});
    }
}

