/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.ssc.task.mobile.common.TaskFilterEnum;
import kd.ssc.task.mobile.task.ITransferDataBuilder;
import kd.ssc.task.mobile.template.BaseDataHelper;
import kd.ssc.task.mobile.template.ITemplateDataProcess;
import kd.ssc.task.mobile.template.data.BasicDataModel;
import kd.ssc.task.mobile.template.data.GNode;
import kd.ssc.task.mobile.template.data.GroupData;
import kd.ssc.task.mobile.template.data.HeadDataModel;
import kd.ssc.task.mobile.template.data.ItemModel;
import kd.ssc.task.mobile.template.data.ListDataModel;
import kd.ssc.task.mobile.template.data.TransferData;
import kd.ssc.task.mobile.template.datespan.DateRange;
import kd.ssc.task.mobile.template.datespan.IDateRange;
import kd.ssc.task.mobile.template.enums.BaseDataEnum;
import kd.ssc.task.mobile.template.enums.TabContainerEnum;
import kd.ssc.task.mobile.utils.CommonUtils;
import kd.ssc.task.mobile.utils.DateUtil;

public abstract class AbstractDataProcess
implements ITemplateDataProcess,
ITransferDataBuilder {
    protected static final QFilter notQuaCheckTask = new QFilter("qualitysamplelibrary", "=", (Object)TaskFilterEnum.NOTQUACHECKTASK);

    @Override
    public GNode getGroupNode(String key) {
        if (TabContainerEnum.structure_analyse.name().equals(key)) {
            GroupData root = new GroupData("root", "root");
            root.next(BaseDataEnum.USERGROUP.toData().next(BaseDataEnum.PERSONID.toData()));
            root.next(BaseDataEnum.ORGID.toData());
            root.next(BaseDataEnum.BILLTYPE.toData());
            return root.toNode();
        }
        return new GroupData().toNode();
    }

    @Override
    public BasicDataModel getCardData(TransferData transferData) {
        return new BasicDataModel();
    }

    public BasicDataModel getCardData(Long sscid, Long usergroup, IDateRange dateRange) {
        return this.getCardData(this.build(sscid, usergroup, dateRange));
    }

    @Override
    public HeadDataModel getTemplateHeadData(TransferData transferData) {
        return new HeadDataModel();
    }

    @Override
    public ListDataModel getListData(TransferData transferData) {
        if (TabContainerEnum.structure_analyse.name().equals(transferData.getKey())) {
            return this.structureAnalyse(transferData);
        }
        if (TabContainerEnum.trend_analyse.name().equals(transferData.getKey())) {
            return this.trendAnalyse(transferData);
        }
        if (TabContainerEnum.ascribe_analyse.name().equals(transferData.getKey())) {
            return this.ascribeAnalyse(transferData);
        }
        if (TabContainerEnum.aging_analyse.name().equals(transferData.getKey())) {
            return this.agingAnalyse(transferData);
        }
        return null;
    }

    protected ListDataModel structureAnalyse(TransferData transferData) {
        return new ListDataModel();
    }

    protected ListDataModel trendAnalyse(TransferData transferData) {
        return new ListDataModel();
    }

    protected ListDataModel ascribeAnalyse(TransferData transferData) {
        return new ListDataModel();
    }

    protected ListDataModel agingAnalyse(TransferData transferData) {
        return new ListDataModel();
    }

    public List<QFilter> dateRangeFilter(TransferData transferData, String dateProperty) {
        List<QFilter> qFilters = this.baseQFilter(transferData.getSscid(), transferData.getUsergroup());
        DateRange dateRange = transferData.getDateRange();
        if (dateRange.getStartDate() != null) {
            qFilters.add(new QFilter(dateProperty, ">=", (Object)dateRange.getStartDate()));
        }
        if (dateRange.getEndDate() != null) {
            qFilters.add(new QFilter(dateProperty, "<", (Object)CommonUtils.nextDate(dateRange.getEndDate())));
        }
        return qFilters;
    }

    public List<QFilter> groupQFilter(TransferData transferData, String dateProperty) {
        List<QFilter> qFilters = this.dateRangeFilter(transferData, dateProperty);
        Map<String, Long> filterMap = transferData.getFilterMap();
        for (Map.Entry<String, Long> longEntry : filterMap.entrySet()) {
            if (longEntry.getKey().equals("usergroup") && !transferData.getUsergroup().equals(-1L)) continue;
            qFilters.add(new QFilter(longEntry.getKey(), "=", (Object)longEntry.getValue()));
        }
        return qFilters;
    }

    public List<QFilter> baseQFilter(TransferData transferData) {
        return this.baseQFilter(transferData.getSscid(), transferData.getUsergroup());
    }

    public List<QFilter> baseQFilter(Long sscid, Long usergroup) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("sscid", "=", (Object)sscid));
        if (!usergroup.equals(-1L)) {
            qFilters.add(new QFilter("usergroup", "=", (Object)usergroup));
        }
        return qFilters;
    }

    protected List<ItemModel> buildDatas(List<ItemModel> items) {
        if (items.isEmpty()) {
            return items;
        }
        Map<String, ItemModel> itemModelMap = items.stream().collect(Collectors.toMap(ItemModel::getItemname, o -> o));
        ItemModel itemModel = items.get(items.size() - 1);
        String itemname = itemModel.getItemname();
        ArrayList<ItemModel> results = new ArrayList<ItemModel>(items.size());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        LocalDate startDate = LocalDate.parse(itemname + "-01", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate pDate = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        for (int i = 0; i < 6 || pDate.getYear() * 100 + pDate.getMonthValue() >= startDate.getYear() * 100 + startDate.getMonthValue(); ++i) {
            String name = pDate.format(dateTimeFormatter);
            ItemModel item = itemModelMap.get(name);
            results.add(this.formatItem(item, null, name));
            pDate = pDate.minusMonths(1L);
        }
        return results;
    }

    protected List<String> getMonthList(Date startDate, Date endDate) {
        ArrayList<String> list = new ArrayList<String>(6);
        if (startDate == null || endDate == null) {
            return list;
        }
        for (int i = 0; i < 6 || !endDate.before(startDate); ++i) {
            String monthStr = DateUtil.format(endDate, "yyyy-MM");
            list.add(monthStr);
            endDate = DateUtil.addMonth(DateUtil.getFirstDayOfMonth(endDate), -1);
        }
        return list;
    }

    public ItemModel formatItem(ItemModel item, Long id, String name) {
        return this.emptyItem(id, name);
    }

    public ItemModel emptyItem(Long id, String name) {
        ItemModel item = new ItemModel();
        item.setGroupid(id);
        item.setItemname(name);
        item.setItemvalue("-");
        return item;
    }

    protected List<ItemModel> fillDatas(Long sscid, Long usergroup, String groupby, List<ItemModel> datas) {
        if (datas.isEmpty()) {
            return datas;
        }
        Map<Long, ItemModel> resultMap = datas.stream().collect(Collectors.toMap(ItemModel::getGroupid, o -> o));
        Set<Long> ids = datas.stream().mapToLong(ItemModel::getGroupid).boxed().collect(Collectors.toSet());
        List<DynamicObject> baseData = BaseDataHelper.getBaseData(groupby, usergroup, sscid, ids);
        assert (baseData != null);
        return baseData.stream().map(dynamicObject -> {
            long id = dynamicObject.getLong("id");
            String name = dynamicObject.getString("name");
            ItemModel item = (ItemModel)resultMap.get(id);
            return this.formatItem(item, id, name);
        }).sorted().collect(Collectors.toList());
    }

    protected ItemModel readPortionTotal(DataSet dateSet) {
        ItemModel item = new ItemModel();
        if (dateSet.hasNext()) {
            Row row = dateSet.next();
            Integer portion = row.getInteger("portion");
            Integer total = row.getInteger("total");
            item.portionAndTotal(portion, total);
        }
        return item;
    }

    protected String percent(Integer partion, Integer total) {
        if (total == null || total == 0) {
            return "-";
        }
        return new BigDecimal(partion * 100).divide(new BigDecimal(total), 1, RoundingMode.HALF_UP) + "%";
    }
}

