/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.ssc.task.mobile.formplugin.CommonQueryHelper;
import kd.ssc.task.mobile.formplugin.PageUtils;
import kd.ssc.task.mobile.template.AbstractTemplatePlugin;
import kd.ssc.task.mobile.template.ITemplateDataProcess;
import kd.ssc.task.mobile.template.data.HeadDataModel;
import kd.ssc.task.mobile.template.data.TabContainerData;
import kd.ssc.task.mobile.template.data.TransferData;
import kd.ssc.task.mobile.utils.InvokeUtil;

public class DynamicTabTemplatePlugin
extends AbstractTemplatePlugin {
    public static final String FORMID = "ssc_dynamictab_template_m";
    private static final String TRANSFER_KEY = "transfer_key";
    protected static final String CTRL_TAB_AP = "tabap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(CTRL_TAB_AP);
        tab.addTabSelectListener(evt -> this.buildContainer(evt.getTabKey()));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TransferData transferData = this.getTransferData();
        this.initView(transferData);
        this.buildTab(transferData);
        this.loadData(transferData);
        this.buildContainer(null);
    }

    protected void initView(TransferData transferData) {
        Label label_sharecenter = (Label)this.getView().getControl("sharecenter");
        Label label_usergroup = (Label)this.getView().getControl("usergroup");
        Label label_time = (Label)this.getView().getControl("labeltime");
        label_sharecenter.setText(CommonQueryHelper.getShareCenterName(transferData.getSscid()));
        label_usergroup.setText(CommonQueryHelper.getUserGroupName(transferData.getUsergroup()));
        label_time.setText(transferData.getDateRange().getSpanTypeDesc());
    }

    protected void loadData(TransferData transferData) {
        ITemplateDataProcess process = (ITemplateDataProcess)InvokeUtil.getInstance(transferData.getDataProcessClassName());
        HeadDataModel headData = process.getTemplateHeadData(transferData);
        this.setHeadView(headData);
    }

    protected void setHeadView(HeadDataModel headData) {
        Label labelname = (Label)this.getView().getControl("labelname");
        Label labelvalue = (Label)this.getView().getControl("labelvalue");
        Label labelname1 = (Label)this.getView().getControl("labelname1");
        Label labelvalue1 = (Label)this.getView().getControl("labelvalue1");
        Label labelname2 = (Label)this.getView().getControl("labelname2");
        Label labelvalue2 = (Label)this.getView().getControl("labelvalue2");
        labelname.setText(headData.getName());
        labelvalue.setText(headData.getValue());
        labelname1.setText(headData.getName1());
        labelvalue1.setText(headData.getValue1());
        labelname2.setText(headData.getName2());
        labelvalue2.setText(headData.getValue2());
    }

    private void buildTab(TransferData transferData) {
        List<TabContainerData> tabs = transferData.getTabs();
        List tabControls = tabs.stream().map(tab -> {
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey(tab.getKey());
            tabPageAp.setName(new LocaleString(tab.getName()));
            return tabPageAp.createControl();
        }).collect(Collectors.toList());
        Tab tabAp = (Tab)this.getView().getControl(CTRL_TAB_AP);
        tabAp.addControls(tabControls);
    }

    private void buildContainer(String tabKey) {
        String str = (String)this.getView().getFormShowParameter().getCustomParam(TRANSFER_KEY);
        TransferData param = (TransferData)SerializationUtils.fromJsonString((String)str, TransferData.class);
        List<TabContainerData> tabs = param.getTabs();
        TabContainerData tab = null;
        if (tabKey == null) {
            tab = tabs.get(0);
        } else {
            for (TabContainerData tabContainerData : tabs) {
                if (!tabKey.equals(tabContainerData.getKey())) continue;
                tab = tabContainerData;
                break;
            }
        }
        Container containerAp = (Container)this.getView().getControl("containerap");
        String formId = this.getView().getPageCache().get("setTargetKey");
        if (formId != null) {
            containerAp.deleteControls(new String[]{formId});
        }
        FlexPanelAp flex = new FlexPanelAp();
        assert (tab != null);
        flex.setKey(tab.getFormId());
        containerAp.addControls(Collections.singletonList(flex.createControl()));
        this.getView().getPageCache().put("setTargetKey", tab.getFormId());
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(tab.getFormId());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(tab.getFormId());
        param.setKey(tab.getKey());
        showParameter.setCustomParam(TRANSFER_KEY, (Object)SerializationUtils.toJsonString((Object)param));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private TransferData getTransferData() {
        String str = (String)this.getView().getFormShowParameter().getCustomParam(TRANSFER_KEY);
        return (TransferData)SerializationUtils.fromJsonString((String)str, TransferData.class);
    }

    public static void jumpMeBy(IFormView formView, String caption, TransferData transferData) {
        IFormView targetPageView;
        if (caption == null && (targetPageView = PageUtils.getTargetPageView(formView, FORMID)) != null) {
            caption = targetPageView.getFormShowParameter().getCaption();
        }
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCaption(caption);
        parameter.setCustomParam(TRANSFER_KEY, (Object)SerializationUtils.toJsonString((Object)transferData));
        formView.showForm((FormShowParameter)parameter);
    }
}

