/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.ssc.task.mobile.template.data.SelectItemData;

public class SelectListModalPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    public static final String FORMID = "ssc_selectlist_modal_m";
    public static final String KEY_PARAMS = "selectlistdata";
    public static final String ENTRYENTITY = "entryentity";
    public static final String ENTRY_ITEM_NAME = "itemname";
    private static final String ENTRY_ITEM_ID = "itemid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entryentity = (CardEntry)this.getControl(ENTRYENTITY);
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String str = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PARAMS);
        List list = SerializationUtils.fromJsonStringToList((String)str, SelectItemData.class);
        this.setListPanel(list);
    }

    protected void setListPanel(List<?> datas) {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        int size = datas.size();
        if (size > 0) {
            model.beginInit();
            model.batchCreateNewEntryRow(ENTRYENTITY, size);
            DynamicObjectCollection dynamicObjects = model.getEntryEntity(ENTRYENTITY);
            DynamicProperty itemid = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_ID);
            DynamicProperty itemname = dynamicObjects.getDynamicObjectType().getProperty(ENTRY_ITEM_NAME);
            for (int i = 0; i < size; ++i) {
                SelectItemData item = (SelectItemData)datas.get(i);
                DynamicObject entry = (DynamicObject)dynamicObjects.get(i);
                itemid.setValueFast((Object)entry, (Object)item.getId());
                itemname.setValueFast((Object)entry, (Object)item.getName());
            }
            model.endInit();
        }
        this.getView().updateView(ENTRYENTITY);
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (ENTRYENTITY.equals(key)) {
            int currIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(currIndex);
            String id = dynamicObject.getString(ENTRY_ITEM_ID);
            String str = (String)this.getView().getFormShowParameter().getCustomParam(KEY_PARAMS);
            List list = SerializationUtils.fromJsonStringToList((String)str, SelectItemData.class);
            for (Object o : list) {
                SelectItemData data = (SelectItemData)o;
                if (!data.getId().equals(id)) continue;
                this.getView().returnDataToParent((Object)data);
            }
            this.getView().close();
        }
    }

    public static void jumpMeBy(AbstractFormPlugin plugin, String actionId, List<SelectItemData> datas) {
        MobileFormShowParameter parameter = new MobileFormShowParameter();
        parameter.setFormId(FORMID);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(KEY_PARAMS, (Object)SerializationUtils.toJsonString(datas));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
        plugin.getView().showForm((FormShowParameter)parameter);
    }
}

