/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template.datespan;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import kd.ssc.task.mobile.common.MultiLangEnumBridge;
import kd.ssc.task.mobile.template.datespan.DateRangePO;
import kd.ssc.task.mobile.utils.CommonUtils;

public enum DateSpanEnum {
    TODAY("today", new MultiLangEnumBridge("\u4eca\u65e5", "DateSpanEnum_0", "ssc-task-mobile")),
    CURRENT_WEEK("current_week", new MultiLangEnumBridge("\u672c\u5468", "DateSpanEnum_1", "ssc-task-mobile")),
    CURRENT_MONTH("current_month", new MultiLangEnumBridge("\u672c\u6708", "DateSpanEnum_2", "ssc-task-mobile")),
    CURRENT_YEAR("current_year", new MultiLangEnumBridge("\u672c\u5e74", "DateSpanEnum_3", "ssc-task-mobile")),
    LAST_MONTH("last_month", new MultiLangEnumBridge("\u4e0a\u6708", "DateSpanEnum_4", "ssc-task-mobile")),
    LAST_YEAR("last_year", new MultiLangEnumBridge("\u53bb\u5e74", "DateSpanEnum_5", "ssc-task-mobile")),
    UNLIMIT("unlimit", new MultiLangEnumBridge("\u4e0d\u9650", "DateSpanEnum_6", "ssc-task-mobile")),
    CUSTOM("custom", new MultiLangEnumBridge("\u81ea\u5b9a\u4e49", "DateSpanEnum_7", "ssc-task-mobile"));

    private final String number;
    private final MultiLangEnumBridge bridge;

    private DateSpanEnum(String number, MultiLangEnumBridge bridge) {
        this.number = number;
        this.bridge = bridge;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public static String getNameByNumber(String name) {
        for (DateSpanEnum dateSpan : DateSpanEnum.values()) {
            if (!dateSpan.getNumber().equals(name)) continue;
            return dateSpan.getName();
        }
        return "";
    }

    public static DateRangePO getDateSpanByType(String DateSpanType) {
        Date startDate = new Date();
        Date endDate = new Date();
        switch (DateSpanType) {
            case "today": {
                startDate = CommonUtils.localDate2Date(LocalDate.now());
                endDate = CommonUtils.localDate2Date(LocalDate.now());
                break;
            }
            case "current_week": {
                startDate = CommonUtils.localDate2Date(LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)));
                endDate = CommonUtils.localDate2Date(LocalDate.now().with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)));
                break;
            }
            case "current_month": {
                startDate = CommonUtils.localDate2Date(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()));
                endDate = CommonUtils.localDate2Date(LocalDate.now().with(TemporalAdjusters.firstDayOfNextMonth()).minus(1L, ChronoUnit.DAYS));
                break;
            }
            case "current_year": {
                startDate = CommonUtils.localDate2Date(LocalDate.now().with(TemporalAdjusters.firstDayOfYear()));
                endDate = CommonUtils.localDate2Date(LocalDate.now().with(TemporalAdjusters.firstDayOfNextYear()).minus(1L, ChronoUnit.DAYS));
                break;
            }
            case "last_month": {
                startDate = CommonUtils.localDate2Date(LocalDate.now().minus(1L, ChronoUnit.MONTHS).with(TemporalAdjusters.firstDayOfMonth()));
                endDate = CommonUtils.localDate2Date(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()).minus(1L, ChronoUnit.DAYS));
                break;
            }
            case "last_year": {
                startDate = CommonUtils.localDate2Date(LocalDate.now().minus(1L, ChronoUnit.YEARS).with(TemporalAdjusters.firstDayOfYear()));
                endDate = CommonUtils.localDate2Date(LocalDate.now().with(TemporalAdjusters.firstDayOfYear()).minus(1L, ChronoUnit.DAYS));
                break;
            }
            case "unlimit": {
                startDate = null;
                endDate = null;
            }
        }
        DateRangePO dateRangePO = new DateRangePO();
        dateRangePO.setStartDate(startDate);
        dateRangePO.setEndDate(endDate);
        return dateRangePO;
    }
}

