/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template.datespan;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.ssc.task.mobile.template.datespan.DateRangePO;
import kd.ssc.task.mobile.template.datespan.DateSpanEnum;
import kd.ssc.task.mobile.template.datespan.DateSpanPO;

public class DateSpanSelectFormPlugin
extends AbstractMobFormPlugin {
    private static final Log log = LogFactory.getLog(DateSpanSelectFormPlugin.class);
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm_button", "datetime_close"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        String dateSpanType = dateSpanPO.getDateSpanType();
        Date startSpanDate = dateSpanPO.getStartDateSpan();
        Date endSpanDate = dateSpanPO.getEndDateSpan();
        this.getPageCache().put("oldDateSpanType", dateSpanType);
        this.getPageCache().put("oldStartDateSpanStr", startSpanDate == null ? null : this.simpleDateFormat.format(startSpanDate));
        this.getPageCache().put("oldEndDateSpanStr", endSpanDate == null ? null : this.simpleDateFormat.format(endSpanDate));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initializeDefaultDateSpan();
    }

    private void initializeDefaultDateSpan() {
        String defaultDateSpan = this.getDefaultDateSpanStr();
        if (DateSpanEnum.CUSTOM.getNumber().equals(defaultDateSpan)) {
            this.fillExistCustomDateSpan();
            this.getModel().setValue("datespan_radio", null);
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("datespan_radio", (Object)defaultDateSpan);
            this.getModel().endInit();
            this.fillCustomDateSpan(DateSpanEnum.getDateSpanByType(defaultDateSpan));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("confirm_button".equals(key)) {
            String newDateSpanType = (String)this.getModel().getValue("datespan_radio");
            HashMap<String, Object> returnDataMap = this.packageReturnDataMap(newDateSpanType);
            String oldDateSpanType = this.getPageCache().get("oldDateSpanType");
            String oldStartDateSpanStr = this.getPageCache().get("oldStartDateSpanStr");
            String oldEndDateSpanStr = this.getPageCache().get("oldEndDateSpanStr");
            Date newStartTime = (Date)returnDataMap.get("startTime");
            Date newEndTime = (Date)returnDataMap.get("endTime");
            if (StringUtils.equals((CharSequence)newDateSpanType, (CharSequence)oldDateSpanType) && !DateSpanEnum.CUSTOM.getNumber().equals(oldDateSpanType)) {
                this.getView().close();
            } else if (StringUtils.equals((CharSequence)newDateSpanType, (CharSequence)oldDateSpanType) && DateSpanEnum.CUSTOM.getNumber().equals(oldDateSpanType)) {
                assert (oldStartDateSpanStr != null);
                if (!oldStartDateSpanStr.equals(this.simpleDateFormat.format(newStartTime)) || !oldEndDateSpanStr.equals(this.simpleDateFormat.format(newEndTime))) {
                    this.getView().returnDataToParent(returnDataMap);
                }
                this.getView().close();
            } else {
                this.getView().returnDataToParent(returnDataMap);
                this.getView().close();
            }
        } else if ("datetime_close".equals(key)) {
            this.getView().close();
        }
    }

    private HashMap<String, Object> packageReturnDataMap(String newDateSpanType) {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)newDateSpanType)) {
            DateRangePO rangePO = DateSpanEnum.getDateSpanByType(newDateSpanType);
            returnDataMap.put("dateSpanType", newDateSpanType);
            if (rangePO.getStartDate() != null) {
                returnDataMap.put("startTime", rangePO.getStartDate());
            }
            if (rangePO.getEndDate() != null) {
                returnDataMap.put("endTime", rangePO.getEndDate());
            }
        } else {
            DateRangeEdit custom = (DateRangeEdit)this.getControl("custom");
            String startDateFieldKey = custom.getStartDateFieldKey();
            String endDateFieldKey = custom.getEndDateFieldKey();
            returnDataMap.put("dateSpanType", DateSpanEnum.CUSTOM.getNumber());
            returnDataMap.put("startTime", this.getModel().getValue(startDateFieldKey));
            returnDataMap.put("endTime", this.getModel().getValue(endDateFieldKey));
        }
        return returnDataMap;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        String dateSpan = (String)this.getModel().getValue("datespan_radio");
        if ("datespan_radio".equals(propName) && StringUtils.isNotBlank((CharSequence)dateSpan)) {
            this.getModel().beginInit();
            this.fillCustomDateSpan(DateSpanEnum.getDateSpanByType(dateSpan));
            this.getModel().endInit();
            this.getView().updateView("custom");
        } else if ("daterangefield_startdate".equals(propName) || "daterangefield_enddate".equals(propName)) {
            this.getModel().setValue("datespan_radio", null);
        }
    }

    private void fillCustomDateSpan(DateRangePO dateRangePO) {
        DateRangeEdit custom = (DateRangeEdit)this.getControl("custom");
        String startDateFieldKey = custom.getStartDateFieldKey();
        String endDateFieldKey = custom.getEndDateFieldKey();
        if (dateRangePO.getStartDate() != null && dateRangePO.getEndDate() != null) {
            this.getModel().setValue(startDateFieldKey, (Object)dateRangePO.getStartDate());
            this.getModel().setValue(endDateFieldKey, (Object)dateRangePO.getEndDate());
        } else {
            this.getModel().setValue(startDateFieldKey, null);
            this.getModel().setValue(endDateFieldKey, null);
        }
    }

    private void fillExistCustomDateSpan() {
        DateRangeEdit custom = (DateRangeEdit)this.getControl("custom");
        String startDateFieldKey = custom.getStartDateFieldKey();
        String endDateFieldKey = custom.getEndDateFieldKey();
        DateSpanPO dateSpanPO = this.getDateSpanPO();
        this.getModel().setValue(startDateFieldKey, (Object)dateSpanPO.getStartDateSpan());
        this.getModel().setValue(endDateFieldKey, (Object)dateSpanPO.getEndDateSpan());
    }

    private String getDefaultDateSpanStr() {
        String dateSpanType = this.getDateSpanPO().getDateSpanType();
        return StringUtils.isBlank((CharSequence)dateSpanType) ? DateSpanEnum.TODAY.getNumber() : dateSpanType;
    }

    protected DateSpanPO getDateSpanPO() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("span_date_type");
        String startSpanDateStr = (String)this.getView().getFormShowParameter().getCustomParam("start_span_date");
        String endSpanDateStr = (String)this.getView().getFormShowParameter().getCustomParam("end_span_date");
        Date start = null;
        Date end = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)startSpanDateStr)) {
                start = this.simpleDateFormat.parse(startSpanDateStr);
            }
            if (StringUtils.isNotBlank((CharSequence)endSpanDateStr)) {
                end = this.simpleDateFormat.parse(endSpanDateStr);
            }
        }
        catch (ParseException e) {
            log.error("\u65f6\u95f4Date\u89e3\u6790\u9519\u8bef \uff1a" + e.getMessage());
        }
        return new DateSpanPO(type, start, end);
    }
}

