/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template.datespan;

import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import kd.ssc.task.mobile.template.datespan.IDateRange;
import kd.ssc.task.mobile.utils.CommonUtils;

public class DateSpanWrapper {
    private Date linkStartDate;
    private Date linkEndDate;
    private Date previousStartDate;
    private Date previousEndDate;
    private int dateType = 0;

    public DateSpanWrapper(IDateRange dateRange) {
        this(dateRange.getStartDate(), dateRange.getEndDate());
    }

    public DateSpanWrapper(Date startDate, Date endDate) {
        LocalDate endlocalDate;
        if (startDate == null || endDate == null) {
            if (startDate == null && endDate == null) {
                this.dateType = 3;
            }
            return;
        }
        LocalDate startlocalDate = CommonUtils.date2LocalDate(startDate);
        if (DateSpanWrapper.iswholeYear(startlocalDate, endlocalDate = CommonUtils.date2LocalDate(endDate))) {
            this.linkStartDate = CommonUtils.localDate2Date(startlocalDate.minusYears(1L).with(TemporalAdjusters.firstDayOfYear()));
            this.linkEndDate = CommonUtils.localDate2Date(endlocalDate.minusYears(1L).with(TemporalAdjusters.lastDayOfYear()));
            this.dateType = 2;
        } else if (DateSpanWrapper.iswholeMonth(startlocalDate, endlocalDate)) {
            this.linkStartDate = CommonUtils.localDate2Date(startlocalDate.minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth()));
            this.linkEndDate = CommonUtils.localDate2Date(endlocalDate.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()));
            this.previousStartDate = CommonUtils.localDate2Date(startlocalDate.minusYears(1L).with(TemporalAdjusters.firstDayOfMonth()));
            this.previousEndDate = CommonUtils.localDate2Date(endlocalDate.minusYears(1L).with(TemporalAdjusters.lastDayOfMonth()));
            this.dateType = 1;
        }
    }

    public static boolean iswholeMonth(LocalDate startDate, LocalDate endDate) {
        return startDate.equals(startDate.with(TemporalAdjusters.firstDayOfMonth())) && endDate.equals(startDate.with(TemporalAdjusters.lastDayOfMonth()));
    }

    public static boolean iswholeYear(LocalDate startDate, LocalDate endDate) {
        return startDate.equals(startDate.with(TemporalAdjusters.firstDayOfYear())) && endDate.equals(startDate.with(TemporalAdjusters.lastDayOfYear()));
    }

    public Date getLinkStartDate() {
        return this.linkStartDate;
    }

    public Date getLinkEndDate() {
        return this.linkEndDate;
    }

    public Date getPreviousStartDate() {
        return this.previousStartDate;
    }

    public void setPreviousStartDate(Date previousStartDate) {
        this.previousStartDate = previousStartDate;
    }

    public Date getPreviousEndDate() {
        return this.previousEndDate;
    }

    public void setPreviousEndDate(Date previousEndDate) {
        this.previousEndDate = previousEndDate;
    }

    public int getDateType() {
        return this.dateType;
    }

    public boolean canCompareToAvg() {
        return this.dateType == 0 || this.dateType == 1 || this.dateType == 2;
    }

    public boolean canCompareToLink() {
        return this.dateType == 1 || this.dateType == 2;
    }
}

