/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.template.enums;

import java.util.List;
import kd.bos.exception.KDBizException;
import kd.ssc.task.mobile.common.MultiLangEnumBridge;
import kd.ssc.task.mobile.template.data.GroupData;

public enum BaseDataEnum {
    USERGROUP("usergroup", new MultiLangEnumBridge("\u7528\u6237\u7ec4", "BaseDataEnum_0", "ssc-task-mobile")),
    ORGID("orgid", new MultiLangEnumBridge("\u7ec4\u7ec7", "BaseDataEnum_1", "ssc-task-mobile")),
    BILLTYPE("billType", new MultiLangEnumBridge("\u4e1a\u52a1\u5355\u636e", "BaseDataEnum_2", "ssc-task-mobile")),
    PERSONID("personid", new MultiLangEnumBridge("\u7528\u6237", "BaseDataEnum_3", "ssc-task-mobile"));

    private final String code;
    private final MultiLangEnumBridge name;

    private BaseDataEnum(String code, MultiLangEnumBridge name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public static BaseDataEnum get(String code) {
        for (BaseDataEnum enums : BaseDataEnum.values()) {
            if (!enums.getCode().equals(code)) continue;
            return enums;
        }
        throw new KDBizException("not exsit BaseDataEnum by " + code);
    }

    public static BaseDataEnum get(List<String> groupBys) {
        BaseDataEnum[] baseDataEnums;
        if (groupBys == null || groupBys.isEmpty()) {
            return ORGID;
        }
        String groupBy = groupBys.get(groupBys.size() - 1);
        for (BaseDataEnum baseDataEnum : baseDataEnums = BaseDataEnum.values()) {
            if (!groupBy.equals(baseDataEnum.code)) continue;
            return baseDataEnum;
        }
        return ORGID;
    }

    public GroupData toData() {
        return new GroupData(this.getCode(), this.getName());
    }
}

