/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CommonUtils {
    public static Date localDate2Date(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static LocalDate date2LocalDate(Date date) {
        if (null == date) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Map<String, Object> createDateRange(Date startDate, Date endDate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startDate", startDate);
        map.put("endDate", CommonUtils.nextDate(endDate));
        return map;
    }

    public static Date nextDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        return cal.getTime();
    }

    public static long toLong(String str) {
        return CommonUtils.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException var4) {
            return defaultValue;
        }
    }

    public static BigDecimal divide(Integer dividend, Integer divisor, int scale) {
        if (divisor == null || divisor == 0) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(dividend).divide(new BigDecimal(divisor), scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal dividePercent(Integer dividend, Integer divisor, int scale) {
        if (divisor == null || divisor == 0) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(dividend).multiply(new BigDecimal(100)).divide(new BigDecimal(divisor), scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal ratio(Integer dividend, Integer divisor) {
        if (divisor == null || divisor == 0) {
            return null;
        }
        return new BigDecimal(dividend).divide(new BigDecimal(divisor), 6, RoundingMode.HALF_UP);
    }

    public static BigDecimal compareRatio(BigDecimal thisData, BigDecimal priviousData) {
        BigDecimal yoyRatio = null;
        if (priviousData != null && thisData != null) {
            if (BigDecimal.ZERO.compareTo(priviousData) != 0) {
                yoyRatio = BigDecimal.ZERO.compareTo(thisData) != 0 ? thisData.subtract(priviousData).divide(priviousData, 4, 4) : new BigDecimal("-1");
            } else if (BigDecimal.ZERO.compareTo(thisData) == 0) {
                yoyRatio = new BigDecimal("0");
            }
        }
        return yoyRatio;
    }
}

