/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.utils;

import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.ssc.task.mobile.utils.CommonUtils;
import kd.ssc.task.mobile.utils.DateUtil;

public class DateSpanCommonUtils {
    public static QFilter timeSection(String property, LocalDate startTime, LocalDate endTime) {
        if (endTime == null) {
            if (startTime == null) {
                return null;
            }
            return QFilter.of((String)(property + " >= ?"), (Object[])new Object[]{startTime});
        }
        if (startTime == null) {
            return QFilter.of((String)(property + " <= ?"), (Object[])new Object[]{endTime.plusDays(1L)});
        }
        return QFilter.of((String)(property + " >= ? and " + property + " < ?"), (Object[])new Object[]{startTime, endTime.plusDays(1L)});
    }

    public static QFilter timeSection(String property, Date startTime, Date endTime) {
        if (endTime == null) {
            if (startTime == null) {
                return null;
            }
            return QFilter.of((String)(property + " >= ?"), (Object[])new Object[]{startTime});
        }
        if (startTime == null) {
            return QFilter.of((String)(property + " <= ?"), (Object[])new Object[]{DateUtil.addDay(endTime, 1L)});
        }
        return QFilter.of((String)(property + " >= ? and " + property + " < ?"), (Object[])new Object[]{startTime, DateUtil.addDay(endTime, 1L)});
    }

    public static DataSet filterDataSet(DataSet dataSet, String property, Date startDate, Date endDate) {
        if (startDate != null || endDate != null) {
            Map<String, Object> dateRange = CommonUtils.createDateRange(startDate, endDate);
            if (endDate == null) {
                return dataSet.filter(property + " >= startDate", dateRange);
            }
            if (startDate == null) {
                return dataSet.filter(property + " < endDate", dateRange);
            }
            return dataSet.filter(property + " >= startDate and " + property + " < endDate ", dateRange);
        }
        return dataSet;
    }
}

