/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.mobile.utils;

import kd.bos.context.RequestContext;
import kd.bos.entity.AppMetadataCache;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;

public class OperationLogUtil {
    private static final String APP_ID = AppMetadataCache.getAppInfo((String)"ssc").getId();

    private OperationLogUtil() {
    }

    public static AppLogInfo buildLogInfo(String opName, String opDescription, String bizAppId, String bizEntityNumber) {
        RequestContext context = RequestContext.get();
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(context.getCurrUserId()));
        logInfo.setBizAppID(bizAppId);
        logInfo.setBizObjID(bizEntityNumber);
        logInfo.setOrgID(Long.valueOf(context.getOrgId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(context.getClient());
        logInfo.setClientIP(context.getLoginIP());
        logInfo.setClientName(context.getClient());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(opDescription);
        return logInfo;
    }

    public static void log(String opName, String opDescription, String bizEntityNumber) {
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        service.addLog(OperationLogUtil.buildLogInfo(opName, opDescription, APP_ID, bizEntityNumber));
    }
}

