/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.eas;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.ssc.task.eas.EasWebServiceClient;
import kd.ssc.task.eas.axis.EASLoginProxyServiceStub;

public class EASConfig {
    private static Log log = LogFactory.getLog(EASConfig.class);
    private String IP;
    private String Port;
    private String UserName;
    private String Password;
    private String Solution;
    private String DataCenter;
    private String Language;
    private int DbType = 0;

    public String getIP() {
        return this.IP;
    }

    public void setIP(String iP) {
        this.IP = iP;
    }

    public String getPort() {
        return this.Port;
    }

    public void setPort(String port) {
        this.Port = port;
    }

    public String getUserName() {
        return this.UserName;
    }

    public void setUserName(String userName) {
        this.UserName = userName;
    }

    public String getPassword() {
        return this.Password;
    }

    public void setPassword(String password) {
        this.Password = password;
    }

    public String getSolution() {
        return this.Solution;
    }

    public void setSolution(String solution) {
        this.Solution = solution;
    }

    public String getDataCenter() {
        return this.DataCenter;
    }

    public void setDataCenter(String dataCenter) {
        this.DataCenter = dataCenter;
    }

    public String getLanguage() {
        return this.Language;
    }

    public void setLanguage(String language) {
        this.Language = language;
    }

    public int getDbType() {
        return this.DbType;
    }

    public void setDbType(int dbType) {
        this.DbType = dbType;
    }

    public static EASConfig getConfig() {
        ORM orm = ORM.create();
        DynamicObject easConfig = orm.queryOne("bas_easconfig", null);
        EASConfig eas = new EASConfig();
        eas.setIP(easConfig.get("ip").toString());
        eas.setLanguage(easConfig.get("language").toString());
        eas.setUserName(easConfig.get("username").toString());
        eas.setDbType(Integer.parseInt(easConfig.get("dbtype").toString()));
        eas.setSolution(easConfig.get("solution").toString());
        eas.setPort(easConfig.get("port").toString());
        eas.setDataCenter(easConfig.get("datacenter").toString());
        eas.setPassword(easConfig.get("password").toString());
        return eas;
    }

    public static EASLoginProxyServiceStub.WSContext loginEAS(EASConfig eas) {
        EASLoginProxyServiceStub.WSContext result = null;
        try {
            EasWebServiceClient call = EasWebServiceClient.getInstance();
            result = call.callMethodForEASLogin(eas);
            log.info("\u767b\u9646EAS,\u8fd4\u56de\u7ed3\u679c:" + result.getUserName() + "," + result.getSlnName());
        }
        catch (Exception e) {
            log.error("\u5de5\u4f5c\u6d41\u767b\u9646EAS\u5931\u8d25:" + e.getMessage() + "==" + e.getLocalizedMessage());
            throw new KDException((Throwable)e, new ErrorCode("fi.ssc.LoginEasException", String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u767b\u5f55EAS\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"EASConfig_0", (String)"ssc-task-ext", (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
        return result;
    }
}

